/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isAbstract(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceMethod(member)) {
            return true;
        }
        return Flags.isAbstract((int)member.getFlags());
    }

    public static boolean isAbstract(IMethodBinding member) {
        if (JdtFlags.isInterfaceMember((IBinding)member)) {
            return true;
        }
        return Modifier.isAbstract((int)member.getModifiers());
    }

    public static boolean isDeprecated(IMember member) throws JavaModelException {
        return Flags.isDeprecated((int)member.getFlags());
    }

    public static boolean isFinal(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceField(member)) {
            return true;
        }
        if (JdtFlags.isAnonymousType(member)) {
            return true;
        }
        return Flags.isFinal((int)member.getFlags());
    }

    public static boolean isNative(IMember member) throws JavaModelException {
        return Flags.isNative((int)member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws JavaModelException {
        return !JdtFlags.isPrivate(member) && !JdtFlags.isProtected(member) && !JdtFlags.isPublic(member);
    }

    public static boolean isPackageVisible(BodyDeclaration bodyDeclaration) {
        return !JdtFlags.isPrivate(bodyDeclaration) && !JdtFlags.isProtected(bodyDeclaration) && !JdtFlags.isPublic(bodyDeclaration);
    }

    public static boolean isPackageVisible(IBinding binding) {
        return !JdtFlags.isPrivate(binding) && !JdtFlags.isProtected(binding) && !JdtFlags.isPublic(binding);
    }

    public static boolean isPrivate(IMember member) throws JavaModelException {
        return Flags.isPrivate((int)member.getFlags());
    }

    public static boolean isPrivate(BodyDeclaration bodyDeclaration) {
        return Modifier.isPrivate((int)bodyDeclaration.getModifiers());
    }

    public static boolean isPrivate(IBinding binding) {
        return Modifier.isPrivate((int)binding.getModifiers());
    }

    public static boolean isProtected(IMember member) throws JavaModelException {
        return Flags.isProtected((int)member.getFlags());
    }

    public static boolean isProtected(BodyDeclaration bodyDeclaration) {
        return Modifier.isProtected((int)bodyDeclaration.getModifiers());
    }

    public static boolean isProtected(IBinding binding) {
        return Modifier.isProtected((int)binding.getModifiers());
    }

    public static boolean isPublic(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceMember(member)) {
            return true;
        }
        return Flags.isPublic((int)member.getFlags());
    }

    public static boolean isPublic(IBinding binding) {
        if (JdtFlags.isInterfaceMember(binding)) {
            return true;
        }
        return Modifier.isPublic((int)binding.getModifiers());
    }

    public static boolean isPublic(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isInterfaceMember(bodyDeclaration)) {
            return true;
        }
        return Modifier.isPublic((int)bodyDeclaration.getModifiers());
    }

    public static boolean isStatic(IMember member) throws JavaModelException {
        if (JdtFlags.isNestedInterface(member)) {
            return true;
        }
        if (member.getElementType() != 9 && JdtFlags.isInterfaceMember(member)) {
            return true;
        }
        return Flags.isStatic((int)member.getFlags());
    }

    public static boolean isStatic(IMethodBinding methodBinding) {
        return Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static boolean isStatic(IVariableBinding variableBinding) {
        if (JdtFlags.isInterfaceMember((IBinding)variableBinding)) {
            return true;
        }
        return Modifier.isStatic((int)variableBinding.getModifiers());
    }

    public static boolean isStrictfp(IMember member) throws JavaModelException {
        return Flags.isStrictfp((int)member.getFlags());
    }

    public static boolean isSynchronized(IMember member) throws JavaModelException {
        return Flags.isSynchronized((int)member.getFlags());
    }

    public static boolean isSynthetic(IMember member) throws JavaModelException {
        return Flags.isSynthetic((int)member.getFlags());
    }

    public static boolean isTransient(IMember member) throws JavaModelException {
        return Flags.isTransient((int)member.getFlags());
    }

    public static boolean isVolatile(IMember member) throws JavaModelException {
        return Flags.isVolatile((int)member.getFlags());
    }

    private static boolean isInterfaceMethod(IMember member) throws JavaModelException {
        return member.getElementType() == 9 && JdtFlags.isInterfaceMember(member);
    }

    private static boolean isInterfaceField(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isInterfaceMember(member);
    }

    private static boolean isInterfaceMember(IMember member) throws JavaModelException {
        return member.getDeclaringType() != null && member.getDeclaringType().isInterface();
    }

    private static boolean isInterfaceMember(IBinding binding) {
        ITypeBinding declaringType = null;
        if (binding instanceof IVariableBinding) {
            declaringType = ((IVariableBinding)binding).getDeclaringClass();
        } else if (binding instanceof IMethodBinding) {
            declaringType = ((IMethodBinding)binding).getDeclaringClass();
        } else if (binding instanceof ITypeBinding) {
            declaringType = ((ITypeBinding)binding).getDeclaringClass();
        }
        return declaringType != null && declaringType.isInterface();
    }

    private static boolean isInterfaceMember(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.getParent() instanceof TypeDeclaration && ((TypeDeclaration)bodyDeclaration.getParent()).isInterface();
    }

    private static boolean isNestedInterface(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && member.getDeclaringType() != null && ((IType)member).isInterface();
    }

    private static boolean isAnonymousType(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && ((IType)member).isAnonymous();
    }

    public static int getVisibilityCode(IMember member) throws JavaModelException {
        if (JdtFlags.isPublic(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 0;
        }
        if (JdtFlags.isPrivate(member)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static int getVisibilityCode(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isPublic(bodyDeclaration)) {
            return 1;
        }
        if (JdtFlags.isProtected(bodyDeclaration)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(bodyDeclaration)) {
            return 0;
        }
        if (JdtFlags.isPrivate(bodyDeclaration)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static int getVisibilityCode(IBinding binding) {
        if (JdtFlags.isPublic(binding)) {
            return 1;
        }
        if (JdtFlags.isProtected(binding)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(binding)) {
            return 0;
        }
        if (JdtFlags.isPrivate(binding)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static String getVisibilityString(int visibilityCode) {
        if (Modifier.isPublic((int)visibilityCode)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected((int)visibilityCode)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate((int)visibilityCode)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JdtFlags.assertVisibility(oldVisibility);
        JdtFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 0 || newVisibility == 1 || newVisibility == 4;
            }
            case 0: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue(false);
        return false;
    }

    public static int getLowerVisibility(int visibility1, int visibility2) {
        if (JdtFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility2;
        }
        return visibility1;
    }

    public static int clearAccessModifiers(int flags) {
        return JdtFlags.clearFlag(7, flags);
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }
}

