/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.stringsubstitution;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectedResourceManager
implements IWindowListener,
ISelectionListener {
    private static SelectedResourceManager fgDefault;
    private IResource fSelectedResource = null;
    private String fSelectedText = null;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    private SelectedResourceManager() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            workbench.addWindowListener((IWindowListener)this);
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            if (activeWindow != null) {
                this.windowActivated(activeWindow);
            }
        }
    }

    public static SelectedResourceManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectedResourceManager();
        }
        return fgDefault;
    }

    public void windowActivated(IWorkbenchWindow window) {
        ISelection selection;
        IWorkbenchPart part;
        ISelectionService service = window.getSelectionService();
        service.addSelectionListener((ISelectionListener)this);
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (part = page.getActivePart()) != null && (selection = service.getSelection()) != null) {
            this.selectionChanged(part, selection);
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IResource selectedResource = null;
        if (selection instanceof IStructuredSelection) {
            Object result = ((IStructuredSelection)selection).getFirstElement();
            if (result instanceof IResource) {
                selectedResource = (IResource)result;
            } else if (result instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)result).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = SelectedResourceManager.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
            }
        }
        if (selectedResource == null && part instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            selectedResource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = SelectedResourceManager.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        if (selectedResource != null) {
            this.fSelectedResource = selectedResource;
        }
        if (selection instanceof ITextSelection) {
            this.fSelectedText = ((ITextSelection)selection).getText();
        }
    }

    public IResource getSelectedResource() {
        return this.fSelectedResource;
    }

    public String getSelectedText() {
        return this.fSelectedText;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

