/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.core.refactoring.JDTDebugRefactoringUtil;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class LaunchConfigurationProjectMainTypeChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private String fNewMainTypeName;
    private String fNewProjectName;
    private String fNewLaunchConfigurationName;
    private String fOldMainTypeName;
    private String fOldProjectName;
    private ILaunchConfiguration fNewLaunchConfiguration;
    private ILaunchConfigurationListener configurationListener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration launchConfiguration) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration oldConfig = manager.getMovedFrom(launchConfiguration);
            if (oldConfig != null && oldConfig == LaunchConfigurationProjectMainTypeChange.this.fLaunchConfiguration) {
                LaunchConfigurationProjectMainTypeChange.this.fNewLaunchConfiguration = launchConfiguration;
            }
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        }
    };

    public static Change createChangesForTypeRename(IType type, String newName) throws CoreException {
        IType declaringType = type.getDeclaringType();
        String newFullyQualifiedName = declaringType == null ? type.getPackageFragment().getElementName() + '.' + newName : declaringType.getFullyQualifiedName() + '$' + newName;
        return LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(type, newFullyQualifiedName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Change createChangesForTypeMove(IType type, IJavaElement destination) throws CoreException {
        void var4_4;
        String newFullyQualifiedName;
        IJavaProject projectDestination = destination.getJavaProject();
        String newProjectName = type.getJavaProject().equals(projectDestination) ? null : projectDestination.getElementName();
        if (destination instanceof IType) {
            newFullyQualifiedName = ((IType)destination).getFullyQualifiedName() + '$' + type.getElementName();
        } else if (destination instanceof IPackageFragment) {
            IPackageFragment destinationPackage = (IPackageFragment)destination;
            newFullyQualifiedName = destinationPackage.isDefaultPackage() ? type.getElementName() : destination.getElementName() + '.' + type.getElementName();
        } else {
            return null;
        }
        return LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(type, (String)var4_4, newProjectName);
    }

    public static Change createChangesForProjectRename(IJavaProject javaProject, String newProjectName) throws CoreException {
        String projectName = javaProject.getElementName();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForProjectRename(configs, projectName, newProjectName);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForProjectRename(configs, projectName, newProjectName));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.7"));
    }

    public static Change createChangesForPackageRename(IPackageFragment packageFragment, String newName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForPackageRename(configs, packageFragment, newName);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForPackageRename(configs, packageFragment, newName));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.7"));
    }

    public static Change createChangesForPackageMove(IPackageFragment packageFragment, IPackageFragmentRoot destination) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForPackageMove(configs, packageFragment, destination);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForPackageMove(configs, packageFragment, destination));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.7"));
    }

    private static Change createChangesForTypeChange(IType type, String newFullyQualifiedName, String newProjectName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(configs, type, newFullyQualifiedName, newProjectName);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(configs, type, newFullyQualifiedName, newProjectName));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.7"));
    }

    private static List createChangesForTypeChange(ILaunchConfiguration[] configs, IType type, String newFullyQualifiedName, String newProjectName) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        String typeName = type.getFullyQualifiedName();
        String projectName = type.getJavaProject().getElementName();
        for (int i = 0; i < configs.length; ++i) {
            String mainTypeName;
            ILaunchConfiguration launchConfiguration = configs[i];
            String lcProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
            if (!projectName.equals(lcProjectName) || !(mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null)).startsWith(typeName)) continue;
            if (typeName.equals(mainTypeName)) {
                changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, newFullyQualifiedName, newProjectName));
                continue;
            }
            Change change = LaunchConfigurationProjectMainTypeChange.createChangesForOuterTypeChange(launchConfiguration, type, newFullyQualifiedName, newProjectName);
            if (change == null) continue;
            changes.add(change);
        }
        return changes;
    }

    private static Change createChangesForOuterTypeChange(ILaunchConfiguration launchConfiguration, IType type, String newFullyQualifiedName, String newProjectName) throws CoreException {
        IType[] innerTypes = type.getTypes();
        String mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
        for (int i = 0; i < innerTypes.length; ++i) {
            IType innerType = innerTypes[i];
            String innerTypeName = innerType.getFullyQualifiedName();
            if (!mainTypeName.startsWith(innerTypeName)) continue;
            String newTypeName = newFullyQualifiedName + '$' + innerType.getElementName();
            if (innerTypeName.equals(mainTypeName)) {
                return new LaunchConfigurationProjectMainTypeChange(launchConfiguration, newTypeName, newProjectName);
            }
            return LaunchConfigurationProjectMainTypeChange.createChangesForOuterTypeChange(launchConfiguration, innerType, newTypeName, newProjectName);
        }
        return null;
    }

    private static List createChangesForProjectRename(ILaunchConfiguration[] configs, String projectName, String newProjectName) throws CoreException {
        ArrayList<LaunchConfigurationProjectMainTypeChange> changes = new ArrayList<LaunchConfigurationProjectMainTypeChange>();
        for (int i = 0; i < configs.length; ++i) {
            ILaunchConfiguration launchConfiguration = configs[i];
            String launchConfigurationProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
            if (!projectName.equals(launchConfigurationProjectName)) continue;
            changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, null, newProjectName));
        }
        return changes;
    }

    private static List createChangesForPackageRename(ILaunchConfiguration[] configs, IPackageFragment packageFragment, String newName) throws CoreException {
        ArrayList<LaunchConfigurationProjectMainTypeChange> changes = new ArrayList<LaunchConfigurationProjectMainTypeChange>();
        String packageFragmentName = packageFragment.getElementName();
        String projectName = packageFragment.getJavaProject().getElementName();
        for (int i = 0; i < configs.length; ++i) {
            String mainTypeName;
            int index;
            String packageName;
            ILaunchConfiguration launchConfiguration = configs[i];
            String lcProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
            if (!projectName.equals(lcProjectName) || !packageFragmentName.equals(packageName = (index = (mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null)).lastIndexOf(46)) < 0 ? "" : mainTypeName.substring(0, index))) continue;
            String newTypeName = newName + '.' + mainTypeName.substring(index + 1);
            changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, newTypeName, null));
        }
        return changes;
    }

    private static List createChangesForPackageMove(ILaunchConfiguration[] configs, IPackageFragment packageFragment, IPackageFragmentRoot destination) throws CoreException {
        ArrayList<LaunchConfigurationProjectMainTypeChange> changes = new ArrayList<LaunchConfigurationProjectMainTypeChange>();
        String packageFragmentName = packageFragment.getElementName();
        String projectName = packageFragment.getJavaProject().getElementName();
        for (int i = 0; i < configs.length; ++i) {
            String mainTypeName;
            int index;
            String packageName;
            ILaunchConfiguration launchConfiguration = configs[i];
            String lcProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
            if (!projectName.equals(lcProjectName) || !packageFragmentName.equals(packageName = (index = (mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null)).lastIndexOf(46)) < 0 ? "" : mainTypeName.substring(0, index))) continue;
            changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, null, destination.getJavaProject().getElementName()));
        }
        return changes;
    }

    private LaunchConfigurationProjectMainTypeChange(ILaunchConfiguration launchConfiguration, String newMainTypeName, String newProjectName) throws CoreException {
        this.fLaunchConfiguration = launchConfiguration;
        this.fNewLaunchConfiguration = launchConfiguration;
        this.fNewMainTypeName = newMainTypeName;
        this.fNewProjectName = newProjectName;
        this.fOldMainTypeName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
        this.fOldProjectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
        if (this.fNewMainTypeName != null) {
            String oldName = Signature.getSimpleName((String)this.fOldMainTypeName);
            String newName = Signature.getSimpleName((String)this.fNewMainTypeName);
            String launchConfigurationName = this.fLaunchConfiguration.getName();
            this.fNewLaunchConfigurationName = launchConfigurationName.replaceAll(oldName, newName);
            if (launchConfigurationName.equals(this.fNewLaunchConfigurationName) || DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(this.fNewLaunchConfigurationName)) {
                this.fNewLaunchConfigurationName = null;
            }
        }
    }

    public String getName() {
        if (this.fNewLaunchConfigurationName != null) {
            return MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.0"), this.fLaunchConfiguration.getName(), this.fNewLaunchConfigurationName);
        }
        if (this.fNewProjectName == null) {
            return MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.1"), this.fLaunchConfiguration.getName());
        }
        if (this.fNewMainTypeName == null) {
            return MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.2"), this.fLaunchConfiguration.getName());
        }
        return MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.3"), this.fLaunchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fLaunchConfiguration.exists()) {
            String typeName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
            if (this.fOldMainTypeName.equals(typeName)) {
                String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
                if (this.fOldProjectName.equals(projectName)) {
                    return new RefactoringStatus();
                }
                return RefactoringStatus.createWarningStatus((String)MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.4"), this.fLaunchConfiguration.getName(), this.fOldProjectName));
            }
            return RefactoringStatus.createWarningStatus((String)MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.5"), this.fLaunchConfiguration.getName(), this.fOldMainTypeName));
        }
        return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringMessages.getString("LaunchConfigurationProjectMainTypeChange.6"), this.fLaunchConfiguration.getName()));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String oldProjectName;
        String oldMainTypeName;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationWorkingCopy copy = this.fLaunchConfiguration.getWorkingCopy();
        if (this.fNewMainTypeName != null) {
            oldMainTypeName = this.fOldMainTypeName;
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fNewMainTypeName);
        } else {
            oldMainTypeName = null;
        }
        if (this.fNewProjectName != null) {
            oldProjectName = this.fOldProjectName;
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fNewProjectName);
        } else {
            oldProjectName = null;
        }
        if (this.fNewLaunchConfigurationName != null) {
            launchManager.addLaunchConfigurationListener(this.configurationListener);
            copy.rename(this.fNewLaunchConfigurationName);
        }
        copy.doSave();
        launchManager.removeLaunchConfigurationListener(this.configurationListener);
        return new LaunchConfigurationProjectMainTypeChange(this.fNewLaunchConfiguration, oldMainTypeName, oldProjectName);
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }
}

