/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class CUPositionCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private static final ImageDescriptorRegistry IMAGE_DESC_REGISTRY = JavaPlugin.getImageDescriptorRegistry();
    private String fErrorMessage;
    private char[] fProposalAutoActivationSet;
    private JavaCompletionProposalComparator fComparator;
    private ICompilationUnit fOriginalCu;
    private String fBeforeString;
    private String fAfterString;
    private CUPositionCompletionRequestor fCompletionRequestor;

    public CUPositionCompletionProcessor(CUPositionCompletionRequestor completionRequestor) {
        this.fCompletionRequestor = completionRequestor;
        this.fComparator = new JavaCompletionProposalComparator();
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = triggers.toCharArray();
    }

    public void setCompletionContext(ICompilationUnit cu, String beforeString, String afterString) {
        this.fOriginalCu = cu;
        this.fBeforeString = beforeString;
        this.fAfterString = afterString;
        if (cu != null) {
            this.fCompletionRequestor.setJavaProject(cu.getJavaProject());
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue(false, "ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue(false, "ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        if (this.fOriginalCu == null) {
            return null;
        }
        String input = contentAssistSubjectControl.getDocument().get();
        if (documentOffset == 0) {
            return null;
        }
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(documentOffset, input);
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICompletionProposal[] internalComputeCompletionProposals(int documentOffset, String input) {
        String cuString = this.fBeforeString + input + this.fAfterString;
        ICompilationUnit cu = null;
        try {
            ICompletionProposal[] errorMsg;
            cu = this.fOriginalCu.getWorkingCopy(new WorkingCopyOwner(){}, null, (IProgressMonitor)new NullProgressMonitor());
            cu.getBuffer().setContents(cuString);
            int cuPrefixLength = this.fBeforeString.length();
            this.fCompletionRequestor.setOffsetReduction(cuPrefixLength);
            cu.codeComplete(cuPrefixLength + documentOffset, (ICompletionRequestor)this.fCompletionRequestor);
            JavaCompletionProposal[] proposals = this.fCompletionRequestor.getResults();
            if (proposals.length == 0) {
                errorMsg = this.fCompletionRequestor.getErrorMessage();
                if (errorMsg == null || errorMsg.trim().length() == 0) {
                    errorMsg = RefactoringMessages.getString("JavaTypeCompletionProcessor.no_completion");
                }
                this.fErrorMessage = errorMsg;
            } else {
                this.fErrorMessage = this.fCompletionRequestor.getErrorMessage();
            }
            errorMsg = proposals;
            return errorMsg;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            ICompletionProposal[] iCompletionProposalArray = null;
            return iCompletionProposalArray;
        }
        finally {
            try {
                cu.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    protected static class CUPositionCompletionRequestor
    extends CompletionRequestorAdapter {
        private int fOffsetReduction;
        private IJavaProject fJavaProject;
        private List fProposals;
        private String fErrorMessage2;

        protected CUPositionCompletionRequestor() {
        }

        public IJavaProject getJavaProject() {
            return this.fJavaProject;
        }

        private void setJavaProject(IJavaProject javaProject) {
            this.fJavaProject = javaProject;
        }

        private void setOffsetReduction(int offsetReduction) {
            this.fOffsetReduction = offsetReduction;
            this.fProposals = new ArrayList();
        }

        public final void acceptError(IProblem error) {
            this.fErrorMessage2 = error.getMessage();
        }

        public final JavaCompletionProposal[] getResults() {
            return this.fProposals.toArray(new JavaCompletionProposal[this.fProposals.size()]);
        }

        public final String getErrorMessage() {
            return this.fErrorMessage2;
        }

        protected final void addAdjustedCompletion(String name, String completion, int start, int end, int relevance, ImageDescriptor descriptor) {
            this.fProposals.add(new JavaCompletionProposal(completion, start - this.fOffsetReduction, end - start, CUPositionCompletionRequestor.getImage(descriptor), name, relevance));
        }

        protected final void addAdjustedTypeCompletion(char[] packageName, char[] typeName, char[] completionName, int start, int end, int relevance, ImageDescriptor descriptor) {
            ProposalInfo proposalInfo = new ProposalInfo(this.getJavaProject(), packageName, typeName);
            this.fProposals.add(CUPositionCompletionRequestor.createTypeCompletion(new String(packageName), new String(typeName), proposalInfo, new String(completionName), start - this.fOffsetReduction, end - this.fOffsetReduction, relevance, descriptor));
        }

        private static JavaCompletionProposal createTypeCompletion(String containerName, String typeName, ProposalInfo proposalInfo, String completion, int start, int end, int relevance, ImageDescriptor descriptor) {
            String fullName = JavaModelUtil.concatenateName(containerName, typeName);
            StringBuffer buf = new StringBuffer(Signature.getSimpleName((String)fullName));
            String typeQualifier = Signature.getQualifier((String)fullName);
            buf.append(JavaElementLabels.CONCAT_STRING);
            if (typeQualifier.length() > 0) {
                buf.append(typeQualifier);
            } else if (containerName != null) {
                buf.append(JavaElementLabels.DEFAULT_PACKAGE);
            }
            String name = buf.toString();
            if ("java.lang".equals(containerName) && typeName.equals(completion)) {
                completion = containerName + '.' + completion;
            }
            JavaTypeCompletionProposal proposal = new JavaTypeCompletionProposal(completion, null, start, end - start, CUPositionCompletionRequestor.getImage(descriptor), name, relevance, typeName, containerName);
            proposal.setProposalInfo(proposalInfo);
            return proposal;
        }

        private static Image getImage(ImageDescriptor descriptor) {
            return descriptor == null ? null : IMAGE_DESC_REGISTRY.get(descriptor);
        }
    }
}

