/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.eclipse.ant.internal.ui.editor.model.AntDefiningTaskNode;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.AntModelProject;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.jface.resource.ImageDescriptor;

public class AntProjectNode
extends AntElementNode {
    private AntModelProject fProject;
    private AntModel fModel;
    private Map fNameToDefiningNodeMap;

    public AntProjectNode(AntModelProject project, AntModel antModel) {
        super("project");
        this.fProject = project;
        this.fModel = antModel;
    }

    public String getLabel() {
        String projectName = this.fProject.getName();
        if (projectName == null || projectName.length() == 0) {
            projectName = "project";
        }
        return projectName;
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antProject");
    }

    public Project getProject() {
        return this.fProject;
    }

    protected AntModel getAntModel() {
        return this.fModel;
    }

    public void reset() {
        super.reset();
        this.fProject.reset();
        if (this.fNameToDefiningNodeMap != null) {
            this.getAntModel().setNamesOfOldDefiningNodes(this.fNameToDefiningNodeMap.keySet());
        }
        this.fNameToDefiningNodeMap = null;
        this.setProblemSeverity(-1);
    }

    public void addDefiningTaskNode(AntDefiningTaskNode node) {
        String label;
        if (this.fNameToDefiningNodeMap == null) {
            this.fNameToDefiningNodeMap = new HashMap();
        }
        if ((label = node.getLabel()).equalsIgnoreCase("macrodef") || label.equalsIgnoreCase("presetdef") || label.equalsIgnoreCase("typedef") || label.equalsIgnoreCase("taskdef")) {
            return;
        }
        this.fNameToDefiningNodeMap.put(node.getLabel(), node);
    }

    public AntDefiningTaskNode getDefininingTaskNode(String nodeName) {
        if (this.fNameToDefiningNodeMap != null) {
            return (AntDefiningTaskNode)this.fNameToDefiningNodeMap.get(nodeName);
        }
        return null;
    }
}

