/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.adaptor.BasicLocation;
import org.eclipse.core.runtime.adaptor.BundleLocalizationImpl;
import org.eclipse.core.runtime.adaptor.BundleStopper;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.core.runtime.adaptor.EclipseBundleInstaller;
import org.eclipse.core.runtime.adaptor.EclipseCommandProvider;
import org.eclipse.core.runtime.adaptor.EclipseElementFactory;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.adaptor.EnvironmentInfo;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.adaptor.PluginConverterImpl;
import org.eclipse.core.runtime.adaptor.PluginParser;
import org.eclipse.core.runtime.adaptor.URLConverterImpl;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultAdaptor;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.stats.StatsManager;
import org.eclipse.osgi.internal.resolver.BundleInstaller;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.Version;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class EclipseAdaptor
extends DefaultAdaptor {
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_EXITONERROR = "eclipse.exitOnError";
    static final String F_LOG = ".log";
    public static final String PLUGIN_CLASS = "Plugin-Class";
    public static final String ECLIPSE_AUTOSTART = "Eclipse-AutoStart";
    public static final String ECLIPSE_AUTOSTART_EXCEPTIONS = "exceptions";
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_STATE_READER = "org.eclipse.osgi/eclipseadaptor/state/reader";
    private static final String OPTION_RESOLVER = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin";
    private static final String OPTION_PLATFORM_ADMIN_RESOLVER = "org.eclipse.osgi/eclipseadaptor/debug/platformadmin/resolver";
    private static final String OPTION_MONITOR_PLATFORM_ADMIN = "org.eclipse.osgi/eclipseadaptor/resolver/timing";
    private static final String OPTION_RESOLVER_READER = "org.eclipse.osgi/eclipseadaptor/resolver/reader/timing";
    private static final String OPTION_CONVERTER = "org.eclipse.osgi/eclipseadaptor/converter/debug";
    private static final String OPTION_LOCATION = "org.eclipse.osgi/eclipseadaptor/debug/location";
    public static final byte BUNDLEDATA_VERSION = 10;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    private static EclipseAdaptor instance;
    private long timeStamp = 0L;
    private String installURL = null;
    private boolean exitOnError = true;
    private BundleStopper stopper;
    static /* synthetic */ Class class$org$eclipse$osgi$service$datalocation$Location;
    static /* synthetic */ Class class$org$eclipse$osgi$service$environment$EnvironmentInfo;
    static /* synthetic */ Class class$org$eclipse$osgi$service$resolver$PlatformAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$service$pluginconversion$PluginConverter;
    static /* synthetic */ Class class$org$eclipse$osgi$service$urlconversion$URLConverter;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$console$CommandProvider;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$log$FrameworkLog;
    static /* synthetic */ Class class$org$eclipse$osgi$service$localization$BundleLocalization;

    public EclipseAdaptor(String[] args) {
        super(args);
        instance = this;
        this.setDebugOptions();
    }

    public static EclipseAdaptor getDefault() {
        return instance;
    }

    public void initialize(EventPublisher eventPublisher) {
        if (Boolean.getBoolean(PROP_CLEAN)) {
            this.cleanOSGiCache();
        }
        super.initialize(eventPublisher);
    }

    public void initializeMetadata() {
    }

    protected void initBundleStoreRootDir() {
        File configurationLocation = LocationManager.getOSGiConfigurationDir();
        if (configurationLocation != null) {
            this.bundleStoreRootDir = new File(configurationLocation, "bundles");
            this.bundleStore = this.bundleStoreRootDir.getAbsolutePath();
        } else {
            this.bundleStore = "bundles";
            this.bundleStoreRootDir = new File(this.bundleStore);
        }
        this.properties.put("osgi.bundlestore", this.bundleStoreRootDir.getAbsolutePath());
    }

    protected FrameworkLog createFrameworkLog() {
        if (this.frameworkLog != null) {
            return this.frameworkLog;
        }
        return EclipseStarter.createFrameworkLog();
    }

    protected StateManager createStateManager() {
        this.readHeaders();
        this.checkLocationAndReinitialize();
        File stateLocation = LocationManager.getConfigurationFile(".state");
        if (!stateLocation.isFile()) {
            Location parentConfiguration = null;
            parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
            if (parentConfiguration != null) {
                stateLocation = new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi/.state");
            }
        }
        this.stateManager = new StateManager(stateLocation, this.timeStamp);
        this.stateManager.setInstaller((BundleInstaller)new EclipseBundleInstaller());
        StateImpl systemState = this.stateManager.getSystemState();
        if (systemState != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        BundleData[] installedBundles = this.getInstalledBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        for (int i = 0; i < installedBundles.length; ++i) {
            BundleData toAdd = installedBundles[i];
            try {
                Dictionary manifest = toAdd.getManifest();
                BundleDescription newDescription = factory.createBundleDescription(manifest, toAdd.getLocation(), toAdd.getBundleID());
                systemState.addBundle(newDescription);
                continue;
            }
            catch (BundleException be) {
                // empty catch block
            }
        }
        systemState.setTimeStamp(this.timeStamp);
        systemState.resolve();
        return this.stateManager;
    }

    public void shutdownStateManager() {
        try {
            File stateLocation = LocationManager.getConfigurationFile(".state");
            this.stateManager.shutdown(stateLocation);
        }
        catch (IOException e) {
            this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), (Throwable)e));
        }
    }

    private void cleanOSGiCache() {
        File osgiConfig = LocationManager.getOSGiConfigurationDir();
        if (!this.rm(osgiConfig)) {
            // empty if block
        }
    }

    private void checkLocationAndReinitialize() {
        if (this.installURL == null) {
            this.installURL = EclipseStarter.getSysPath();
            return;
        }
        if (!EclipseStarter.getSysPath().equals(this.installURL)) {
            LocationManager.getConfigurationFile(".bundledata").delete();
            LocationManager.getConfigurationFile(".state").delete();
            this.installURL = EclipseStarter.getSysPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders() {
        block7: {
            InputStream bundleDataStream = this.findBundleDataFile();
            if (bundleDataStream == null) {
                return;
            }
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(bundleDataStream));
                try {
                    if (in.readByte() == 10) {
                        this.timeStamp = in.readLong();
                        this.installURL = in.readUTF();
                        this.initialBundleStartLevel = in.readInt();
                        this.nextId = in.readLong();
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                if (!Debug.DEBUG_GENERAL) break block7;
                Debug.println((String)("Error reading framework metadata: " + e.getMessage()));
                Debug.printStackTrace((Throwable)e);
            }
        }
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new EclipseElementFactory();
        }
        return this.elementFactory;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        super.frameworkStart(context);
        Bundle bundle = context.getBundle();
        Location location = LocationManager.getUserLocation();
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        if (location != null) {
            properties.put("type", "osgi.user.area");
            context.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, properties);
        }
        if ((location = LocationManager.getInstanceLocation()) != null) {
            properties.put("type", "osgi.instance.area");
            context.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, properties);
        }
        if ((location = LocationManager.getConfigurationLocation()) != null) {
            properties.put("type", "osgi.configuration.area");
            context.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, properties);
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            properties.put("type", "osgi.install.area");
            context.registerService((class$org$eclipse$osgi$service$datalocation$Location == null ? (class$org$eclipse$osgi$service$datalocation$Location = EclipseAdaptor.class$("org.eclipse.osgi.service.datalocation.Location")) : class$org$eclipse$osgi$service$datalocation$Location).getName(), (Object)location, properties);
        }
        this.register((class$org$eclipse$osgi$service$environment$EnvironmentInfo == null ? (class$org$eclipse$osgi$service$environment$EnvironmentInfo = EclipseAdaptor.class$("org.eclipse.osgi.service.environment.EnvironmentInfo")) : class$org$eclipse$osgi$service$environment$EnvironmentInfo).getName(), EnvironmentInfo.getDefault(), bundle);
        this.register((class$org$eclipse$osgi$service$resolver$PlatformAdmin == null ? (class$org$eclipse$osgi$service$resolver$PlatformAdmin = EclipseAdaptor.class$("org.eclipse.osgi.service.resolver.PlatformAdmin")) : class$org$eclipse$osgi$service$resolver$PlatformAdmin).getName(), this.stateManager, bundle);
        this.register((class$org$eclipse$osgi$service$pluginconversion$PluginConverter == null ? (class$org$eclipse$osgi$service$pluginconversion$PluginConverter = EclipseAdaptor.class$("org.eclipse.osgi.service.pluginconversion.PluginConverter")) : class$org$eclipse$osgi$service$pluginconversion$PluginConverter).getName(), new PluginConverterImpl(context), bundle);
        this.register((class$org$eclipse$osgi$service$urlconversion$URLConverter == null ? (class$org$eclipse$osgi$service$urlconversion$URLConverter = EclipseAdaptor.class$("org.eclipse.osgi.service.urlconversion.URLConverter")) : class$org$eclipse$osgi$service$urlconversion$URLConverter).getName(), new URLConverterImpl(), bundle);
        this.register((class$org$eclipse$osgi$framework$console$CommandProvider == null ? (class$org$eclipse$osgi$framework$console$CommandProvider = EclipseAdaptor.class$("org.eclipse.osgi.framework.console.CommandProvider")) : class$org$eclipse$osgi$framework$console$CommandProvider).getName(), new EclipseCommandProvider(context), bundle);
        this.register((class$org$eclipse$osgi$framework$log$FrameworkLog == null ? (class$org$eclipse$osgi$framework$log$FrameworkLog = EclipseAdaptor.class$("org.eclipse.osgi.framework.log.FrameworkLog")) : class$org$eclipse$osgi$framework$log$FrameworkLog).getName(), this.getFrameworkLog(), bundle);
        this.register((class$org$eclipse$osgi$service$localization$BundleLocalization == null ? (class$org$eclipse$osgi$service$localization$BundleLocalization = EclipseAdaptor.class$("org.eclipse.osgi.service.localization.BundleLocalization")) : class$org$eclipse$osgi$service$localization$BundleLocalization).getName(), new BundleLocalizationImpl(), bundle);
        this.registerEndorsedXMLParser();
    }

    private void setDebugOptions() {
        DebugOptions options = DebugOptions.getDefault();
        if (options == null) {
            return;
        }
        StateManager.DEBUG = options != null;
        StateManager.DEBUG_READER = options.getBooleanOption(OPTION_RESOLVER_READER, false);
        StateManager.MONITOR_PLATFORM_ADMIN = options.getBooleanOption("org.eclipse.osgi/eclipseadaptor/resolver/timing", false);
        StateManager.DEBUG_PLATFORM_ADMIN = options.getBooleanOption(OPTION_PLATFORM_ADMIN, false);
        StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER = options.getBooleanOption(OPTION_PLATFORM_ADMIN_RESOLVER, false);
        PluginConverterImpl.DEBUG = options.getBooleanOption(OPTION_CONVERTER, false);
        BasicLocation.DEBUG = options.getBooleanOption(OPTION_LOCATION, false);
    }

    private void registerEndorsedXMLParser() {
        try {
            Class.forName(SAXFACTORYNAME);
            this.context.registerService(SAXFACTORYNAME, (Object)new SaxParsingService(), new Hashtable());
            Class.forName(DOMFACTORYNAME);
            this.context.registerService(DOMFACTORYNAME, (Object)new DomParsingService(), new Hashtable());
        }
        catch (ClassNotFoundException e) {
            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_ADAPTOR_ERROR_XML_SERVICE");
            this.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)e, null));
        }
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.saveMetaData();
        super.frameworkStop(context);
        this.printStats();
        PluginParser.releaseXMLParsing();
    }

    private void printStats() {
        String constraintResolution;
        String packageAdminResolution;
        DebugOptions debugOptions = DebugOptions.getDefault();
        if (debugOptions == null) {
            return;
        }
        String registryParsing = debugOptions.getOption("org.eclipse.core.runtime/registry/parsing/timing/value");
        if (registryParsing != null) {
            EclipseAdaptorMsg.debug("Time spent in registry parsing: " + registryParsing);
        }
        if ((packageAdminResolution = debugOptions.getOption("debug.packageadmin/timing/value")) != null) {
            System.out.println("Time spent in package admin resolve: " + packageAdminResolution);
        }
        if ((constraintResolution = debugOptions.getOption("org.eclipse.core.runtime.adaptor/resolver/timing/value")) != null) {
            System.out.println("Time spent resolving the dependency system: " + constraintResolution);
        }
    }

    private InputStream findBundleDataFile() {
        File metadata = LocationManager.getConfigurationFile(".bundledata");
        InputStream bundleDataStream = null;
        if (metadata.isFile()) {
            try {
                bundleDataStream = new FileInputStream(metadata);
            }
            catch (FileNotFoundException e1) {}
        } else {
            Location parentConfiguration = null;
            parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
            if (parentConfiguration != null) {
                try {
                    bundleDataStream = new URL(parentConfiguration.getURL(), "org.eclipse.osgi/.bundledata").openStream();
                }
                catch (MalformedURLException e1) {
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        return bundleDataStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BundleData[] getInstalledBundles() {
        InputStream bundleDataStream = this.findBundleDataFile();
        if (bundleDataStream == null) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(bundleDataStream));
            try {
                if (in.readByte() != 10) {
                    BundleData[] bundleDataArray = null;
                    return bundleDataArray;
                }
                in.readLong();
                in.readUTF();
                in.readInt();
                in.readLong();
                int bundleCount = in.readInt();
                ArrayList<EclipseBundleData> result = new ArrayList<EclipseBundleData>(bundleCount);
                long id = -1L;
                StateImpl state = this.stateManager.getSystemState();
                long stateTimeStamp = state.getTimeStamp();
                for (int i = 0; i < bundleCount; ++i) {
                    try {
                        try {
                            id = in.readLong();
                            if (id == 0L) continue;
                            EclipseBundleData data = (EclipseBundleData)this.getElementFactory().createBundleData((AbstractFrameworkAdaptor)this, id);
                            this.loadMetaDataFor(data, in);
                            data.initializeExistingBundle();
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println((String)("BundleData created: " + (Object)((Object)data)));
                            }
                            result.add(data);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    catch (IOException e) {
                        state.removeBundle(id);
                        if (!Debug.DEBUG_GENERAL) continue;
                        Debug.println((String)("Error reading framework metadata: " + e.getMessage()));
                        Debug.printStackTrace((Throwable)e);
                    }
                }
                if (stateTimeStamp != state.getTimeStamp()) {
                    state.resolve(false);
                }
                BundleData[] bundleDataArray = result.toArray(new BundleData[result.size()]);
                return bundleDataArray;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.println((String)("Error reading framework metadata: " + e.getMessage()));
            Debug.printStackTrace((Throwable)e);
            return null;
        }
    }

    protected void loadMetaDataFor(EclipseBundleData data, DataInputStream in) throws IOException {
        byte flag = in.readByte();
        if (flag == 0) {
            return;
        }
        data.setLocation(this.readString(in, false));
        data.setFileName(this.readString(in, false));
        data.setSymbolicName(this.readString(in, false));
        data.setVersion(new Version(this.readString(in, false)));
        data.setActivator(this.readString(in, false));
        data.setAutoStart(in.readBoolean());
        int exceptionsCount = in.readInt();
        String[] autoStartExceptions = exceptionsCount > 0 ? new String[exceptionsCount] : null;
        for (int i = 0; i < exceptionsCount; ++i) {
            autoStartExceptions[i] = in.readUTF();
        }
        data.setAutoStartExceptions(autoStartExceptions);
        data.setPluginClass(this.readString(in, false));
        data.setClassPath(this.readString(in, false));
        data.setNativePaths(this.readString(in, false));
        data.setExecutionEnvironment(this.readString(in, false));
        data.setDynamicImports(this.readString(in, false));
        data.setGeneration(in.readInt());
        data.setStartLevel(in.readInt());
        data.setStatus(in.readInt());
        data.setReference(in.readBoolean());
        data.setFragment(in.readBoolean());
        data.setManifestTimeStamp(in.readLong());
        data.setManifestType(in.readByte());
    }

    public void saveMetaDataFor(DefaultBundleData data) throws IOException {
        if (!((EclipseBundleData)data).isAutoStartable()) {
            --this.timeStamp;
        }
    }

    public void persistInitialBundleStartLevel(int value) {
        --this.timeStamp;
    }

    public void persistNextBundleID(long value) {
    }

    protected void saveMetaDataFor(BundleData data, DataOutputStream out) throws IOException {
        if (data.getBundleID() == 0L || !(data instanceof DefaultBundleData)) {
            out.writeByte(0);
            return;
        }
        EclipseBundleData bundleData = (EclipseBundleData)data;
        out.writeByte(1);
        this.writeStringOrNull(out, bundleData.getLocation());
        this.writeStringOrNull(out, bundleData.getFileName());
        this.writeStringOrNull(out, bundleData.getSymbolicName());
        this.writeStringOrNull(out, bundleData.getVersion().toString());
        this.writeStringOrNull(out, bundleData.getActivator());
        out.writeBoolean(bundleData.isAutoStart());
        String[] autoStartExceptions = bundleData.getAutoStartExceptions();
        if (autoStartExceptions == null) {
            out.writeInt(0);
        } else {
            out.writeInt(autoStartExceptions.length);
            for (int i = 0; i < autoStartExceptions.length; ++i) {
                out.writeUTF(autoStartExceptions[i]);
            }
        }
        this.writeStringOrNull(out, bundleData.getPluginClass());
        this.writeStringOrNull(out, bundleData.getClassPath());
        this.writeStringOrNull(out, bundleData.getNativePathsString());
        this.writeStringOrNull(out, bundleData.getExecutionEnvironment());
        this.writeStringOrNull(out, bundleData.getDynamicImports());
        out.writeInt(bundleData.getGeneration());
        out.writeInt(bundleData.getStartLevel());
        out.writeInt(bundleData.getPersistentStatus());
        out.writeBoolean(bundleData.isReference());
        out.writeBoolean(bundleData.isFragment());
        out.writeLong(bundleData.getManifestTimeStamp());
        out.writeByte(bundleData.getManifestType());
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    private void writeStringOrNull(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetaData() {
        File metadata = LocationManager.getConfigurationFile(".bundledata");
        if (this.timeStamp == this.stateManager.getSystemState().getTimeStamp()) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(metadata)));
            try {
                out.writeByte(10);
                out.writeLong(this.stateManager.getSystemState().getTimeStamp());
                out.writeUTF(this.installURL);
                out.writeInt(this.initialBundleStartLevel);
                out.writeLong(this.nextId);
                Bundle[] bundles = this.context.getBundles();
                out.writeInt(bundles.length);
                for (int i = 0; i < bundles.length; ++i) {
                    long id = bundles[i].getBundleId();
                    out.writeLong(id);
                    if (id == 0L) continue;
                    BundleData data = ((AbstractBundle)bundles[i]).getBundleData();
                    this.saveMetaDataFor(data, out);
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), (Throwable)e));
        }
    }

    public BundleWatcher getBundleWatcher() {
        return StatsManager.getDefault();
    }

    protected BundleContext getContext() {
        return this.context;
    }

    public void frameworkStopping(BundleContext context) {
        super.frameworkStopping(context);
        this.stopper = new BundleStopper();
        this.stopper.stopBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRuntimeError(Throwable error) {
        try {
            this.exitOnError = Boolean.valueOf(System.getProperty(PROP_EXITONERROR, "true"));
            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_ADAPTOR_RUNTIME_ERROR");
            FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, error, null);
            this.frameworkLog.log(logEntry);
        }
        catch (Throwable t) {
            try {
                error.printStackTrace();
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            if (this.exitOnError) {
                System.exit(13);
            }
        }
    }

    protected void setLog(FrameworkLog log) {
        this.frameworkLog = log;
    }

    public BundleStopper getBundleStopper() {
        return this.stopper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DomParsingService
    implements ServiceFactory {
        private DomParsingService() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return DocumentBuilderFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }

    private class SaxParsingService
    implements ServiceFactory {
        private SaxParsingService() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return SAXParserFactory.newInstance();
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

