/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public abstract class BasicDebugViewContentProvider
implements IStructuredContentProvider,
IDebugEventSetListener {
    protected StructuredViewer fViewer;
    protected boolean fDisposed = false;

    public void dispose() {
        this.fDisposed = true;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (StructuredViewer)viewer;
    }

    protected void asyncExec(Runnable r) {
        Control ctrl;
        if (this.fViewer != null && (ctrl = this.fViewer.getControl()) != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }

    protected void syncExec(Runnable r) {
        Control ctrl;
        if (this.fViewer != null && (ctrl = this.fViewer.getControl()) != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(r);
        }
    }

    protected void refresh() {
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }

    protected void refresh(Object element) {
        if (this.fViewer != null) {
            this.fViewer.refresh(element);
        }
    }

    public void handleDebugEvent(final DebugEvent event) {
        if (this.fViewer == null) {
            return;
        }
        Object element = event.getSource();
        if (element == null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (!BasicDebugViewContentProvider.this.isDisposed()) {
                    BasicDebugViewContentProvider.this.doHandleDebugEvent(event);
                }
            }
        };
        this.asyncExec(r);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            this.handleDebugEvent(events[i]);
        }
    }

    protected abstract void doHandleDebugEvent(DebugEvent var1);
}

