/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.views.markers.internal.MarkerType;

class MarkerTypesModel {
    private HashMap types = this.readTypes();

    public MarkerType getType(String id) {
        return (MarkerType)this.types.get(id);
    }

    public MarkerType[] getTypes() {
        MarkerType[] result = new MarkerType[this.types.size()];
        this.types.values().toArray(result);
        return result;
    }

    private String getWellKnownLabel(String type) {
        if (type.equals("org.eclipse.core.resources.problemmarker")) {
            return "Problem";
        }
        if (type.equals("org.eclipse.core.resources.taskmarker")) {
            return "Task";
        }
        if (type.equals("org.eclipse.jdt.core.problem")) {
            return "Java Problem";
        }
        return type;
    }

    private HashMap readTypes() {
        HashMap<String, MarkerType> types = new HashMap<String, MarkerType>();
        IExtensionPoint point = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IExtension ext = extensions[i];
                String id = ext.getUniqueIdentifier();
                String label = ext.getLabel();
                if (label.equals("")) {
                    label = this.getWellKnownLabel(id);
                }
                ArrayList<String> supersList = new ArrayList<String>();
                IConfigurationElement[] configElements = ext.getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String sup;
                    IConfigurationElement elt = configElements[j];
                    if (!elt.getName().equalsIgnoreCase("super") || (sup = elt.getAttribute("type")) == null) continue;
                    supersList.add(sup);
                }
                String[] superTypes = new String[supersList.size()];
                supersList.toArray(superTypes);
                MarkerType type = new MarkerType(this, id, label, superTypes);
                types.put(id, type);
            }
        }
        return types;
    }
}

