#*******************************************************************************
# Copyright (c) 2000, 2004 IBM Corporation and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Common Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/cpl-v10.html
# 
# Contributors:
#     IBM Corporation - initial API and implementation
#     Kevin Cornell (Rational Software Corporation)
#*******************************************************************************
 
# Makefile for creating the eclipse launcher program.

# This script expects the following environment variables set:
#
# PROGRAM_OUTPUT - the filename of the output executable
# PROGRAM_NAME - the title of the splash screen program

# Define the object modules to be compiled and flags.
OBJS = eclipse.o eclipseUtil.o eclipseShm.o eclipsePhoton.o
EXEC = $(PROGRAM_OUTPUT)
LIBS = -lph -lphrender -lphexlib
CFLAGS = -O -s -Wall \
	-DPROGRAM_NAME="\"$(PROGRAM_NAME)\"" \
	-DDEFAULT_OS="\"$(DEFAULT_OS)\"" \
	-DDEFAULT_OS_ARCH="\"$(DEFAULT_OS_ARCH)\"" \
	-DDEFAULT_WS="\"$(DEFAULT_WS)\"" \
	-DJ9VM -I.. -DPHOTON

all: $(EXEC)

.c.o:
	$(CC) $(CFLAGS) -c $< -o $@

eclipse.o: ../eclipse.c
	$(CC) $(CFLAGS) -c ../eclipse.c -o $@

eclipseShm.o: ../eclipseShm.c
	$(CC) $(CFLAGS) -c ../eclipseShm.c -o $@

eclipseUtil.o: ../eclipseUtil.c
	$(CC) $(CFLAGS) -c ../eclipseUtil.c -o $@

$(EXEC): $(OBJS)
	$(CC) -o $(EXEC) $(OBJS) $(LIBS)

clean:
	rm -f $(EXEC) $(OBJS)
