/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state.mirror;

import org.gradle.api.internal.changedetection.state.mirror.AbstractPhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;

public class PhysicalFileSnapshot
extends AbstractPhysicalSnapshot {
    private final HashCode contentHash;
    private final long lastModified;

    public PhysicalFileSnapshot(String absolutePath, String name, HashCode contentHash, long lastModified) {
        super(absolutePath, name);
        this.contentHash = contentHash;
        this.lastModified = lastModified;
    }

    @Override
    public FileType getType() {
        return FileType.RegularFile;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(PhysicalSnapshot other) {
        if (!(other instanceof PhysicalFileSnapshot)) {
            return false;
        }
        PhysicalFileSnapshot otherSnapshot = (PhysicalFileSnapshot)other;
        return this.lastModified == otherSnapshot.lastModified && this.contentHash.equals((Object)otherSnapshot.contentHash);
    }

    @Override
    public void accept(PhysicalSnapshotVisitor visitor) {
        visitor.visit(this);
    }
}

