/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.ClasspathCompareStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathCompareStrategy;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;

public enum FingerprintCompareStrategy {
    ABSOLUTE(new AbsolutePathFingerprintCompareStrategy()),
    NORMALIZED(new NormalizedPathFingerprintCompareStrategy()),
    IGNORED_PATH(new IgnoredPathCompareStrategy()),
    CLASSPATH(new ClasspathCompareStrategy());

    private final Impl delegate;

    private FingerprintCompareStrategy(Impl compareStrategy) {
        this.delegate = compareStrategy;
    }

    public boolean visitChangesSince(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean includeAdded) {
        Boolean trivialResult = FingerprintCompareStrategy.compareTrivialSnapshots(visitor, current, previous, propertyTitle, includeAdded);
        if (trivialResult != null) {
            return trivialResult;
        }
        return this.delegate.visitChangesSince(visitor, current, previous, propertyTitle, includeAdded);
    }

    public void appendToHasher(BuildCacheHasher hasher, Map<String, NormalizedFileSnapshot> snapshots) {
        this.delegate.appendToHasher(hasher, snapshots.values());
    }

    @Nullable
    @VisibleForTesting
    static Boolean compareTrivialSnapshots(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean includeAdded) {
        switch (current.size()) {
            case 0: {
                switch (previous.size()) {
                    case 0: {
                        return true;
                    }
                }
                for (Map.Entry<String, NormalizedFileSnapshot> entry : previous.entrySet()) {
                    FileChange change = FileChange.removed(entry.getKey(), propertyTitle, entry.getValue().getType());
                    if (visitor.visitChange(change)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                switch (previous.size()) {
                    case 0: {
                        return FingerprintCompareStrategy.reportAllAdded(visitor, current, propertyTitle, includeAdded);
                    }
                    case 1: {
                        Map.Entry<String, NormalizedFileSnapshot> previousEntry = previous.entrySet().iterator().next();
                        Map.Entry<String, NormalizedFileSnapshot> currentEntry = current.entrySet().iterator().next();
                        return FingerprintCompareStrategy.compareTrivialSnapshotEntries(visitor, currentEntry, previousEntry, propertyTitle, includeAdded);
                    }
                }
                return null;
            }
        }
        if (!previous.isEmpty()) {
            return null;
        }
        return FingerprintCompareStrategy.reportAllAdded(visitor, current, propertyTitle, includeAdded);
    }

    private static boolean reportAllAdded(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, String propertyTitle, boolean includeAdded) {
        if (includeAdded) {
            for (Map.Entry<String, NormalizedFileSnapshot> entry : current.entrySet()) {
                FileChange change = FileChange.added(entry.getKey(), propertyTitle, entry.getValue().getType());
                if (visitor.visitChange(change)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean compareTrivialSnapshotEntries(TaskStateChangeVisitor visitor, Map.Entry<String, NormalizedFileSnapshot> currentEntry, Map.Entry<String, NormalizedFileSnapshot> previousEntry, String propertyTitle, boolean includeAdded) {
        NormalizedFileSnapshot normalizedPrevious = previousEntry.getValue();
        NormalizedFileSnapshot normalizedCurrent = currentEntry.getValue();
        if (normalizedCurrent.getNormalizedPath().equals(normalizedPrevious.getNormalizedPath())) {
            HashCode previousContent = normalizedPrevious.getNormalizedContentHash();
            HashCode currentContent = normalizedCurrent.getNormalizedContentHash();
            if (!currentContent.equals((Object)previousContent)) {
                String path = currentEntry.getKey();
                FileChange change = FileChange.modified(path, propertyTitle, normalizedPrevious.getType(), normalizedCurrent.getType());
                return visitor.visitChange(change);
            }
            return true;
        }
        String previousPath = previousEntry.getKey();
        FileChange remove = FileChange.removed(previousPath, propertyTitle, normalizedPrevious.getType());
        if (includeAdded) {
            String currentPath = currentEntry.getKey();
            FileChange add = FileChange.added(currentPath, propertyTitle, normalizedCurrent.getType());
            return visitor.visitChange(remove) && visitor.visitChange(add);
        }
        return visitor.visitChange(remove);
    }

    static interface Impl {
        public boolean visitChangesSince(TaskStateChangeVisitor var1, Map<String, NormalizedFileSnapshot> var2, Map<String, NormalizedFileSnapshot> var3, String var4, boolean var5);

        public void appendToHasher(BuildCacheHasher var1, Collection<NormalizedFileSnapshot> var2);
    }
}

