/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;

class ResolveConfigurationResolutionBuildOperationResult
implements ResolveConfigurationDependenciesBuildOperationType.Result,
CustomOperationTraceSerialization {
    private static final Action<? super Throwable> FAIL_SAFE = Actions.doNothing();
    private final ResolvableDependenciesInternal incoming;
    private final boolean failSafe;

    ResolveConfigurationResolutionBuildOperationResult(ResolvableDependenciesInternal incoming, boolean failSafe) {
        this.incoming = incoming;
        this.failSafe = failSafe;
    }

    public ResolvedComponentResult getRootComponent() {
        if (this.failSafe) {
            return this.incoming.getResolutionResult(FAIL_SAFE).getRoot();
        }
        return this.incoming.getResolutionResult().getRoot();
    }

    public String getRepositoryId(ResolvedComponentResult resolvedComponentResult) {
        return ((ResolvedComponentResultInternal)resolvedComponentResult).getRepositoryName();
    }

    public Object getCustomOperationTraceSerializableModel() {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("resolvedDependenciesCount", Integer.valueOf(this.getRootComponent().getDependencies().size()));
        final HashMap components = Maps.newHashMap();
        this.incoming.getResolutionResult(FAIL_SAFE).allComponents((Action)new Action<ResolvedComponentResult>(){

            public void execute(ResolvedComponentResult component) {
                components.put(component.getId().getDisplayName(), Collections.singletonMap("repoName", ((ResolvedComponentResultInternal)component).getRepositoryName()));
            }
        });
        model.put("components", components);
        return model;
    }
}

