/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RecentFileMenu {
    private JMenu m_root;
    private Vector m_recent;
    private Class m_prefAttach;
    private Action m_action;
    private int m_recentCount;

    public RecentFileMenu(JMenu menuroot, int recentCount, Class prefAttach, Action action) {
        this.m_recent = new Vector(recentCount);
        this.m_recentCount = recentCount;
        this.m_root = menuroot;
        this.m_prefAttach = prefAttach;
        this.m_action = action;
        this.loadRecentPrefs();
    }

    private void loadRecentPrefs() {
        Preferences p = Preferences.systemNodeForPackage(this.m_prefAttach);
        int count = p.getInt("recentfilecount", 0);
        this.m_recent.removeAllElements();
        for (int i = 0; i < count; ++i) {
            String rf = p.get("recentfile_" + i, null);
            if (rf == null || this.m_recent.size() >= this.m_recentCount) continue;
            this.m_recent.add(rf);
        }
        this.buildMenu();
    }

    public void savePrefs() {
        Preferences p = Preferences.systemNodeForPackage(this.m_prefAttach);
        for (int i = 0; i < this.m_recent.size(); ++i) {
            p.put("recentfile_" + i, this.m_recent.elementAt(i).toString());
        }
        p.putInt("recentfilecount", this.m_recent.size());
    }

    private void buildMenu() {
        this.m_root.removeAll();
        int i = 0;
        while (i < Math.min(this.m_recent.size(), this.m_recentCount)) {
            JMenuItem item = new JMenuItem(this.m_recent.elementAt(i).toString());
            ActionRecent ar = new ActionRecent();
            ar.Offset = i++;
            item.addActionListener(ar);
            this.m_root.add(item);
        }
        this.m_root.addSeparator();
        JMenuItem clear = new JMenuItem("Clear");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecentFileMenu.this.m_recent.removeAllElements();
                RecentFileMenu.this.buildMenu();
            }
        });
        this.m_root.add(clear);
    }

    public void add(String rec) {
        this.m_recent.remove(rec);
        this.m_recent.insertElementAt(rec, 0);
        while (this.m_recent.size() > this.m_recentCount) {
            this.m_recent.remove(this.m_recent.size() - 1);
        }
        this.buildMenu();
    }

    public class ActionRecent
    implements ActionListener {
        public int Offset;

        public void actionPerformed(ActionEvent evt) {
            if (RecentFileMenu.this.m_recent.elementAt(this.Offset) != null) {
                RecentFileMenu.this.m_action.action(RecentFileMenu.this.m_recent.elementAt(this.Offset).toString());
                RecentFileMenu.this.add(RecentFileMenu.this.m_recent.elementAt(this.Offset).toString());
            }
        }
    }

    public static interface Action {
        public void action(String var1);
    }
}

