/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.WeaponAttackAction;

public abstract class AbstractAttackAction
extends AbstractEntityAction
implements AttackAction {
    private static final long serialVersionUID = -897197664652217134L;
    private int targetType;
    private int targetId;

    public AbstractAttackAction(int n, int n2) {
        super(n);
        this.targetType = 0;
        this.targetId = n2;
    }

    public AbstractAttackAction(int n, int n2, int n3) {
        super(n);
        this.targetType = n2;
        this.targetId = n3;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setTargetType(int n) {
        this.targetType = n;
    }

    public void setTargetId(int n) {
        this.targetId = n;
    }

    public Targetable getTarget(IGame iGame) {
        return iGame.getTarget(this.getTargetType(), this.getTargetId());
    }

    public Entity getEntity(IGame iGame) {
        Entity entity = iGame.getEntity(this.getEntityId());
        if (entity == null) {
            entity = iGame.getOutOfGameEntity(this.getEntityId());
        }
        return entity;
    }

    public static ToHitData nightModifiers(IGame iGame, Targetable targetable, AmmoType ammoType, Entity entity, boolean bl) {
        int n;
        Object object;
        ToHitData toHitData = null;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        toHitData = new ToHitData();
        int n2 = iGame.getPlanetaryConditions().getLight();
        if (n2 == 0) {
            return toHitData;
        }
        int n3 = 0;
        n3 = iGame.getPlanetaryConditions().getLightHitPenalty(bl);
        toHitData.addModifier(n3, iGame.getPlanetaryConditions().getLightCurrentName());
        boolean bl2 = false;
        if (entity2 != null && !(bl2 = entity2.isIlluminated())) {
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof SearchlightAttackAction) || !((SearchlightAttackAction)(object = (SearchlightAttackAction)entityAction)).willIlluminate(iGame, entity2)) continue;
                bl2 = true;
                break;
            }
        }
        int n4 = Math.min(3, n3);
        if (entity2 != null && n2 > 1) {
            if (entity2.isUsingSpotlight()) {
                toHitData.addModifier(-n4, "target using searchlight");
                n3 -= n4;
            } else if (bl2) {
                toHitData.addModifier(-n4, "target illuminated by searchlight");
                n3 -= n4;
            }
        } else if (iGame.isPositionIlluminated(targetable.getPosition())) {
            toHitData.addModifier(-n3, "target illuminated by flare");
            n3 = 0;
        } else if (!(ammoType == null || ammoType.getAmmoType() != 1 && ammoType.getAmmoType() != 34 || ammoType.getMunitionType() != 8L && ammoType.getMunitionType() != 32L)) {
            toHitData.addModifier(-1, "incendiary/tracer ammo");
            --n3;
        }
        if (n3 > 0 && entity2 != null && entity2 instanceof Mech && ((Mech)entity2).hasLaserHeatSinks()) {
            boolean bl3 = false;
            if (entity2.heat > 0) {
                toHitData.addModifier(-n3, "target overheated with laser heatsinks");
                n3 = 0;
            } else if (entity2.heatBuildup > 0 || entity2.isStealthActive()) {
                bl3 = true;
            } else {
                object = iGame.getActions();
                while (object.hasMoreElements()) {
                    Mounted mounted;
                    WeaponType weaponType;
                    WeaponAttackAction weaponAttackAction;
                    EntityAction entityAction = (EntityAction)object.nextElement();
                    if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != entity2.getId() || (weaponType = (WeaponType)(mounted = entity2.getEquipment(weaponAttackAction.getWeaponId())).getType()).getHeat() == 0 && !mounted.isRapidfire()) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl3) {
                toHitData.addModifier(-1, "target uses laser heatsinks");
            }
        }
        if (entity2 != null && (!(entity instanceof Infantry) || entity instanceof BattleArmor) && (n = iGame.getPlanetaryConditions().getLightHeatBonus(entity2.heat)) < 0) {
            toHitData.addModifier(n, "target excess heat at night");
        }
        return toHitData;
    }
}

