/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.format;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.function.Function;
import org.rundeck.client.tool.format.BaseDataOutputFormatter;
import org.rundeck.client.tool.format.Formatable;
import org.rundeck.client.tool.format.OutputFormatter;

public class JsonFormatter
extends BaseDataOutputFormatter {
    final ObjectMapper mapper;

    public JsonFormatter() {
        this.mapper = new ObjectMapper();
    }

    public JsonFormatter(Function<Object, Optional<Formatable>> dataFormatter) {
        super(dataFormatter);
        this.mapper = new ObjectMapper();
    }

    public JsonFormatter(OutputFormatter base) {
        super(base);
        this.mapper = new ObjectMapper();
    }

    public JsonFormatter(OutputFormatter base, Function<Object, Optional<Formatable>> dataFormatter) {
        super(base, dataFormatter);
        this.mapper = new ObjectMapper();
    }

    public JsonFormatter(ObjectMapper mapper, OutputFormatter base) {
        super(base);
        this.mapper = mapper;
    }

    public JsonFormatter(OutputFormatter base, Function<Object, Optional<Formatable>> dataFormatter, ObjectMapper mapper) {
        super(base, dataFormatter);
        this.mapper = mapper;
    }

    @Override
    protected String formatObject(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean canFormatObject(Object value) {
        return true;
    }

    @Override
    protected OutputFormatter withBase(Function<Object, Optional<Formatable>> dataFormatter, OutputFormatter base) {
        return new JsonFormatter(base, dataFormatter, this.mapper);
    }
}

