/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class SingularField
extends AbstractRule {
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (node.isPrivate() && !node.isStatic()) {
            List<ASTVariableDeclaratorId> list = node.findChildrenOfType(ASTVariableDeclaratorId.class);
            ASTVariableDeclaratorId declaration = list.get(0);
            List<NameOccurrence> usages = declaration.getUsages();
            SimpleNode decl = null;
            boolean violation = true;
            for (int ix = 0; ix < usages.size(); ++ix) {
                NameOccurrence no = usages.get(ix);
                SimpleNode location = no.getLocation();
                SimpleNode method = location.getFirstParentOfType(ASTMethodDeclaration.class);
                if (method == null && (method = (SimpleNode)location.getFirstParentOfType(ASTConstructorDeclaration.class)) == null && (method = (SimpleNode)location.getFirstParentOfType(ASTInitializer.class)) == null) continue;
                if (decl == null) {
                    decl = method;
                    continue;
                }
                if (decl == method) continue;
                violation = false;
            }
            if (violation && !usages.isEmpty()) {
                this.addViolation(data, (Node)node, new Object[]{declaration.getImage()});
            }
        }
        return data;
    }
}

