/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.components.internal.AbstractUnderlineSupport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

final class LinkUnderlineSupport
extends AbstractUnderlineSupport {
    static final String PROPERTY_LINK_PAINTED = "linkPainted";
    private static final String KEY_STORED_FOREGROUND = "LinkUnderlineSupport.storedForegroundColor";
    private static final LinkUnderlineSupport INSTANCE = new LinkUnderlineSupport();

    private LinkUnderlineSupport() {
    }

    static boolean isLinkPainted(JTextComponent c) {
        return INSTANCE.isEnabled(c);
    }

    static void setLinkPainted(JTextComponent c, boolean newValue) {
        INSTANCE.setEnabled(c, newValue);
    }

    @Override
    protected void install(JTextComponent c) {
        c.putClientProperty(KEY_STORED_FOREGROUND, c.getForeground());
        c.setForeground(LinkUnderlineSupport.linkColor());
        c.setCursor(Cursor.getPredefinedCursor(12));
        super.install(c);
    }

    @Override
    protected void uninstall(JTextComponent c) {
        super.uninstall(c);
        Color oldForeground = (Color)c.getClientProperty(KEY_STORED_FOREGROUND);
        if (oldForeground != null) {
            c.setForeground(oldForeground);
        }
        c.setCursor(Cursor.getPredefinedCursor(2));
    }

    @Override
    protected DefaultHighlighter.DefaultHighlightPainter createHighlightPainter() {
        return new LinkUnderlinePainter();
    }

    private static Color linkColor() {
        Color c = UIManager.getColor("Hyperlink.unvisited.foreground");
        return c != null ? c : Color.BLUE;
    }

    private static final class LinkUnderlinePainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        LinkUnderlinePainter() {
            super(LinkUnderlineSupport.linkColor());
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            try {
                Shape shape = c.getUI().getRootView(c).modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                this.paintUnderline(g, LinkUnderlinePainter.outline(LinkUnderlinePainter.bounds(shape)));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Rectangle r = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = LinkUnderlinePainter.bounds(bounds);
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = LinkUnderlinePainter.bounds(shape);
                }
                catch (BadLocationException shape) {
                    // empty catch block
                }
            }
            if (r != null) {
                Rectangle rect = LinkUnderlinePainter.outline(r);
                this.paintUnderline(g, rect);
                return rect;
            }
            return null;
        }

        private void paintUnderline(Graphics g, Rectangle clip) {
            Color oldColor = g.getColor();
            Shape oldClip = g.getClip();
            g.setColor(this.getColor());
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setClip(oldClip);
            g.setColor(oldColor);
        }

        private static Rectangle bounds(Shape shape) {
            return shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        }

        private static Rectangle outline(Rectangle r) {
            return new Rectangle(r.x, r.y + r.height - 1, r.width, 1);
        }
    }
}

