/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.internal;

import com.jgoodies.common.jsdl.action.AbstractMnemonicAction;
import com.jgoodies.components.util.TextComponentUtils;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;

public final class PropertyPaneAction
extends AbstractMnemonicAction {
    private final CommandValue commitValue;
    private final PropertyPaneModel model;

    private PropertyPaneAction(CommandValue commitValue, PropertyPaneModel model) {
        super(commitValue.getMarkedText());
        this.commitValue = commitValue;
        this.model = model;
        if (commitValue == CommandValue.CANCEL) {
            this.updateCancelName();
            model.addPropertyChangeListener(this::onPropertyChange);
        } else if (commitValue == CommandValue.APPLY) {
            this.updateApplyEnablement();
            model.addPropertyChangeListener(this::onPropertyChange);
        }
    }

    public static Object[] createOKCancelApplyActionsFor(PropertyPaneModel model) {
        Object[] objectArray;
        if (model == null) {
            return new CommandValue[]{CommandValue.OK, CommandValue.CANCEL};
        }
        PropertyPaneAction okAction = new PropertyPaneAction(CommandValue.OK, model);
        PropertyPaneAction cancelAction = new PropertyPaneAction(CommandValue.CANCEL, model);
        if (model.isApplyVisible()) {
            Action[] actionArray = new Action[3];
            actionArray[0] = okAction;
            actionArray[1] = cancelAction;
            objectArray = actionArray;
            actionArray[2] = new PropertyPaneAction(CommandValue.APPLY, model);
        } else {
            Object[] objectArray2 = new Action[2];
            objectArray2[0] = okAction;
            objectArray = objectArray2;
            objectArray2[1] = cancelAction;
        }
        return objectArray;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TextComponentUtils.commitImmediately();
        if (this.commitValue == CommandValue.OK) {
            this.model.onOKPerformed(e);
        } else if (this.commitValue == CommandValue.CANCEL) {
            this.model.onCancelPerformed(e);
        } else if (this.commitValue == CommandValue.APPLY) {
            this.model.onApplyPerformed(e);
        } else {
            throw new IllegalStateException("unknown case");
        }
    }

    private void updateCancelName() {
        CommandValue value = this.model.getAllChangesAbandonable() ? CommandValue.CANCEL : CommandValue.CLOSE;
        this.setName(value.getMarkedText());
    }

    private void updateApplyEnablement() {
        this.setEnabled(this.model.isApplyEnabled());
    }

    private void onPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (this.commitValue == CommandValue.CANCEL && (propertyName == null || propertyName.equals("allChangesAbandonable"))) {
            this.updateCancelName();
        }
        if (this.commitValue == CommandValue.APPLY && (propertyName == null || propertyName.equals("applyEnabled"))) {
            this.updateApplyEnablement();
        }
    }
}

