/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.eventbus;

import com.jgoodies.framework.eventbus.AbstractEvent;
import com.jgoodies.framework.eventbus.EventBus;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultEventBus
implements EventBus {
    private final List<EventEntry<?>> listeners = new CopyOnWriteArrayList();

    @Override
    public <L extends EventListener> void addListener(Class<? extends AbstractEvent<L>> type, L listener) {
        this.listeners.add(new EventEntry<L>(type, listener));
    }

    @Override
    public <L extends EventListener> void removeListener(Class<? extends AbstractEvent<L>> type, L listener) {
        for (EventEntry<?> entry : this.listeners) {
            if (listener != entry.getListener()) continue;
            this.listeners.remove(entry);
        }
    }

    @Override
    public <L extends EventListener> void fireEvent(AbstractEvent<L> event) {
        for (EventEntry<?> eventEntry : this.listeners) {
            Object listener = eventEntry.getListener();
            if (listener == null) {
                this.listeners.remove(eventEntry);
                continue;
            }
            if (!eventEntry.matches(event)) continue;
            event.dispatch(listener);
        }
    }

    static final class EventEntry<L extends EventListener> {
        private final Class<? extends AbstractEvent<L>> eventClass;
        private final WeakReference<L> listenerReference;

        EventEntry(Class<? extends AbstractEvent<L>> eventClass, L listener) {
            this.eventClass = eventClass;
            this.listenerReference = new WeakReference<L>(listener);
        }

        boolean matches(AbstractEvent<?> event) {
            return this.eventClass.isInstance(event);
        }

        L getListener() {
            return (L)((EventListener)this.listenerReference.get());
        }
    }
}

