/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.primitive;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;

public class NegatingPrimitive<T>
implements PrimitiveCollection<T> {
    private final PrimitiveCollection<T> primitive;
    private final PrimitiveCollection<T> all;

    public NegatingPrimitive(PrimitiveCollection<T> prim, PrimitiveCollection<T> all) {
        if (prim == null) {
            throw new IllegalArgumentException("PrimitiveCollection cannot be null");
        }
        if (all == null) {
            throw new IllegalArgumentException("All Collection cannot be null");
        }
        this.primitive = prim;
        this.all = all;
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<T, R> c) {
        Collection<R> result = this.all.getCollection(pc, c);
        ArrayList<R> list = new ArrayList<R>(result);
        list.removeAll(this.primitive.getCollection(pc, c));
        return list;
    }

    @Override
    public Class<? super T> getReferenceClass() {
        return this.primitive.getReferenceClass();
    }

    @Override
    public GroupingState getGroupingState() {
        return this.primitive.getGroupingState().negate();
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return "!" + this.primitive.getLSTformat(useAny);
    }

    public int hashCode() {
        return this.primitive.hashCode() - 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof NegatingPrimitive && ((NegatingPrimitive)obj).primitive.equals(this.primitive);
    }
}

