/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.util.Delta;

public class EqModCost {
    private static final String s_CHARGES = "CHARGES";

    public static BigDecimal addItemCosts(EquipmentModifier eqMod, PlayerCharacter aPC, String bonusType, int qty, Equipment parent) {
        double val = 0.0;
        HashSet<String> typesToGetBonusesFor = new HashSet<String>();
        for (BonusObj bonus : eqMod.getBonusList(parent)) {
            String sub_type;
            boolean meetsAll = true;
            if (!bonus.getBonusName().equals(bonusType)) continue;
            StringTokenizer aTok = new StringTokenizer(bonus.toString().substring(bonusType.length()), "|", false);
            String bType = aTok.nextToken();
            aTok = new StringTokenizer(bType.substring(5), ".", false);
            String typeString = "TYPE";
            while (aTok.hasMoreTokens() && (meetsAll = parent.isType(sub_type = aTok.nextToken()))) {
                typeString = typeString + "." + sub_type;
            }
            if (!meetsAll) continue;
            typesToGetBonusesFor.add(typeString);
        }
        for (String typeString : typesToGetBonusesFor) {
            val += eqMod.bonusTo(aPC, bonusType, typeString, parent);
        }
        return new BigDecimal(val * (double)qty);
    }

    public static boolean getCostDouble(EquipmentModifier eqMod) {
        Boolean costdouble = eqMod.get(ObjectKey.COST_DOUBLE);
        if (costdouble == null) {
            if (eqMod.isType("MagicalEnhancement") || eqMod.isType("BaseMaterial")) {
                return false;
            }
            if (eqMod.isIType("MAGIC")) {
                return true;
            }
            for (Prerequisite preReq : eqMod.getPrerequisiteList()) {
                if (!"TYPE".equalsIgnoreCase(preReq.getKind()) || !preReq.getKey().equalsIgnoreCase("EQMODTYPE=MagicalEnhancement") && !preReq.getKey().equalsIgnoreCase("EQMODTYPE.MagicalEnhancement")) continue;
                return true;
            }
            return false;
        }
        return costdouble;
    }

    public static String getCost(EquipmentModifier eqMod, String listEntry) {
        String costFormula = eqMod.getSafe(FormulaKey.COST).toString();
        String modChoice = "";
        while (costFormula.indexOf("%SPELLLEVEL") >= 0) {
            int idx = costFormula.indexOf("%SPELLLEVEL");
            if (modChoice.length() == 0) {
                int iLevel = EqModSpellInfo.getSpellInfo(listEntry, "SPELLLEVEL");
                modChoice = iLevel == 0 ? "0.5" : Integer.toString(iLevel);
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 11);
        }
        costFormula = EqModCost.replaceCostSpellCost(costFormula, listEntry);
        costFormula = EqModCost.replaceCostSpellXPCost(costFormula, listEntry);
        costFormula = EqModCost.replaceCostCasterLevel(costFormula, listEntry);
        costFormula = EqModCost.replaceCostCharges(costFormula, listEntry);
        costFormula = EqModCost.replaceCostChoice(costFormula, listEntry);
        return costFormula;
    }

    private static String replaceCostCasterLevel(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%CASTERLEVEL") >= 0) {
            int idx = costFormula.indexOf("%CASTERLEVEL");
            if (modChoice.length() == 0) {
                PCClass castClass;
                int iCasterLevel = EqModSpellInfo.getSpellInfo(listEntry, "CASTERLEVEL");
                modChoice = Integer.toString(iCasterLevel);
                String castClassKey = EqModSpellInfo.getSpellInfoString(listEntry, "CASTER");
                if (castClassKey.length() != 0 && (castClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, castClassKey)) != null) {
                    StringBuilder multiple = new StringBuilder(200);
                    String aString = castClass.get(StringKey.ITEMCREATE);
                    if (aString != null && aString.length() != 0) {
                        StringTokenizer aTok = new StringTokenizer(aString, "+-*/()", true);
                        if (aTok.countTokens() == 1) {
                            multiple.append(iCasterLevel).append('*').append(aString);
                        } else {
                            while (aTok.hasMoreTokens()) {
                                aString = aTok.nextToken();
                                if (aString.equals("CL")) {
                                    multiple.append(iCasterLevel);
                                    continue;
                                }
                                multiple.append(aString);
                            }
                        }
                        modChoice = multiple.toString();
                    }
                }
            }
            costFormula = costFormula.substring(0, idx) + "(" + modChoice + ")" + costFormula.substring(idx + 12);
        }
        return costFormula;
    }

    private static String replaceCostCharges(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%CHARGES") >= 0) {
            int idx = costFormula.indexOf("%CHARGES");
            if (modChoice.length() == 0) {
                modChoice = Integer.toString(EqModSpellInfo.getSpellInfo(listEntry, s_CHARGES));
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 8);
        }
        return costFormula;
    }

    private static String replaceCostSpellCost(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%SPELLCOST") >= 0) {
            String spellName;
            Spell aSpell;
            int idx = costFormula.indexOf("%SPELLCOST");
            if (modChoice.length() == 0 && (aSpell = Globals.getSpellKeyed(spellName = EqModSpellInfo.getSpellInfoString(listEntry, "SPELLNAME"))) != null) {
                modChoice = aSpell.getSafe(ObjectKey.COST).toString();
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 10);
        }
        return costFormula;
    }

    private static String replaceCostChoice(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%CHOICE") >= 0) {
            int idx = costFormula.indexOf("%CHOICE");
            if (modChoice.length() == 0) {
                int offs = listEntry.lastIndexOf(124);
                int modValue = 0;
                try {
                    modValue = Delta.parseInt(listEntry.substring(offs + 1));
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                modChoice = Integer.toString(modValue);
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 7);
        }
        return costFormula;
    }

    private static String replaceCostSpellXPCost(String costFormula, String listEntry) {
        String modChoice = "";
        while (costFormula.indexOf("%SPELLXPCOST") >= 0) {
            String spellName;
            Spell aSpell;
            int idx = costFormula.indexOf("%SPELLXPCOST");
            if (modChoice.length() == 0 && (aSpell = Globals.getSpellKeyed(spellName = EqModSpellInfo.getSpellInfoString(listEntry, "SPELLNAME"))) != null) {
                modChoice = Integer.toString(aSpell.getSafe(IntegerKey.XP_COST));
            }
            costFormula = costFormula.substring(0, idx) + modChoice + costFormula.substring(idx + 12);
        }
        return costFormula;
    }
}

