/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.FormatManager;
import pcgen.base.util.FormatManagerLibrary;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.CategorizedClassIdentity;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SubClassCategory;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.cdom.util.IntegerKeyComparator;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.SubClass;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

public abstract class AbstractReferenceContext {
    private static final Class<Categorized> CATEGORIZED_CLASS = Categorized.class;
    private static final Class<DomainSpellList> DOMAINSPELLLIST_CLASS = DomainSpellList.class;
    private static final Class<ClassSkillList> CLASSSKILLLIST_CLASS = ClassSkillList.class;
    private static final Class<ClassSpellList> CLASSSPELLLIST_CLASS = ClassSpellList.class;
    private static final Class<SubClass> SUBCLASS_CLASS = SubClass.class;
    private DoubleKeyMap<Class<?>, Object, WeakReference<List<?>>> sortedMap = new DoubleKeyMap();
    private final Map<CDOMObject, CDOMSingleRef<?>> directRefCache = new HashMap();
    private URI sourceURI;
    private URI extractURI;

    public abstract <T extends Loadable> ReferenceManufacturer<T> getManufacturer(Class<T> var1);

    public abstract <T extends Loadable> boolean hasManufacturer(Class<T> var1);

    protected abstract <T extends Categorized<T>> boolean hasManufacturer(Class<T> var1, Category<T> var2);

    public abstract Collection<? extends ReferenceManufacturer<?>> getAllManufacturers();

    public boolean validate(UnconstructedValidator validator) {
        boolean returnGood = true;
        for (ReferenceManufacturer<?> ref : this.getAllManufacturers()) {
            returnGood &= ref.validate(validator);
        }
        return returnGood;
    }

    public <T extends Loadable> CDOMGroupRef<T> getCDOMAllReference(Class<T> c) {
        return this.getManufacturer(c).getAllReference();
    }

    public <T extends Categorized<T>> CDOMGroupRef<T> getCDOMAllReference(Class<T> c, Category<T> cat) {
        return this.getManufacturer(c, cat).getAllReference();
    }

    public <T extends Loadable> CDOMGroupRef<T> getCDOMTypeReference(Class<T> c, String ... val) {
        return this.getManufacturer(c).getTypeReference(val);
    }

    public <T extends Categorized<T>> CDOMGroupRef<T> getCDOMTypeReference(Class<T> c, Category<T> cat, String ... val) {
        return this.getManufacturer(c, cat).getTypeReference(val);
    }

    public <T extends Loadable> T constructCDOMObject(Class<T> c, String val) {
        T obj;
        if (CATEGORIZED_CLASS.isAssignableFrom(c)) {
            Class<T> cl = c;
            obj = this.getManufacturer(cl, null).constructObject(val);
        } else {
            obj = this.getManufacturer(c).constructObject(val);
        }
        obj.setSourceURI(this.sourceURI);
        return obj;
    }

    public <T extends Loadable> void constructIfNecessary(Class<T> cl, String value) {
        this.getManufacturer(cl).constructIfNecessary(value);
    }

    public <T extends Loadable> CDOMSingleRef<T> getCDOMReference(Class<T> c, String val) {
        return this.getManufacturer(c).getReference(val);
    }

    public <T extends Categorized<T>> CDOMSingleRef<T> getCDOMReference(Class<T> c, Category<T> cat, String val) {
        return this.getManufacturer(c, cat).getReference(val);
    }

    public <T extends Loadable> void reassociateKey(String key, T obj) {
        if (CATEGORIZED_CLASS.isAssignableFrom(obj.getClass())) {
            Class<?> cl = obj.getClass();
            this.reassociateCategorizedKey(key, obj, cl);
        } else {
            this.getManufacturer(obj.getClass()).renameObject(key, obj);
        }
    }

    private <T extends Categorized<T>> void reassociateCategorizedKey(String key, Loadable orig, Class<T> cl) {
        Categorized obj = (Categorized)orig;
        this.getManufacturer(cl, obj.getCDOMCategory()).renameObject(key, obj);
    }

    public <T extends Loadable> T silentlyGetConstructedCDOMObject(Class<T> c, String val) {
        return this.getManufacturer(c).getActiveObject(val);
    }

    public <T extends Categorized<T>> T silentlyGetConstructedCDOMObject(Class<T> c, Category<T> cat, String val) {
        return (T)((Categorized)this.getManufacturer(c, cat).getActiveObject(val));
    }

    public <T extends Categorized<T>> void reassociateCategory(Category<T> cat, T obj) {
        Category<T> oldCat = obj.getCDOMCategory();
        if (oldCat == null && cat == null || oldCat != null && oldCat.equals(cat)) {
            Logging.errorPrint("Worthless Category change encountered: " + obj.getDisplayName() + " " + oldCat);
        }
        this.reassociateCategory(this.getGenericClass(obj), obj, oldCat, cat);
    }

    protected <T> Class<T> getGenericClass(T obj) {
        return obj.getClass();
    }

    private <T extends Categorized<T>> void reassociateCategory(Class<T> cl, T obj, Category<T> oldCat, Category<T> cat) {
        this.getManufacturer(cl, oldCat).forgetObject(obj);
        obj.setCDOMCategory(cat);
        this.getManufacturer(cl, cat).addObject(obj, obj.getKeyName());
    }

    public <T extends Loadable> void importObject(T orig) {
        if (CATEGORIZED_CLASS.isAssignableFrom(orig.getClass())) {
            Class<?> cl = orig.getClass();
            this.importCategorized(orig, cl);
        } else {
            this.getManufacturer(orig.getClass()).addObject(orig, orig.getKeyName());
        }
    }

    private <T extends Categorized<T>> void importCategorized(Loadable orig, Class<T> cl) {
        Categorized obj = (Categorized)orig;
        this.getManufacturer(cl, obj.getCDOMCategory()).addObject(obj, obj.getKeyName());
    }

    public <T extends Loadable> boolean forget(T obj) {
        if (CATEGORIZED_CLASS.isAssignableFrom(obj.getClass())) {
            Categorized cdo;
            Class<?> cl = obj.getClass();
            if (this.hasManufacturer(cl, (cdo = (Categorized)obj).getCDOMCategory())) {
                return this.getManufacturer(cl, cdo.getCDOMCategory()).forgetObject(obj);
            }
        } else if (this.hasManufacturer(obj.getClass())) {
            return this.getManufacturer(obj.getClass()).forgetObject(obj);
        }
        return false;
    }

    public <T extends Loadable> Collection<T> getConstructedCDOMObjects(Class<T> c) {
        return this.getManufacturer(c).getAllObjects();
    }

    public <T extends Loadable> List<T> getOrderSortedCDOMObjects(Class<T> c) {
        return this.getManufacturer(c).getOrderSortedObjects();
    }

    public Set<Object> getAllConstructedObjects() {
        HashSet<Object> set = new HashSet<Object>();
        for (ReferenceManufacturer<?> ref : this.getAllManufacturers()) {
            set.addAll(ref.getAllObjects());
        }
        return set;
    }

    public <T extends Loadable> boolean containsConstructedCDOMObject(Class<T> c, String s) {
        return this.getManufacturer(c).containsObject(s);
    }

    public void buildDerivedObjects() {
        Collection<Domain> domains = this.getConstructedCDOMObjects(Domain.class);
        for (Domain d : domains) {
            DomainSpellList dsl = this.constructCDOMObject(DOMAINSPELLLIST_CLASS, d.getKeyName());
            dsl.addType(Type.DIVINE);
            d.put(ObjectKey.DOMAIN_SPELLLIST, dsl);
        }
        Collection<PCClass> classes = this.getConstructedCDOMObjects(PCClass.class);
        for (PCClass pcc : classes) {
            String key = pcc.getKeyName();
            ClassSkillList skl = this.constructCDOMObject(CLASSSKILLLIST_CLASS, key);
            boolean isMonster = pcc.isMonster();
            if (isMonster) {
                skl.addType(Type.MONSTER);
            }
            pcc.put(ObjectKey.CLASS_SKILLLIST, skl);
            ClassSpellList csl = this.constructCDOMObject(CLASSSPELLLIST_CLASS, key);
            FactKey fk = FactKey.valueOf("SpellType");
            String spelltype = (String)pcc.getResolved(fk);
            if (spelltype != null) {
                csl.addType(Type.getConstant(spelltype));
            }
            pcc.put(ObjectKey.CLASS_SPELLLIST, csl);
            if (!pcc.containsListFor(ListKey.SUB_CLASS)) continue;
            SubClassCategory cat = SubClassCategory.getConstant(key);
            boolean needSelf = pcc.getSafe(ObjectKey.ALLOWBASECLASS);
            for (SubClass subcl : pcc.getListFor(ListKey.SUB_CLASS)) {
                String subKey = subcl.getKeyName();
                if (subKey.equalsIgnoreCase(key)) {
                    Logging.errorPrint("Cannot explicitly create a SUBCLASS that matches the parent class.  Use ALLOWBASECLASS.  Tokens on the offending SUBCLASS line will be ignored");
                    pcc.removeFromListFor(ListKey.SUB_CLASS, subcl);
                    continue;
                }
                skl = this.constructCDOMObject(CLASSSKILLLIST_CLASS, subKey);
                if (isMonster) {
                    skl.addType(Type.MONSTER);
                }
                subcl.put(ObjectKey.CLASS_SKILLLIST, skl);
                csl = this.constructCDOMObject(CLASSSPELLLIST_CLASS, subKey);
                if (spelltype != null) {
                    csl.addType(Type.getConstant(spelltype));
                }
                subcl.put(ObjectKey.CLASS_SPELLLIST, csl);
                subcl.setCDOMCategory(cat);
                this.importObject(subcl);
            }
            if (!needSelf) continue;
            SubClass self = this.constructCDOMObject(SUBCLASS_CLASS, key);
            this.reassociateCategory(SUBCLASS_CLASS, self, null, cat);
        }
    }

    public <T extends CDOMObject> CDOMSingleRef<T> getCDOMDirectReference(T obj) {
        CDOMSingleRef<?> ref = this.directRefCache.get(obj);
        if (ref == null) {
            ref = new CDOMDirectSingleRef(obj);
        }
        return ref;
    }

    URI getExtractURI() {
        return this.extractURI;
    }

    void setExtractURI(URI extractURI) {
        this.extractURI = extractURI;
    }

    URI getSourceURI() {
        return this.sourceURI;
    }

    void setSourceURI(URI sourceURI) {
        this.sourceURI = sourceURI;
    }

    public boolean resolveReferences(UnconstructedValidator validator) {
        boolean returnGood = true;
        for (ReferenceManufacturer<?> rs : this.getAllManufacturers()) {
            returnGood &= this.processResolution(validator, rs);
        }
        return returnGood;
    }

    private <T extends Loadable> boolean processResolution(UnconstructedValidator validator, ReferenceManufacturer<T> rs) {
        ManufacturableFactory<T> factory = rs.getFactory();
        ManufacturableFactory<T> parent = factory.getParent();
        ReferenceManufacturer<T> manufacturer = parent == null ? null : this.getManufacturer(parent);
        return factory.populate(manufacturer, rs, validator) && rs.resolveReferences(validator);
    }

    public void buildDeferredObjects() {
        for (ReferenceManufacturer<?> rs : this.getAllManufacturers()) {
            rs.buildDeferredObjects();
        }
    }

    public <T extends Loadable> T constructNowIfNecessary(Class<T> cl, String name) {
        return this.getManufacturer(cl).constructNowIfNecessary(name);
    }

    public <T extends Loadable> int getConstructedObjectCount(Class<T> c) {
        return this.getManufacturer(c).getConstructedObjectCount();
    }

    public <T extends Loadable> T getItemInOrder(Class<T> cl, int item) {
        return this.getManufacturer(cl).getItemInOrder(item);
    }

    public <T extends Loadable> ReferenceManufacturer<T> getManufacturer(ClassIdentity<T> identity) {
        Class<T> cl = identity.getChoiceClass();
        if (Categorized.class.isAssignableFrom(cl)) {
            Category category = ((CategorizedClassIdentity)identity).getCategory();
            return this.getManufacturer(cl, category);
        }
        return this.getManufacturer(cl);
    }

    public <T extends CDOMObject> List<T> getSortedList(Class<T> cl, IntegerKey key) {
        List<CDOMObject> returnList;
        WeakReference wr = (WeakReference)this.sortedMap.get(cl, (Object)key);
        if (wr == null || (returnList = (List<CDOMObject>)wr.get()) == null) {
            returnList = this.generateList(cl, new IntegerKeyComparator(key));
            this.sortedMap.put(cl, (Object)key, new WeakReference<List<CDOMObject>>(returnList));
        }
        return Collections.unmodifiableList(returnList);
    }

    public <T extends CDOMObject> List<T> getSortOrderedList(Class<T> cl) {
        List<CDOMObject> returnList;
        Comparator<CDOMObject> comp = Globals.pObjectNameComp;
        WeakReference wr = (WeakReference)this.sortedMap.get(cl, comp);
        if (wr == null || (returnList = (List<CDOMObject>)wr.get()) == null) {
            returnList = this.generateList(cl, comp);
            this.sortedMap.put(cl, comp, new WeakReference<List<CDOMObject>>(returnList));
        }
        return Collections.unmodifiableList(returnList);
    }

    private <T extends CDOMObject> List<T> generateList(Class<T> cl, Comparator<? super T> comp) {
        TreeSet<T> tm = new TreeSet<T>(comp);
        tm.addAll(this.getConstructedCDOMObjects(cl));
        return new ArrayList<T>(tm);
    }

    public abstract <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> var1, Category<T> var2);

    public abstract <T extends Loadable> ReferenceManufacturer<T> getManufacturer(ManufacturableFactory<T> var1);

    public abstract <T extends Categorized<T>> ReferenceManufacturer<T> getManufacturer(Class<T> var1, Class<? extends Category<T>> var2, String var3);

    abstract <T extends CDOMObject> T performCopy(T var1, String var2);

    public abstract <T extends CDOMObject> T performMod(T var1);

    public <T> FormatManager<T> getFormatManager(Class<T> cl) {
        if (Categorized.class.isAssignableFrom(cl)) {
            throw new IllegalArgumentException("Cannot support Categorized items");
        }
        if (Loadable.class.isAssignableFrom(cl)) {
            return this.getManufacturer(cl);
        }
        return FormatManagerLibrary.getFormatManager(cl);
    }

    public FormatManager<?> getFormatManager(String clName) {
        Class<? extends Loadable> cl = StringPClassUtil.getClassFor(clName);
        if (cl != null) {
            return this.getManufacturer(cl);
        }
        return FormatManagerLibrary.getFormatManager(clName);
    }
}

