/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreMoveTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int runningTotal = 0;
        int moveAmount = 0;
        if (display != null && display.hasMovement()) {
            String moveType = prereq.getKey();
            try {
                moveAmount = Integer.parseInt(prereq.getOperand());
            }
            catch (NumberFormatException e) {
                throw new PrerequisiteException(LanguageBundle.getFormattedString("PreMove.error.bad_operand", prereq.toString()));
            }
            int speed = (int)display.getMovementOfType(moveType);
            if (speed >= moveAmount) {
                runningTotal += speed;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, moveAmount);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "MOVE";
    }
}

