/*
 * Decompiled with CFR 0.152.
 */
package plugin.qualifier.weaponprof;

import java.util.Collection;
import java.util.logging.Level;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.converter.AddFilterConverter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public class SpellCasterToken
implements QualifierToken<WeaponProf>,
PrimitiveFilter<WeaponProf> {
    private PrimitiveCollection<WeaponProf> pcs = null;

    @Override
    public String getTokenName() {
        return "SPELLCASTER";
    }

    @Override
    public Class<WeaponProf> getReferenceClass() {
        return WeaponProf.class;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTokenName()).append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        return sb.toString();
    }

    @Override
    public boolean initialize(LoadContext context, SelectionCreator<WeaponProf> sc, String condition, String value, boolean negate) {
        if (negate) {
            Logging.addParseMessage(Level.SEVERE, "Cannot make " + this.getTokenName() + " into a negated Qualifier, remove !");
            return false;
        }
        if (condition != null) {
            Logging.addParseMessage(Level.SEVERE, "Cannot make " + this.getTokenName() + " into a conditional Qualifier, remove =");
            return false;
        }
        if (value == null) {
            Logging.addParseMessage(Level.SEVERE, "Cannot use " + this.getTokenName() + " as an unconditional Qualifier, requires brackets");
            return false;
        }
        ReferenceManufacturer<WeaponProf> erm = context.getReferenceContext().getManufacturer(WeaponProf.class);
        this.pcs = context.getPrimitiveChoiceFilter(erm, value);
        return this.pcs != null;
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SpellCasterToken) {
            SpellCasterToken other = (SpellCasterToken)o;
            if (this.pcs == null) {
                return other.pcs == null;
            }
            return this.pcs.equals(other.pcs);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        return this.pcs.getGroupingState().reduce();
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<WeaponProf, R> c) {
        return this.pcs.getCollection(pc, new AddFilterConverter<WeaponProf, R>(c, this));
    }

    @Override
    public boolean allow(PlayerCharacter pc, WeaponProf po) {
        return pc.isSpellCaster(1);
    }
}

