/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.util.Urls;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;

public class XMLHttpRequest
extends AbstractScriptableDelegate {
    private static final Logger logger = Logger.getLogger(XMLHttpRequest.class.getName());
    private final HttpRequest request;
    private final UserAgentContext pcontext;
    private final Scriptable scope;
    private final URL codeSource;
    private Function onreadystatechange;
    private boolean listenerAdded;

    public XMLHttpRequest(UserAgentContext pcontext, URL codeSource, Scriptable scope) {
        this.request = pcontext.createHttpRequest();
        this.pcontext = pcontext;
        this.scope = scope;
        this.codeSource = codeSource;
    }

    public void abort() {
        this.request.abort();
    }

    public String getAllResponseHeaders() {
        return this.request.getAllResponseHeaders();
    }

    public int getReadyState() {
        return this.request.getReadyState();
    }

    public byte[] getResponseBytes() {
        return this.request.getResponseBytes();
    }

    public String getResponseHeader(String headerName) {
        return this.request.getResponseHeader(headerName);
    }

    public String getResponseText() {
        return this.request.getResponseText();
    }

    public Document getResponseXML() {
        return this.request.getResponseXML();
    }

    public int getStatus() {
        return this.request.getStatus();
    }

    public String getStatusText() {
        return this.request.getStatusText();
    }

    private URL getFullURL(String relativeUrl) throws MalformedURLException {
        return Urls.createURL(this.codeSource, relativeUrl);
    }

    public void open(String method, String url, boolean asyncFlag, String userName, String password) throws IOException {
        this.request.open(method, this.getFullURL(url), asyncFlag, userName, password);
    }

    public void open(String method, String url, boolean asyncFlag, String userName) throws IOException {
        this.request.open(method, this.getFullURL(url), asyncFlag, userName);
    }

    public void open(String method, String url, boolean asyncFlag) throws IOException {
        this.request.open(method, this.getFullURL(url), asyncFlag);
    }

    public void open(String method, String url) throws IOException {
        this.request.open(method, this.getFullURL(url));
    }

    public void send(String content) throws IOException {
        this.request.send(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getOnreadystatechange() {
        XMLHttpRequest xMLHttpRequest = this;
        synchronized (xMLHttpRequest) {
            return this.onreadystatechange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnreadystatechange(Function value) {
        XMLHttpRequest xMLHttpRequest = this;
        synchronized (xMLHttpRequest) {
            this.onreadystatechange = value;
            if (value != null && !this.listenerAdded) {
                this.request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                    public void readyStateChanged() {
                        XMLHttpRequest.this.executeReadyStateChange();
                    }
                });
                this.listenerAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeReadyStateChange() {
        block5: {
            try {
                Function f = this.getOnreadystatechange();
                if (f == null) break block5;
                Context ctx = Executor.createContext(this.codeSource, this.pcontext);
                try {
                    Scriptable newScope = (Scriptable)JavaScript.getInstance().getJavascriptObject(this, this.scope);
                    f.call(ctx, newScope, newScope, new Object[0]);
                }
                finally {
                    Context.exit();
                }
            }
            catch (Exception err) {
                logger.log(Level.WARNING, "Error processing ready state change.", err);
            }
        }
    }
}

