/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CostToken
extends AbstractNonEmptyToken<Equipment>
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "COST";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Equipment eq, String value) {
        try {
            BigDecimal cost = new BigDecimal(value);
            context.getObjectContext().put((CDOMObject)eq, ObjectKey.COST, (Object)cost);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException e) {
            return new ParseResult.Fail(this.getTokenName() + " expected a number: " + value, context);
        }
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        BigDecimal bd = (BigDecimal)context.getObjectContext().getObject((CDOMObject)eq, ObjectKey.COST);
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

