/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2002 Pascal Bourut (toweld@rocketmail.com)

    Network part from grrrreg (greg@doodoo.darktech.org)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Network.h"

Uint16 Network::getPort() {
  return port;
}

int Network::send_msg(char* data_send, ...) {
  int msg_length = 0;
  int ret = 0;

  va_list marker;
  char temp[256];

  va_start(marker, data_send);
  vsprintf(temp, data_send, marker);
  va_end(marker);

  msg_length = strlen(temp)+1;
  ret = SDLNet_TCP_Send(parloteSocket,temp,msg_length);
  if (ret < msg_length) return 0;
  return(1);
}


 char* Network::rcv_msg() {
	 data_received[0] = '\0';

   SDLNet_CheckSockets(socketSet, WAIT_TIMEOUT);
   
   if (SDLNet_SocketReady(parloteSocket)) {

     if (SDLNet_TCP_Recv(parloteSocket,data_received, MAX_MSG_LEN) ==-1) {
       printf("Network::rcv_msg() %s\n",SDLNet_GetError());
       return NULL;
     }
   }
   else return NULL;

   return data_received;
 }

 char* Network::rcv_msg(int timeout) {
	  data_received[0] = '\0';

   SDLNet_CheckSockets(socketSet, timeout);
   
   if (SDLNet_SocketReady(parloteSocket)) {

     if (SDLNet_TCP_Recv(parloteSocket,data_received, MAX_MSG_LEN) ==-1) {
       printf("NetSever::rcv_msg() %s\n",SDLNet_GetError());
       return NULL;
     }
   }
   else return  NULL;

   return data_received;
 }


 int Network::get_type(){
	 return type;
 }

 void Network::set_nickname(char* nick){
	nickname = (char*)malloc( CHAR_64 );
	sprintf(nickname,"%s",nick);
 }

 char* Network::get_nickname(void){
	return nickname;	
 }

 void Network::set_adversary_nickname(char* nick){
	adversary_nickname = (char*)malloc( CHAR_64 );
	sprintf(adversary_nickname,"%s",nick);
 }

 char* Network::get_adversary_nickname(void){
	return adversary_nickname;	
 }

void Network::set_ready(bool b){
	ready = b;
}

bool Network::is_ready(void){
	return ready;	
}
