/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.io.File;
import java.util.List;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.nativeplatform.internal.modulemap.GenerateModuleMapFile;
import org.gradle.nativeplatform.internal.modulemap.ModuleMap;

public class NativeDependencyCache
implements Stoppable {
    private final PersistentCache cache;

    public NativeDependencyCache(GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        this.cache = cacheBuilderFactory.createCacheBuilder("native-dep").withInitialLockMode(FileLockManager.LockMode.OnDemand).open();
    }

    public File getModuleMapFile(ModuleMap moduleMap) {
        String hash = moduleMap.getHashCode().toCompactString();
        return (File)this.cache.useCache(() -> {
            File dir = new File(this.cache.getBaseDir(), "maps/" + hash + "/" + moduleMap.getModuleName());
            File moduleMapFile = new File(dir, "module.modulemap");
            if (!moduleMapFile.isFile()) {
                GenerateModuleMapFile.generateFile((File)moduleMapFile, (String)moduleMap.getModuleName(), (List)moduleMap.getPublicHeaderPaths());
            }
            return moduleMapFile;
        });
    }

    public void stop() {
        this.cache.close();
    }
}

