package require poTcllib
package require tcl3d

proc tclCreateFunc {} {
}

proc tclDisplayFunc {} {
}

proc tclReshapeFunc { w h } {
}

frame .fr
pack .fr -expand 1 -fill both
togl .fr.toglwin -width 400 -height 400 -double true -alpha true -alpha true -depth true -accum true
listbox .fr.usage -height 8
grid .fr.toglwin -row 0 -column 0 -sticky news
grid .fr.usage   -row 1 -column 0 -sticky news
grid rowconfigure .fr 0 -weight 1
grid columnconfigure .fr 0 -weight 1

set csvFileList [glob *.csv]

::poCsv::SetSeparatorChar ";"
::poCsv::SetNumHeaderLines 2

set glCmdList  [info commands gl*]
set glEnumList [info globals GL_*]

set maxSize 20
set intVec    [tcl3dVector GLint     $maxSize]
set boolVec   [tcl3dVector GLboolean $maxSize]
set ubyteVec  [tcl3dVector GLubyte   $maxSize]
set floatVec  [tcl3dVector GLfloat   $maxSize]
set doubleVec [tcl3dVector GLdouble  $maxSize]

foreach csvFile $csvFileList {
    puts "File $csvFile"
    set csvList [::poCsv::Read $csvFile]
    set row 0
    foreach line $csvList {
        for { set i 0 } { $i < $maxSize } { incr i } {
            $intVec    set $i -10000
            $ubyteVec  set $i  100
            $boolVec   set $i  100
            $floatVec  set $i -10000.0
            $doubleVec set $i -10000.0
        }
        set enumVal [lindex $line 0]
        set descr   [lindex $line 1]
        set initVal [string trim [lindex $line 3] " ()"]
        set glCmd   [string trim [lindex $line 4] " ()"]

        set glCmd [string trim [lindex [split $glCmd ","] end] " ()"]

        if { [string compare $initVal "Identity"] == 0 } {
            set numVals 16
        } elseif { [lsearch -exact $glEnumList $initVal] >= 0 } {
            set numVals 1
            set tmp [format "\$::%s" $initVal]
            set initVal [expr $tmp]
        } else {
            set initValList [split $initVal ","]
            set numVals [llength $initValList]
        }
        
        if { [lsearch -exact $glCmdList $glCmd] >= 0 } {
            puts "Found $glCmd $enumVal $numVals"

            # Put all functions ending with "fv" which need special handling
            # at the top. All others are handled with the default case used
            # for glGetFloatv.
            if { [string equal "glGetPixelMapfv" $glCmd] } {
                set sizeEnum [format "%s_SIZE" $enumVal]
                glGetIntegerv $sizeEnum $intVec
                set numMapEntries [$intVec get 0]
                set mapTable [tcl3dVector GLfloat $numMapEntries]
                $glCmd $enumVal $mapTable
                set result {}
                for { set i 0 } { $i < $numMapEntries } { incr i } {
                    lappend result [$mapTable get $i]
                }
                $mapTable delete
                puts "\t$enumVal is $result (Should be $initVal)"
            } elseif { [string equal "glGetMaterialfv" $glCmd] } {
                foreach face { GL_FRONT GL_BACK GL_FRONT_AND_BACK } {
                    $glCmd $face $enumVal $floatVec
                    set result {}
                    for { set i 0 } { $i < $numVals } { incr i } {
                        lappend result [$floatVec get $i]
                    }
                    puts "\t$face $enumVal is $result (Shoud be $initVal)"
                }
            } elseif { [string equal "glGetLightfv" $glCmd] } {
                for {set lgtNum 0 } { $lgtNum < 8 } { incr lgtNum } {
                    set light [format "GL_LIGHT%d" $lgtNum]
                    $glCmd $light $enumVal $floatVec
                    set result {}
                    for { set i 0 } { $i < $numVals } { incr i } {
                        lappend result [$floatVec get $i]
                    }
                    puts "\t$light $enumVal is $result (Shoud be $initVal)"
                }
            } elseif { [string match "glGetTex*fv" $glCmd] } {
                foreach target { GL_TEXTURE_1D GL_TEXTURE_2D } {
                    $glCmd $target $enumVal $floatVec
                    set result {}
                    for { set i 0 } { $i < $numVals } { incr i } {
                        lappend result [$floatVec get $i]
                    }
                    puts "\t$target $enumVal is $result (Shoud be $initVal)"
                }
            } elseif { [string match "glGetTex*iv" $glCmd] } {
                foreach target { GL_TEXTURE_1D GL_TEXTURE_2D } {
                    $glCmd $target $enumVal $intVec
                    set result {}
                    for { set i 0 } { $i < $numVals } { incr i } {
                        lappend result [$intVec get $i]
                    }
                    puts "\t$target $enumVal is $result (Shoud be $initVal)"
                }
            } elseif { [string equal "glGetFloatv" $glCmd] || \
                       [string match "*fv" $glCmd] } {
                $glCmd $enumVal $floatVec
                set result {}
                for { set i 0 } { $i < $numVals } { incr i } {
                    lappend result [$floatVec get $i]
                }
                puts "\t$enumVal is $result (Should be $initVal)"
            } elseif { [string equal "glGetIntegerv" $glCmd] } {
                $glCmd $enumVal $intVec
                set result {}
                for { set i 0 } { $i < $numVals } { incr i } {
                    lappend result [$intVec get $i]
                }
                puts "\t$enumVal is $result (Shoud be $initVal)"
            } elseif { [string equal "glGetBooleanv" $glCmd] } {
                $glCmd $enumVal $boolVec
                set result {}
                for { set i 0 } { $i < $numVals } { incr i } {
                    lappend result [$boolVec get $i]
                }
                puts "\t$enumVal is $result (Shoud be $initVal)"
            } elseif { [string equal "glGetClipPlane" $glCmd] } {
                $glCmd $enumVal $doubleVec
                set result {}
                for { set i 0 } { $i < $numVals } { incr i } {
                    lappend result [$doubleVec get $i]
                }
                puts "\t$enumVal is $result (Should be $initVal)"
            } elseif { [string equal "glIsEnabled" $glCmd] } {
                set result [$glCmd $enumVal]
                puts "\t$enumVal is $result (Shoud be $initVal)"
            } elseif { [string equal "glGetError" $glCmd] } {
                set result [$glCmd]
                puts "\t$enumVal is $result (Shoud be $initVal)"
            } elseif { [string equal "glGetPolygonStipple" $glCmd] } {
#                $glCmd $ubyteVec
#                set result {}
#                for { set i 0 } { $i < $numVals } { incr i } {
#                    lappend result [$ubyteVec get $i]
#                }
#                puts "\t$enumVal is $result (Shoud be $initVal)"
            } else {
                puts "NOT handled glCmd <$glCmd $enumVal $numVals>"
            }
        } else {
            puts "NOT found in glCmdList <$glCmd $enumVal $numVals>"
        }
    }
    incr row
}

exit
