/******************************************************************************
 *{@C
 *      Copyright:      2005-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       list2vector.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for converting Tcl lists into tcl3dVector's.
 *
 *                      Note: tcl3dVectors of type "char", "unsigned char", 
 *                      GLchar and GLcharARB are not supported, because the
 *                      corresponding typemaps would collide with the standard
 *                      SWIG mapping for C strings.
 *                      Use types GLbyte and GLubyte, if you need tcl3dVectors
 *                      with element sizes of 1 byte.
 *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <tcl.h>

%define %ListToVector(TYPE,NAME)
%{
static int tcl3dListToVector_##NAME (Tcl_Interp *interp, const TYPE *list, void *vector, int n)
{
    int i;
    TYPE *dst = vector;

    for (i=0; i<n; i++) {
        *dst++ = *list++;
    }
    return TCL_OK;
}
%}

int tcl3dListToVector_##NAME (Tcl_Interp *interp, const TYPE *list, void *vector, int n);

%enddef

// Generate Tcl list to tcl3dVector conversion functions for standard types.
%ListToVector(short,short)
%ListToVector(int,int)
%ListToVector(unsigned short,ushort)
%ListToVector(unsigned int,uint)
%ListToVector(float,float)
%ListToVector(double,double)

// Generate list2vector functions (new, delete, getitem, setitem, convert)
// for the following OpenGL types.
// These associations must correspond with the settings in gl.h

%ListToVector(GLenum,GLenum)
%ListToVector(GLboolean,GLboolean)
%ListToVector(GLbitfield,GLbitfield)
%ListToVector(GLbyte,GLbyte)
%ListToVector(GLshort,GLshort)
%ListToVector(GLint,GLint)
%ListToVector(GLsizei,GLsizei)
%ListToVector(GLubyte,GLubyte)
%ListToVector(GLushort,GLushort)
%ListToVector(GLuint,GLuint)
%ListToVector(GLfloat,GLfloat)
%ListToVector(GLclampf,GLclampf)
%ListToVector(GLdouble,GLdouble)
%ListToVector(GLclampd,GLclampd)
