/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.edit;

import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;

public class EditFieldsTableModel
extends AbstractTableModel {
    private String[] _fieldNames = null;
    private String[] _originalValues = null;
    private String[] _fieldValues = null;
    private boolean[] _valueChanged = null;

    public EditFieldsTableModel(int n) {
        this._fieldNames = new String[n];
        this._originalValues = new String[n];
        this._fieldValues = new String[n];
        this._valueChanged = new boolean[n];
    }

    public void addFieldInfo(String string, String string2, int n) {
        this._fieldNames[n] = string;
        this._originalValues[n] = string2;
        this._fieldValues[n] = string2;
        this._valueChanged[n] = false;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this._fieldNames.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this._fieldNames[n];
        }
        return this._fieldValues[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n <= 1) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nManager.getText("dialog.pointedit.table.field");
        }
        return I18nManager.getText("dialog.pointedit.table.value");
    }

    public void updateValue(int n, String string) {
        String string2 = this._originalValues[n];
        String string3 = this._fieldValues[n];
        this._valueChanged[n] = EditFieldsTableModel.areStringsDifferent(string2, string);
        if (EditFieldsTableModel.areStringsDifferent(string3, string)) {
            this._fieldValues[n] = string;
            this.fireTableRowsUpdated(n, n);
        }
    }

    private static boolean areStringsDifferent(String string, String string2) {
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            return false;
        }
        return string == null || string2 == null || !string.equals(string2);
    }

    public String getValue(int n) {
        return this._fieldValues[n];
    }

    public boolean getChanged(int n) {
        return this._valueChanged[n];
    }
}

