/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.deployment.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.BuildResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.deployment.internal.ContinuousExecutionGate;
import org.gradle.deployment.internal.DefaultContinuousExecutionGate;
import org.gradle.deployment.internal.Deployment;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.deployment.internal.DeploymentInternal;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.deployment.internal.DeploymentRegistryInternal;
import org.gradle.deployment.internal.PendingChangesListener;
import org.gradle.deployment.internal.PendingChangesManager;
import org.gradle.deployment.internal.RegisteredDeployment;
import org.gradle.internal.Cast;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class DefaultDeploymentRegistry
implements DeploymentRegistryInternal,
PendingChangesListener,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DefaultDeploymentRegistry.class);
    private final Lock lock = new ReentrantLock();
    private final Map<String, RegisteredDeployment> deployments = new HashMap<String, RegisteredDeployment>();
    private final PendingChangesManager pendingChangesManager;
    private final PendingChanges pendingChanges;
    private final BuildOperationRunner buildOperationRunner;
    private final ObjectFactory objectFactory;
    private final ContinuousExecutionGate continuousExecutionGate = new DefaultContinuousExecutionGate();
    private boolean stopped;
    private boolean anyStarted;

    public DefaultDeploymentRegistry(PendingChangesManager pendingChangesManager, BuildOperationRunner buildOperationRunner, ObjectFactory objectFactory) {
        this.pendingChangesManager = pendingChangesManager;
        this.buildOperationRunner = buildOperationRunner;
        this.objectFactory = objectFactory;
        this.pendingChanges = new PendingChanges();
        pendingChangesManager.addListener(this);
    }

    @Override
    public ContinuousExecutionGate getExecutionGate() {
        return this.continuousExecutionGate;
    }

    @Override
    public <T extends DeploymentHandle> T start(final String name, final DeploymentRegistry.ChangeBehavior changeBehavior, final Class<T> handleType, final Object ... params) {
        this.anyStarted = true;
        this.lock.lock();
        try {
            this.failIfStopped();
            if (!this.deployments.containsKey(name)) {
                DeploymentHandle deploymentHandle = (DeploymentHandle)this.buildOperationRunner.call(new CallableBuildOperation<T>(){

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)("Start deployment '" + name + "'"));
                    }

                    public T call(BuildOperationContext context) {
                        DeploymentHandle handle = (DeploymentHandle)DefaultDeploymentRegistry.this.objectFactory.newInstance(handleType, params);
                        RegisteredDeployment deployment = RegisteredDeployment.create(name, changeBehavior, DefaultDeploymentRegistry.this.continuousExecutionGate, handle);
                        handle.start(deployment.getDeployment());
                        if (DefaultDeploymentRegistry.this.pendingChanges.hasRemainingChanges()) {
                            deployment.outOfDate();
                        }
                        DefaultDeploymentRegistry.this.deployments.put(name, deployment);
                        return handle;
                    }
                });
                return (T)deploymentHandle;
            }
            throw new IllegalStateException("A deployment with id '" + name + "' is already registered.");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DeploymentHandle> T get(String name, Class<T> handleType) {
        this.lock.lock();
        try {
            this.failIfStopped();
            if (this.deployments.containsKey(name)) {
                DeploymentHandle deploymentHandle = (DeploymentHandle)Cast.cast(handleType, (Object)this.deployments.get(name).getHandle());
                return (T)deploymentHandle;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Deployment> getRunningDeployments() {
        this.lock.lock();
        try {
            ArrayList<DeploymentInternal> runningDeployments = new ArrayList<DeploymentInternal>();
            for (RegisteredDeployment deployment : this.deployments.values()) {
                if (!deployment.getHandle().isRunning()) continue;
                runningDeployments.add(deployment.getDeployment());
            }
            ArrayList<DeploymentInternal> arrayList = runningDeployments;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isAnyStarted() {
        return this.anyStarted;
    }

    @Override
    public void onPendingChanges() {
        this.lock.lock();
        try {
            this.pendingChanges.changesMade();
            for (RegisteredDeployment deployment : this.deployments.values()) {
                deployment.outOfDate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildResult buildResult) {
        this.lock.lock();
        try {
            this.pendingChanges.changesIncorporated();
            if (!this.pendingChanges.hasRemainingChanges()) {
                Throwable failure = buildResult.getFailure();
                for (RegisteredDeployment deployment : this.deployments.values()) {
                    deployment.upToDate(failure);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            LOGGER.debug("Stopping {} deployment handles", (Object)this.deployments.size());
            CompositeStoppable.stoppable(this.deployments.values()).stop();
        }
        finally {
            LOGGER.debug("Stopped deployment handles");
            this.stopped = true;
            this.deployments.clear();
            this.lock.unlock();
        }
        this.pendingChangesManager.removeListener(this);
    }

    private void failIfStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot modify deployment handles once the registry has been stopped.");
        }
    }

    private static class PendingChanges {
        private int pendingChanges = 1;

        private PendingChanges() {
        }

        void changesMade() {
            ++this.pendingChanges;
        }

        void changesIncorporated() {
            this.pendingChanges = Math.max(0, this.pendingChanges - 1);
        }

        boolean hasRemainingChanges() {
            return this.pendingChanges != 0;
        }
    }
}

