/* mcnBreakpoints.c was originally generated by the autoSql program, which also 
 * generated mcnBreakpoints.h and mcnBreakpoints.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "mcnBreakpoints.h"


void mcnBreakpointsStaticLoad(char **row, struct mcnBreakpoints *ret)
/* Load a row from mcnBreakpoints table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
ret->caseId = row[5];
ret->bpId = row[6];
ret->trId = row[7];
ret->trTxt = row[8];
ret->tgId = row[9];
ret->tgTxt = row[10];
}

struct mcnBreakpoints *mcnBreakpointsLoad(char **row)
/* Load a mcnBreakpoints from row fetched with select * from mcnBreakpoints
 * from database.  Dispose of this with mcnBreakpointsFree(). */
{
struct mcnBreakpoints *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
ret->caseId = cloneString(row[5]);
ret->bpId = cloneString(row[6]);
ret->trId = cloneString(row[7]);
ret->trTxt = cloneString(row[8]);
ret->tgId = cloneString(row[9]);
ret->tgTxt = cloneString(row[10]);
return ret;
}

struct mcnBreakpoints *mcnBreakpointsLoadAll(char *fileName) 
/* Load all mcnBreakpoints from a tab-separated file.
 * Dispose of this with mcnBreakpointsFreeList(). */
{
struct mcnBreakpoints *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = mcnBreakpointsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct mcnBreakpoints *mcnBreakpointsCommaIn(char **pS, struct mcnBreakpoints *ret)
/* Create a mcnBreakpoints out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mcnBreakpoints */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
ret->caseId = sqlStringComma(&s);
ret->bpId = sqlStringComma(&s);
ret->trId = sqlStringComma(&s);
ret->trTxt = sqlStringComma(&s);
ret->tgId = sqlStringComma(&s);
ret->tgTxt = sqlStringComma(&s);
*pS = s;
return ret;
}

void mcnBreakpointsFree(struct mcnBreakpoints **pEl)
/* Free a single dynamically allocated mcnBreakpoints such as created
 * with mcnBreakpointsLoad(). */
{
struct mcnBreakpoints *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->caseId);
freeMem(el->bpId);
freeMem(el->trId);
freeMem(el->trTxt);
freeMem(el->tgId);
freeMem(el->tgTxt);
freez(pEl);
}

void mcnBreakpointsFreeList(struct mcnBreakpoints **pList)
/* Free a list of dynamically allocated mcnBreakpoints's */
{
struct mcnBreakpoints *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    mcnBreakpointsFree(&el);
    }
*pList = NULL;
}

void mcnBreakpointsOutput(struct mcnBreakpoints *el, FILE *f, char sep, char lastSep) 
/* Print out mcnBreakpoints.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->caseId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bpId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->trId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->trTxt);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tgId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tgTxt);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

