/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import net.xmind.core.AccountManager;
import net.xmind.core.IAccount;
import net.xmind.signin.IAccountInfo;
import net.xmind.signin.IAuthenticationListener;
import net.xmind.signin.ILicenseInfo;
import net.xmind.signin.ILicenseKeyHeader;
import net.xmind.signin.IXMindNetCommand;
import net.xmind.signin.IXMindNetCommandHandler;
import net.xmind.signin.XMindNet;
import net.xmind.signin.internal.InternalXMindNet;
import net.xmind.signin.internal.LicenseInfo;
import net.xmind.ui.internal.auth.AuthenticationDialog;
import net.xmind.verify.IValidity;
import net.xmind.verify.IVerifyListener;
import net.xmind.verify.internal.Base32;
import net.xmind.verify.internal.LicenseAgent;
import net.xmind.verify.internal.LicenseKeyHeader;
import net.xmind.verify.internal.LicenseKeyHeader2;
import net.xmind.verify.internal.Messages;
import net.xmind.verify.internal.Validity;
import net.xmind.verify.internal.VerifyPlugin;
import net.xmind.verify.internal.legacy.LegacyLicenseVerifierUtil;
import net.xmind.verify.internal.legacy.LegacyValidity;
import net.xmind.verify.ui.internal.LicenseInfoDialog2;
import net.xmind.verify.ui.internal.LicenseKeyInputDialog2;
import net.xmind.verify.ui.internal.SubscriptionInfoDialog;
import net.xmind.verify.ui.internal.VerifyingStatusDialog;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Bundle;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.internal.XMindNetRequest;
import org.xmind.core.net.util.LinkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseVerifier
implements IAuthenticationListener,
IXMindNetCommandHandler {
    static final String PROP_LICENSE_EMAIL = "license_email";
    static final String PROP_LICENSE_KEY = "license_key";
    private static final boolean DEBUGGING = VerifyPlugin.getDefault().isDebugging("/debug/verify");
    private static final boolean VERBOSE = VerifyPlugin.getDefault().isDebugging("/debug/verify/verbose");
    private static final String DEBUG_KEYS = "/debug/keys";
    private static final int LICENSE_KEY_LENGTH = 225;
    private static final int HEADER_LENGTH = 12;
    private static final int PREFIX_LENGTH = 8;
    private static LicenseVerifier INSTANCE = null;
    private static List<String> BLACKLISTED_LICENSE_KEYS = null;
    private IValidity validity = null;
    private VerificationJob verifyJob = null;
    private Object jobLock = new Object();
    private static boolean subscriptionVerified = false;
    private List<ValidityNotifier> listeners = new ArrayList<ValidityNotifier>();
    private List<ValidityNotifier> callbacks = new ArrayList<ValidityNotifier>();
    private static final String KEY_LICENSE_TYPE = "type";
    private static final String KEY_LICENSE_SESSION_ID = "sessionId";
    private static final String KEY_LICENSE_ACTIVATE_TIME_WITH_SESSION_ID = "LicenseActivations/%s/ActivateTime";
    private static final String KEY_LICENSE_DEACTIVATE_TIME_WITH_SESSION_ID = "LicenseActivations/%s/DeactivateTime";
    private static final String KEY_LICENSE_TYPE_WITH_SESSION_ID = "LicenseActivations/%s/LicenseType";
    private JSONObject licenseStates = null;

    private LicenseVerifier() {
        XMindNet.addAuthenticationListener((IAuthenticationListener)this);
        XMindNet.addXMindNetCommandHandler((String)"refresh", (IXMindNetCommandHandler)this);
    }

    public void verify(String featureKey, String actionName, int requiredStatus, IVerifyListener callback, int style) {
        this.verify(featureKey, actionName, requiredStatus, callback, style, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verify(String featureKey, String actionName, int requiredStatus, IVerifyListener callback, int style, Properties userInput) {
        Object object;
        if ((style & 1) == 0 && LicenseVerifier.checkValid(this.validity, requiredStatus)) {
            if (callback != null) {
                callback.notifyValidity(this.validity);
            }
            return;
        }
        if (callback != null) {
            object = this.callbacks;
            synchronized (object) {
                this.callbacks.add(new ValidityNotifier(callback));
            }
        }
        object = this.jobLock;
        synchronized (object) {
            if (this.verifyJob == null) {
                VerificationJob job = new VerificationJob(featureKey, actionName, requiredStatus, style, userInput);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(IJobChangeEvent event) {
                        Object object = LicenseVerifier.this.jobLock;
                        synchronized (object) {
                            LicenseVerifier.this.verifyJob = null;
                        }
                        if (event.getResult() instanceof IValidity) {
                            LicenseVerifier.this.setValidity((IValidity)event.getResult());
                        } else {
                            LicenseVerifier.this.setValidity(LicenseVerifier.createValidity(8));
                        }
                    }
                });
                job.schedule();
                this.verifyJob = job;
            } else {
                this.verifyJob.updateFeatureKey(featureKey);
                this.verifyJob.updateActionName(actionName);
                this.verifyJob.updateRequiredStatus(requiredStatus);
                this.verifyJob.updateStyle(style);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVerifyListener(IVerifyListener listener) {
        List<ValidityNotifier> list = this.listeners;
        synchronized (list) {
            this.listeners.add(new ValidityNotifier(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVerifyListener(IVerifyListener listener) {
        List<ValidityNotifier> list = this.listeners;
        synchronized (list) {
            Object[] array = this.listeners.toArray();
            this.listeners.clear();
            int i = 0;
            while (i < array.length) {
                ValidityNotifier notifier = (ValidityNotifier)array[i];
                if (notifier.listener != listener) {
                    this.listeners.add(notifier);
                }
                ++i;
            }
        }
    }

    private void setValidity(IValidity newValidity) {
        newValidity = LicenseVerifier.cloneValidity(newValidity);
        IValidity publicValidity = LicenseVerifier.cloneValidity(newValidity);
        this.recordLicenseVerification(publicValidity);
        if (this.notifyAllCallbacks(publicValidity)) {
            return;
        }
        this.notifyAllListeners(publicValidity);
        this.notifyLicenseAgent(publicValidity);
        this.validity = newValidity;
        if ((newValidity.getCode() & 6) != 0) {
            this.checkLicenseKeyBlacklisted();
        }
    }

    private void checkLicenseKeyBlacklisted() {
        Properties store = LicenseVerifier.loadLocalData();
        final String licenseKey = LicenseVerifier.trimLicenseKey(store.getProperty("WalkingInTheMorning"));
        final String licenseEmail = store.getProperty("TimeSmilesInMyHand");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (!LicenseVerifier.doCheckLicenseKeyBlacklisted(licenseEmail, licenseKey)) {
                    LicenseVerifier.addBlacklistedLicenseKey(licenseKey, licenseEmail);
                    LicenseVerifier.this.verify(null, null, 7, null, 3);
                }
            }
        });
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyAllCallbacks(IValidity validity) {
        ArrayList<ValidityNotifier> allCallbacks;
        List<ValidityNotifier> list = this.callbacks;
        synchronized (list) {
            allCallbacks = new ArrayList<ValidityNotifier>(this.callbacks);
            this.callbacks.clear();
        }
        for (ValidityNotifier callback : allCallbacks) {
            if (!callback.notifyValidityCallback(validity)) continue;
            return true;
        }
        return false;
    }

    private void notifyAllListeners(IValidity validity) {
        Object[] allListeners;
        Object[] objectArray = allListeners = this.listeners.toArray();
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ValidityNotifier)listener).notifyValidityListener(validity);
            ++n2;
        }
    }

    private void notifyLicenseAgent(IValidity validity) {
        int code = validity.getCode();
        Throwable error = validity.getException();
        String name = validity.getLicensedTo();
        ILicenseKeyHeader header = validity.getLicenseKeyHeader();
        InternalXMindNet.getInstance().getLicenseAgent().licenseVerified((ILicenseInfo)new LicenseInfo(code, error, name, header));
        LicenseAgent licenseAgent = VerifyPlugin.getDefault().getLicenseAgent();
        if (licenseAgent != null) {
            int licenseType = 1;
            if ((code & 1) != 0) {
                licenseType = 2;
            } else if ((code & 2) != 0) {
                licenseType = 4;
            } else if ((code & 4) != 0) {
                licenseType = 8;
            }
            LicenseKeyHeader2 header2 = null;
            if (header != null) {
                header2 = LicenseKeyHeader2.decode(header.toEncoded());
            }
            licenseAgent.setLicenseInfo(licenseType, name, header2);
        }
    }

    public void postSignIn(IAccountInfo accountInfo) {
        subscriptionVerified = false;
        this.verify(null, null, 7, null, 3);
    }

    public void postSignOut(IAccountInfo oldAccountInfo) {
        if (this.validity != null && (this.validity.getCode() & 1) != 0) {
            if (!LicenseVerifier.hasValidity(this.validity, 6)) {
                LicenseVerifier.saveLocalData(null, null, null, null, null);
            } else {
                this.saveLocalData(null);
            }
            this.setValidity(LicenseVerifier.createValidity(1024));
        }
        subscriptionVerified = false;
    }

    public boolean handleXMindNetCommand(IXMindNetCommand command) {
        this.refreshValidity(command.getContent());
        return true;
    }

    private void refreshValidity(IDataStore data) {
        if (data == null) {
            return;
        }
        if (this.validity != null && (this.validity.getCode() & 6) != 0) {
            return;
        }
        String user = data.getString("user");
        String uid = data.getString("uid");
        if (user == null || uid == null) {
            return;
        }
        IAccountInfo accountInfo = XMindNet.getAccountInfo();
        if (accountInfo == null || !user.equals(accountInfo.getUser())) {
            return;
        }
        String expiration = LicenseVerifier.extractExpiration(data, uid);
        String expireDate = LicenseVerifier.extractExpireDate(data, uid);
        int status = expiration == null ? 4096 : LicenseVerifier.parseExpiration(expiration, uid);
        LicenseVerifier.saveLocalData(uid, expiration, null, null, expireDate);
        this.validity = LicenseVerifier.createValidity(status, user, null);
    }

    private static boolean isLicenseKeyBlacklisted(String licenseKey, String licenseEmail) {
        String line = String.valueOf(licenseEmail) + "|" + licenseKey;
        return LicenseVerifier.getBlacklistedLicenseKeys().contains(line);
    }

    private static synchronized List<String> getBlacklistedLicenseKeys() {
        if (BLACKLISTED_LICENSE_KEYS == null) {
            BLACKLISTED_LICENSE_KEYS = new ArrayList<String>();
            File blistFile = LicenseVerifier.getBlacklistFile();
            if (blistFile != null && blistFile.exists() && blistFile.isFile()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(blistFile));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            BLACKLISTED_LICENSE_KEYS.add(line);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return BLACKLISTED_LICENSE_KEYS;
    }

    private static synchronized void addBlacklistedLicenseKey(String licenseKey, String licenseEmail) {
        List<String> lines = LicenseVerifier.getBlacklistedLicenseKeys();
        lines.add(String.valueOf(licenseEmail) + "|" + licenseKey);
        File blistFile = LicenseVerifier.getBlacklistFile();
        if (blistFile != null) {
            LicenseVerifier.deleteFile(blistFile);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(blistFile));
                try {
                    for (String line : lines) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean doCheckLicenseKeyBlacklisted(String email, String key) {
        XMindNetRequest request = new XMindNetRequest().useHTTPS();
        request.path("/_res/verify-license", new Object[0]).addParameter("email", (Object)email).addParameter("key", (Object)key);
        String uuid = LicenseVerifier.getInstallUUID();
        if (uuid != null) {
            request.addParameter("uuid", (Object)uuid);
        }
        request.post();
        if (request.isAborted()) {
            return true;
        }
        int code = request.getStatusCode();
        IDataStore data = request.getData();
        if (code == 200 && data != null) {
            String licenseStatus = data.getString("status");
            return licenseStatus == null || "".equals(licenseStatus) || "valid".equals(licenseStatus);
        }
        return true;
    }

    private static synchronized String getInstallUUID() {
        File uuidFile = LicenseVerifier.getUUIDFile();
        if (uuidFile != null) {
            String uuid = null;
            if (uuidFile.exists() && uuidFile.isFile()) {
                try {
                    byte[] buffer = new byte[1024];
                    FileInputStream stream = new FileInputStream(uuidFile);
                    try {
                        int read = stream.read(buffer);
                        uuid = new String(buffer, 0, read, "UTF-8");
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                LicenseVerifier.deleteFile(uuidFile);
                try {
                    FileOutputStream stream = new FileOutputStream(uuidFile);
                    try {
                        stream.write(uuid.getBytes("UTF-8"));
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return uuid;
        }
        return null;
    }

    private static void deleteFile(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                LicenseVerifier.deleteFile(new File(file, name));
                ++n2;
            }
        }
        file.delete();
    }

    private static boolean checkValid(IStatus status, int requiredStatus) {
        return status != null && LicenseVerifier.hasValidity(status, requiredStatus);
    }

    private static boolean hasValidity(IStatus status, int code) {
        return (status.getCode() & code) != 0;
    }

    private static Properties loadLocalData() {
        File stateFile = LicenseVerifier.getStateFile();
        if (stateFile != null && stateFile.exists() && stateFile.isFile()) {
            Properties store = new Properties();
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(stateFile), 1024);
                try {
                    store.load(stream);
                }
                finally {
                    ((InputStream)stream).close();
                }
                String licenseEmail = store.getProperty("TimeSmilesInMyHand");
                String licenseKey = store.getProperty("WalkingInTheMorning");
                LicenseVerifier.saveState(store, "WalkingInTheMorning", Cryptus.decrypt(licenseKey, licenseEmail));
                return store;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void saveLocalData(String uid, String expiration, String licenseKey, String licenseEmail, String expireDate) {
        File stateFile = LicenseVerifier.getStateFile();
        if (stateFile == null) {
            return;
        }
        licenseKey = Cryptus.encrypt(licenseKey, licenseEmail);
        Properties store = new Properties();
        LicenseVerifier.saveState(store, "TimeSmilesInMyHand", licenseEmail);
        LicenseVerifier.saveState(store, "WalkingInTheMorning", licenseKey);
        LicenseVerifier.saveState(store, "ThisDawn", uid);
        LicenseVerifier.saveState(store, "LastsAllDay", expiration);
        LicenseVerifier.saveState(store, "LastAllDay", expireDate);
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            try {
                store.store(stream, "Awakening Gatha, Deena Metzger");
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static void saveLocalData(String uid, String expiration, String licenseKey, String licenseEmail) {
        LicenseVerifier.saveLocalData(uid, expiration, licenseKey, licenseEmail, null);
    }

    private void saveLocalData(String expiration) {
        Properties store = LicenseVerifier.loadLocalData();
        String licenseKey = null;
        String licenseEmail = null;
        String uid = null;
        if (store != null) {
            licenseKey = store.getProperty("WalkingInTheMorning");
            licenseEmail = store.getProperty("TimeSmilesInMyHand");
            uid = store.getProperty("ThisDawn");
        }
        LicenseVerifier.saveLocalData(uid, null, licenseKey, licenseEmail, null);
    }

    private static void saveState(Properties store, String name, String value) {
        if (value != null && !"".equals(value)) {
            store.setProperty(name, value);
        } else {
            store.remove(name);
        }
    }

    private static String extractExpireDate(IDataStore data, String uid) {
        if (!data.has("expireDate")) {
            return null;
        }
        long exp = data.getLong("expireDate");
        if (exp <= 0L) {
            exp = 0L;
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append('`');
        sb.append('\t');
        sb.append('\n');
        sb.append(Long.toString(exp, 16));
        String ex = Cryptus.encrypt(sb.toString(), uid);
        return ex;
    }

    private static String extractExpiration(IDataStore data, String uid) {
        if (!data.has("expireDate")) {
            return null;
        }
        long exp = data.getLong("expireDate");
        if (exp <= 0L) {
            return null;
        }
        if (data.getBoolean("expired")) {
            exp = 0L;
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append('`');
        sb.append('\t');
        sb.append('\n');
        sb.append(Long.toString(exp, 16));
        String ex = Cryptus.encrypt(sb.toString(), uid);
        return ex;
    }

    private static long parseExpireDate(String subscriptionExpireDate, String uid) {
        String value = Cryptus.decrypt(subscriptionExpireDate, uid);
        if (value != null && !"".equals(value) && value.startsWith("`\t\n")) {
            return Long.parseLong(value.substring(3), 16);
        }
        return 0L;
    }

    private static int parseExpiration(String expiration, String uid) {
        String value = Cryptus.decrypt(expiration, uid);
        if (value != null && !"".equals(value) && value.startsWith("`\t\n")) {
            long expTime = Long.parseLong(value.substring(3), 16);
            if (System.currentTimeMillis() < expTime) {
                return 1;
            }
            return 2048;
        }
        return 1024;
    }

    private static File getStateFile() {
        return LicenseVerifier.getLocalFile(".poem37");
    }

    private static File getUUIDFile() {
        return LicenseVerifier.getLocalFile(".uuid");
    }

    private static File getBlacklistFile() {
        return LicenseVerifier.getLocalFile(".blist");
    }

    private static File getLocalFile(String name) {
        Bundle bundle = Platform.getBundle((String)"net.xmind.verify");
        if (bundle != null) {
            File root = Platform.getStateLocation((Bundle)bundle).toFile();
            return new File(root, name);
        }
        return null;
    }

    private static IValidity cloneValidity(IValidity validity) {
        return new Validity(validity.getSeverity(), validity.getPlugin(), validity.getCode(), validity.getMessage(), validity.getException(), validity.getLicensedTo(), validity.getLicenseKeyHeader());
    }

    private static IValidity createValidity(int invalidStatus) {
        return LicenseVerifier.createValidity(invalidStatus, null, null, null, false);
    }

    private static IValidity createValidity(int validStatus, String name, ILicenseKeyHeader header) {
        return LicenseVerifier.createValidity(validStatus, name, header, null, false);
    }

    private static IValidity createValidity(int invalidStatus, Throwable error) {
        return LicenseVerifier.createValidity(invalidStatus, null, null, error, false);
    }

    private static IValidity createValidity(int status, String name, ILicenseKeyHeader header, Throwable error, boolean canceled) {
        if ((status & 7) == 0) {
            name = null;
        }
        if (canceled) {
            return new Validity(8, "net.xmind.verify", status, null, error, name, header);
        }
        return new Validity(0, "net.xmind.verify", status, null, error, name, header);
    }

    private static String trimLicenseKey(String key) {
        if (key == null) {
            return "";
        }
        int startIndex = (key = key.toUpperCase()).indexOf("---BEGIN LICENSE KEY---");
        startIndex = startIndex < 0 ? 0 : (startIndex += 23);
        int endIndex = key.indexOf("---END LICENSE KEY---");
        if (endIndex < 0) {
            endIndex = key.length();
        }
        key = key.substring(startIndex, endIndex).replaceAll("[^A-Z0-9]", "");
        return key;
    }

    public static LicenseVerifier getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LicenseVerifier();
        }
        return INSTANCE;
    }

    private void recordLicenseVerification(IValidity info) {
        String newType;
        if (this.licenseStates == null) {
            this.licenseStates = LicenseVerifier.readStates(LicenseVerifier.getLicenseStatesFile());
        }
        JSONObject oldStates = this.licenseStates;
        JSONObject newStates = LicenseVerifier.createLicenseStates(info);
        String oldType = oldStates == null ? null : oldStates.optString(KEY_LICENSE_TYPE, null);
        String string = newType = newStates == null ? null : newStates.optString(KEY_LICENSE_TYPE, null);
        if (!(newType == oldType || newType != null && newType.equals(oldType))) {
            String oldSessionId;
            String string2 = oldSessionId = oldStates == null ? null : oldStates.optString(KEY_LICENSE_SESSION_ID, null);
            if (oldSessionId != null) {
                VerifyPlugin.getDefault().getUsageDataCollector().put(String.format(KEY_LICENSE_DEACTIVATE_TIME_WITH_SESSION_ID, oldSessionId), System.currentTimeMillis());
            }
            if (newType != null) {
                String sessionId = UUID.randomUUID().toString();
                newStates.put(KEY_LICENSE_SESSION_ID, (Object)sessionId);
                VerifyPlugin.getDefault().getUsageDataCollector().put(String.format(KEY_LICENSE_ACTIVATE_TIME_WITH_SESSION_ID, sessionId), System.currentTimeMillis());
                VerifyPlugin.getDefault().getUsageDataCollector().put(String.format(KEY_LICENSE_TYPE_WITH_SESSION_ID, sessionId), newType);
            }
            this.licenseStates = newStates;
            LicenseVerifier.writeStates(this.licenseStates, LicenseVerifier.getLicenseStatesFile());
        }
    }

    private static JSONObject createLicenseStates(IValidity info) {
        int type = info.getCode();
        String typeId = (type & 2) != 0 ? "pro_license" : ((type & 1) != 0 ? "pro" : ((type & 4) != 0 ? "plus_license" : null));
        if (typeId == null) {
            return null;
        }
        return new JSONObject().put(KEY_LICENSE_TYPE, (Object)typeId);
    }

    private static File getLicenseStatesFile() {
        IPath stateLocation;
        Bundle storageBundle = Platform.getBundle((String)"org.xmind.cathy");
        if (storageBundle == null) {
            return null;
        }
        try {
            stateLocation = Platform.getStateLocation((Bundle)storageBundle);
        }
        catch (Exception exception) {
            return null;
        }
        return stateLocation.append("licenseStates.json").toFile();
    }

    private static JSONObject readStates(File statesFile) {
        JSONObject jSONObject;
        if (statesFile == null || !statesFile.exists()) {
            return null;
        }
        FileInputStream stream = new FileInputStream(statesFile);
        try {
            jSONObject = new JSONObject(new JSONTokener((InputStream)stream));
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        ((InputStream)stream).close();
        return jSONObject;
    }

    private static void writeStates(JSONObject object, File statesFile) {
        if (statesFile == null) {
            return;
        }
        if (object == null) {
            statesFile.delete();
            return;
        }
        File dir = statesFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(statesFile);
            try {
                object.write((Writer)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException iOException) {}
    }

    private static class Cryptus {
        private Cryptus() {
        }

        protected static String encrypt(String src, String key) {
            if (src == null || "".equals(src) || key == null || "".equals(key)) {
                return src;
            }
            try {
                byte[] keyBytes = key.getBytes();
                byte[] srcBytes = src.getBytes();
                byte[] destBytes = Cryptus.encdec(keyBytes, srcBytes, 1);
                return new String(Hex.encodeHex((byte[])destBytes));
            }
            catch (Exception e) {
                if (DEBUGGING || VERBOSE) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        protected static String decrypt(String dest, String key) {
            if (dest == null || "".equals(dest) || key == null || "".equals(key)) {
                return dest;
            }
            try {
                byte[] keyBytes = key.getBytes();
                byte[] destBytes = Hex.decodeHex((char[])dest.toCharArray());
                byte[] srcBytes = Cryptus.encdec(keyBytes, destBytes, 2);
                return new String(srcBytes);
            }
            catch (Exception e) {
                if (DEBUGGING || VERBOSE) {
                    e.printStackTrace();
                }
                return null;
            }
        }

        private static byte[] encdec(byte[] key, byte[] data, int cipherMode) throws GeneralSecurityException {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            byte[] keyDigest = hash.digest(key);
            DESKeySpec keySpec = new DESKeySpec(keyDigest, keyDigest.length - 8);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            IvParameterSpec ivParam = new IvParameterSpec(keyDigest, 0, 8);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(cipherMode, (Key)secretKey, ivParam);
            return cipher.doFinal(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FreeStartDate {
        Brooks(3, 6, 1443628800000L),
        Cage(3, 7, 1475251200000L);

        private int majorVersion;
        private int minorVersion;
        private long startDate;

        private FreeStartDate(int majorVesion, int minorVersion, long startDate) {
            this.majorVersion = majorVesion;
            this.minorVersion = minorVersion;
            this.startDate = startDate;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public static FreeStartDate findByVersion(int majorVersion, int minorVersion) {
            FreeStartDate[] freeStartDateArray = FreeStartDate.values();
            int n = freeStartDateArray.length;
            int n2 = 0;
            while (n2 < n) {
                FreeStartDate freeStartDate = freeStartDateArray[n2];
                if (freeStartDate.majorVersion == majorVersion && freeStartDate.minorVersion == minorVersion) {
                    return freeStartDate;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class ValidityNotifier {
        private IVerifyListener listener;
        private Display display;

        public ValidityNotifier(IVerifyListener listener) {
            this.listener = listener;
            this.display = Display.getCurrent();
        }

        public void notifyValidityListener(final IValidity validity) {
            if (this.display != null) {
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                                public void run() throws Exception {
                                    ValidityNotifier.this.listener.notifyValidity(validity);
                                }
                            });
                        }
                    });
                }
            } else {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ValidityNotifier.this.listener.notifyValidity(validity);
                    }
                });
            }
        }

        public boolean notifyValidityCallback(IValidity validity) {
            this.notifyValidityListener(validity);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VerificationJob
    extends Job {
        private static final String CLEARED = "cleared";
        private List<String> featureKeys = new ArrayList<String>(2);
        private List<String> actionNames = new ArrayList<String>(2);
        private int requiredStatus;
        private int style;
        private IStatus validity;
        private String licenseKey = null;
        private String licenseEmail = null;
        private String user = null;
        private String authToken = null;
        private String subscriptionExpireDate = null;
        private String uid = null;
        private String expiration = null;
        private XMindNetRequest retrieveUIDRequest = new XMindNetRequest();
        private XMindNetRequest retrieveSubscriptionRequest = new XMindNetRequest();
        private Window currentDialog = null;
        private Properties userInput;

        public VerificationJob(String featureKey, String actionName, int requiredStatus, int style, Properties userInput) {
            super("Verify License");
            if (featureKey != null) {
                this.featureKeys.add(featureKey);
            }
            if (actionName != null) {
                this.actionNames.add(actionName);
            }
            this.requiredStatus = requiredStatus;
            this.style = style;
            if (userInput == null) {
                this.userInput = null;
            } else {
                this.userInput = new Properties();
                this.userInput.putAll((Map<?, ?>)userInput);
            }
            this.validity = LicenseVerifier.createValidity(1024);
            this.setSystem(true);
        }

        public void updateFeatureKey(String featureKey) {
            if (featureKey != null) {
                this.featureKeys.add(featureKey);
            }
        }

        public void updateActionName(String actionName) {
            if (actionName != null) {
                this.actionNames.add(actionName);
            }
        }

        public void updateRequiredStatus(int newStatus) {
            this.requiredStatus &= newStatus;
        }

        public void updateStyle(int newStyle) {
            this.style = VerificationJob.mergeStyle(this.style, newStyle, 1, true);
            this.style = VerificationJob.mergeStyle(this.style, newStyle, 2, true);
            this.style = VerificationJob.mergeStyle(this.style, newStyle, 4, false);
            this.style = VerificationJob.mergeStyle(this.style, newStyle, 8, false);
        }

        private static int mergeStyle(int style, int newStyle, int bit, boolean and) {
            if (and) {
                return style & (newStyle & bit | ~bit);
            }
            return style | newStyle & bit;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.verify(monitor);
            if (monitor.isCanceled() && !LicenseVerifier.checkValid(this.validity, 7)) {
                this.validity = LicenseVerifier.createValidity(1024, null, null, null, true);
            }
            LicenseVerifier.saveLocalData(this.uid, this.expiration, this.licenseKey, this.licenseEmail, this.subscriptionExpireDate);
            return this.validity;
        }

        private boolean isValid() {
            return LicenseVerifier.checkValid(this.validity, this.requiredStatus);
        }

        private void verify(IProgressMonitor monitor) {
            this.verifyVindy(monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if (this.isValid()) {
                return;
            }
            this.loadDataFromLocalStorage(monitor);
            if (monitor.isCanceled()) {
                return;
            }
            this.verifyLoadedData(monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if (this.userInput == null && (this.style & 8) == 0 && (this.isValid() || (this.style & 2) != 0)) {
                return;
            }
            this.waitForWorkbenchReady(monitor);
            if (monitor.isCanceled()) {
                return;
            }
            this.showDialog(monitor);
        }

        private void loadDataFromLocalStorage(IProgressMonitor monitor) {
            Properties store = LicenseVerifier.loadLocalData();
            if (store != null) {
                this.licenseKey = store.getProperty("WalkingInTheMorning");
                this.licenseEmail = store.getProperty("TimeSmilesInMyHand");
                IAccountInfo account = XMindNet.getAccountInfo();
                this.user = account == null ? null : account.getUser();
                this.authToken = account == null ? null : account.getAuthToken();
                this.uid = store.getProperty("ThisDawn");
                this.expiration = store.getProperty("LastsAllDay");
                this.subscriptionExpireDate = store.getProperty("LastAllDay");
            } else {
                IPreferenceStore pref = VerifyPlugin.getDefault().getPreferenceStore();
                this.licenseKey = pref.getString("licenseKey");
                this.licenseEmail = pref.getString("licenseEmail");
                this.uid = pref.getString("uid");
                this.expiration = pref.getString("expiration");
                LicenseVerifier.saveLocalData(this.uid, this.expiration, this.licenseKey, this.licenseEmail);
                pref.setToDefault("licenseKey");
                pref.setToDefault("licenseEmail");
                pref.setToDefault("uid");
                pref.setToDefault("expiration");
            }
            if (this.licenseKey == null || "".equals(this.licenseKey)) {
                this.licenseKey = System.getProperty("org.xmind.product.license.key", this.licenseKey);
            }
            if (this.licenseEmail == null || "".equals(this.licenseEmail)) {
                this.licenseEmail = System.getProperty("org.xmind.product.license.registeredEmail", this.licenseEmail);
            }
        }

        /*
         * Exception decompiling
         */
        private void waitForWorkbenchReady(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isWorkbenchReady() {
            return "workbenchReady".equals(System.getProperty("org.xmind.cathy.app.status"));
        }

        private void verifyLoadedData(IProgressMonitor monitor) {
            if (this.hasLicenseKey() && this.hasLicenseEmail()) {
                ILicenseKeyHeader header;
                IStatus oldValidity = this.validity;
                this.verifyLicenseKey(monitor);
                if ((this.validity.getCode() & 6) != 0 && this.validity instanceof IValidity && (header = ((IValidity)this.validity).getLicenseKeyHeader()) != null && "C".equals(header.getLicenseType())) {
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("VLE license keys are excluded from activating non-VLE products.");
                    }
                    this.validity = oldValidity;
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("Reverted to back to previous validity: " + oldValidity);
                    }
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            IStatus licenseValidity = this.validity;
            if (this.hasUser() && this.hasAuthToken()) {
                if (this.hasUID() && this.hasExpiration()) {
                    this.verifyLocalSubscriptionInfo(monitor);
                    if (this.isValid()) {
                        this.mergeVeifyInfo(licenseValidity);
                        subscriptionVerified = true;
                        return;
                    }
                }
                if (monitor.isCanceled()) {
                    return;
                }
                if (!subscriptionVerified) {
                    this.verifySubscription(monitor);
                    if (this.isValid()) {
                        this.mergeVeifyInfo(licenseValidity);
                        subscriptionVerified = true;
                        return;
                    }
                }
                this.validity = licenseValidity;
                subscriptionVerified = true;
            }
        }

        private void mergeVeifyInfo(IStatus licenseValidity) {
            if (!LicenseVerifier.hasValidity(this.validity, 1) || LicenseVerifier.hasValidity(licenseValidity, 1024)) {
                return;
            }
            if (LicenseVerifier.hasValidity(licenseValidity, 2)) {
                if (licenseValidity instanceof IValidity) {
                    ILicenseKeyHeader header = ((IValidity)licenseValidity).getLicenseKeyHeader();
                    this.validity = LicenseVerifier.createValidity(3, ((IValidity)licenseValidity).getLicensedTo(), header);
                }
                return;
            }
            if (LicenseVerifier.hasValidity(licenseValidity, 4)) {
                this.validity = LicenseVerifier.createValidity(5, this.user, null);
                return;
            }
        }

        private void verifyLocalSubscriptionInfo(IProgressMonitor monitor) {
            this.validity = LicenseVerifier.createValidity(LicenseVerifier.parseExpiration(this.expiration, this.uid), this.user, null);
        }

        private void verifyLicenseKey(IProgressMonitor monitor) {
            String trimmedLicenseEmail;
            String trimmedLicenseKey = LicenseVerifier.trimLicenseKey(this.licenseKey);
            String string = trimmedLicenseEmail = this.licenseEmail == null ? this.licenseEmail : this.licenseEmail.trim();
            if (LicenseVerifier.isLicenseKeyBlacklisted(trimmedLicenseKey, trimmedLicenseEmail)) {
                this.validity = LicenseVerifier.createValidity(8192);
            } else {
                this.doVerifyLicenseKey(monitor, trimmedLicenseEmail, trimmedLicenseKey, trimmedLicenseEmail);
                if (!this.isValid()) {
                    IStatus oldValidity = this.validity;
                    this.doVerifyLicenseKey(monitor, "sales+daobansiquanjia@xmind.net", trimmedLicenseKey, trimmedLicenseEmail);
                    if (!this.isValid()) {
                        this.validity = LegacyLicenseVerifierUtil.verifyLicenseKey(trimmedLicenseKey);
                        if (!this.isLegacyValidity()) {
                            this.validity = oldValidity;
                        }
                    }
                }
            }
        }

        private void doVerifyLicenseKey(IProgressMonitor monitor, String email, String licenseKey, String licensedTo) {
            email = email.toLowerCase();
            if (VERBOSE) {
                System.out.println("Verifying license key: " + licenseKey);
            }
            if (licenseKey.length() != 225) {
                if (DEBUGGING || VERBOSE) {
                    System.out.println("Invalid license key length: " + licenseKey.length());
                }
                this.validity = LicenseVerifier.createValidity(8192);
                return;
            }
            try {
                int targetStatus;
                Object[] commonParameters;
                int minorVersion;
                int majorVersion;
                FreeStartDate freeStartDate;
                String headerStr = licenseKey.substring(0, 12);
                LicenseKeyHeader header = LicenseKeyHeader.decode(headerStr);
                if (VERBOSE) {
                    System.out.println("License key header: " + header.toString());
                }
                if ((freeStartDate = FreeStartDate.findByVersion(majorVersion = header.getMajorVersionNumber(), minorVersion = header.getMinorVersionNumber())) != null) {
                    long startDate = freeStartDate.getStartDate();
                    long freeMonths = (long)(header.getFreeMonths() * 30 * 24 * 60 * 60) * 1000L;
                    if (freeMonths != 0L && startDate + freeMonths < System.currentTimeMillis()) {
                        this.validity = LicenseVerifier.createValidity(8192, null, header, null, false);
                        return;
                    }
                }
                String licenseType = header.getLicenseType();
                if (VERBOSE) {
                    System.out.println("License key type: " + licenseType);
                }
                if ((commonParameters = VerificationJob.getCommonVerifierParameters(licenseType)) == null) {
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("Unrecognized license key type: " + licenseType);
                    }
                    this.validity = LicenseVerifier.createValidity(8192, null, header, null, false);
                    return;
                }
                String suffix = (String)commonParameters[0];
                byte[] publicKey = (byte[])commonParameters[1];
                if (VERBOSE) {
                    System.out.println("License key base suffix: " + suffix);
                    System.out.println("License key public key: " + Arrays.toString(publicKey));
                }
                if ("B".equals(licenseType)) {
                    targetStatus = 4;
                    if (VERBOSE) {
                        System.out.println("License key is for XMind Plus (" + header.getLicenseeType() + ").");
                    }
                } else {
                    targetStatus = 2;
                    if (VERBOSE) {
                        System.out.println("License key is for XMind Pro (" + header.getLicenseeType() + ").");
                    }
                }
                String baseStr = String.valueOf(licenseKey.substring(0, 20)) + email + suffix;
                String signatureStr = licenseKey.substring(20);
                if (VERBOSE) {
                    System.out.println("Base (UTF-8): " + baseStr);
                    System.out.println("Signature (Base32): " + signatureStr);
                }
                byte[] base = baseStr.getBytes("UTF-8");
                byte[] signature = Base32.decode(signatureStr);
                if (VERBOSE) {
                    System.out.println("Base: " + Arrays.toString(base));
                    System.out.println("Signature: " + Arrays.toString(signature));
                }
                if (this.checkSignatureValid(base, signature, publicKey)) {
                    if (VERBOSE) {
                        System.out.println("Verified: VALID. Licensed to '" + licensedTo + "'.");
                    }
                    this.validity = LicenseVerifier.createValidity(targetStatus, licensedTo, header);
                } else {
                    if (DEBUGGING || VERBOSE) {
                        System.out.println("Invalid signature: " + signatureStr);
                    }
                    this.validity = LicenseVerifier.createValidity(8192);
                }
            }
            catch (Throwable e) {
                if (DEBUGGING) {
                    e.printStackTrace();
                }
                this.validity = LicenseVerifier.createValidity(0x40000000, e);
            }
        }

        private boolean checkSignatureValid(byte[] base, byte[] signature, byte[] publicKey) throws Exception {
            X509EncodedKeySpec ks = new X509EncodedKeySpec(Base64.decodeBase64((byte[])publicKey));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey pub = kf.generatePublic(ks);
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initVerify(pub);
            signer.update(base);
            return signer.verify(signature);
        }

        private void verifyVindy(IProgressMonitor monitor) {
            String distribId = System.getProperty("org.xmind.product.distribution.id");
            if (distribId == null || "".equals(distribId) || !distribId.startsWith("vindy")) {
                return;
            }
            String org = System.getProperty("org.xmind.product.distribution.vindy.org");
            if (org == null || "".equals(org)) {
                return;
            }
            String time = System.getProperty("org.xmind.product.distribution.vindy.time");
            if (time == null || "".equals(time)) {
                return;
            }
            String signatureStr = System.getProperty("org.xmind.product.distribution.vindy.name");
            if (signatureStr == null || "".equals(signatureStr)) {
                return;
            }
            String baseStr = String.valueOf(distribId) + "@" + time;
            IStatus originalStatus = this.validity;
            this.doVerifyLicenseKey(monitor, baseStr, LicenseVerifier.trimLicenseKey(signatureStr), org);
            if (!this.isValid()) {
                this.validity = originalStatus;
            }
        }

        private void verifySubscription(IProgressMonitor monitor) {
            this.retrieveUID(monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if (this.hasUID()) {
                this.retrieveSubscription(monitor);
            }
        }

        private void showDialog(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            while (!monitor.isCanceled()) {
                int targetStatus;
                if (this.userInput == null) {
                    targetStatus = LicenseVerifier.hasValidity(this.validity, 2) ? 2 : (LicenseVerifier.hasValidity(this.validity, 1) && !LicenseVerifier.hasValidity(this.validity, 2) ? 1 : (this.isValid() && !LicenseVerifier.hasValidity(this.validity, 1) && LicenseVerifier.hasValidity(this.validity, 4) ? 4 : (LicenseVerifier.hasValidity(this.validity, 4) && !LicenseVerifier.hasValidity(this.validity, 1) && (3 & this.requiredStatus) != 0 ? this.openPlusMessageDialog(monitor, workbench) : this.openLicenseDialog(monitor, workbench))));
                    if (targetStatus < 0 || monitor.isCanceled()) {
                        return;
                    }
                } else {
                    targetStatus = 7;
                }
                this.openVerifyTargetDialog(monitor, workbench, targetStatus);
                if (LicenseVerifier.hasValidity(this.validity, this.requiredStatus) && (this.style & 4) == 0 && (this.style & 8) == 0) break;
            }
        }

        private void openVerifyTargetDialog(IProgressMonitor monitor, IWorkbench workbench, int targetStatus) {
            String errorMessage = null;
            Properties oldData = this.backupLocalData();
            IStatus oldValidity = this.validity;
            while (!monitor.isCanceled()) {
                Properties data = this.openInputDialog(monitor, workbench, targetStatus, errorMessage);
                if (data == null) {
                    this.loadDataFromUserInput(oldData);
                    this.validity = oldValidity;
                    return;
                }
                if (monitor.isCanceled()) {
                    return;
                }
                this.loadDataFromUserInput(data);
                this.validity = LicenseVerifier.createValidity(1024);
                boolean[] verifying = new boolean[]{true};
                this.openVerifyingDialog(monitor, workbench, verifying);
                subscriptionVerified = false;
                this.verifyLoadedData(monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                verifying[0] = false;
                this.closeVerifyingDialog(monitor, workbench);
                if (this.isValid()) {
                    if (targetStatus == 1 || !LicenseVerifier.hasValidity(oldValidity, 1) && LicenseVerifier.hasValidity(this.validity, 1)) {
                        System.currentTimeMillis();
                        this.openSubscriptionInfoDialog(monitor, workbench);
                    } else if (targetStatus != 1 && !LicenseVerifier.hasValidity(oldValidity, targetStatus) && LicenseVerifier.hasValidity(this.validity, targetStatus)) {
                        this.openVerifyTargetDialog(monitor, workbench, targetStatus);
                    } else if (targetStatus == 6 && LicenseVerifier.hasValidity(oldValidity, 1) && !LicenseVerifier.hasValidity(this.validity, 6)) {
                        errorMessage = Messages.LicenseInputDialog_InvalidLicenseKeyErrorMessage;
                        continue;
                    }
                    return;
                }
                if (data.getProperty(CLEARED) != null) {
                    return;
                }
                if (this.hasUser() && this.hasAuthToken()) {
                    this.openSubscriptionInfoDialog(monitor, workbench);
                    return;
                }
                errorMessage = this.generateErrorMessage();
            }
        }

        private void openSubscriptionInfoDialog(final IProgressMonitor monitor, final IWorkbench workbench) {
            while (!monitor.isCanceled()) {
                this.runWithUI(monitor, workbench, new Runnable(){

                    public void run() {
                        SubscriptionInfoDialog dialog;
                        int code;
                        Shell parentShell = VerificationJob.this.getParentShell(workbench);
                        int status = 4096;
                        long expireDate = 0L;
                        if (VerificationJob.this.expiration != null) {
                            status = LicenseVerifier.parseExpiration(VerificationJob.this.expiration, VerificationJob.this.uid);
                            expireDate = LicenseVerifier.parseExpireDate(VerificationJob.this.expiration, VerificationJob.this.uid);
                        }
                        if (VerificationJob.this.subscriptionExpireDate != null) {
                            expireDate = LicenseVerifier.parseExpireDate(VerificationJob.this.subscriptionExpireDate, VerificationJob.this.uid);
                        }
                        if ((code = (dialog = new SubscriptionInfoDialog(parentShell, status, VerificationJob.this.user, expireDate)).open()) == 0 || code == 1) {
                            monitor.setCanceled(true);
                            subscriptionVerified = true;
                        }
                    }
                }, false);
            }
        }

        private void openVerifyingDialog(final IProgressMonitor monitor, final IWorkbench workbench, final boolean[] verifying) {
            this.runWithUI(monitor, workbench, new Runnable(){

                public void run() {
                    if (!verifying[0]) {
                        return;
                    }
                    Shell parentShell = VerificationJob.this.getParentShell(workbench);
                    VerifyingStatusDialog dialog = new VerifyingStatusDialog(parentShell);
                    VerificationJob.this.currentDialog = (Window)dialog;
                    int code = dialog.open();
                    VerificationJob.this.currentDialog = null;
                    if (code != 0) {
                        VerificationJob.this.cancel();
                        monitor.setCanceled(true);
                    }
                }
            }, true, 200);
        }

        private void closeVerifyingDialog(IProgressMonitor monitor, IWorkbench workbench) {
            this.runWithUI(monitor, workbench, new Runnable(){

                public void run() {
                    if (VerificationJob.this.currentDialog != null) {
                        VerificationJob.this.currentDialog.close();
                        VerificationJob.this.currentDialog = null;
                    }
                }
            }, false);
        }

        private String generateErrorMessage() {
            if (LicenseVerifier.hasValidity(this.validity, 8192)) {
                return Messages.LicenseInputDialog_InvalidLicenseKeyErrorMessage;
            }
            if (LicenseVerifier.hasValidity(this.validity, 2048)) {
                return Messages.LicenseInputDialog_SubscriptionExpiredErrorMessage;
            }
            if (LicenseVerifier.hasValidity(this.validity, 4096)) {
                return Messages.LicenseInputDialog_NotSubscribedErrorMessage;
            }
            if (LicenseVerifier.hasValidity(this.validity, 0x40000000)) {
                return Messages.LicenseInputDialog_UnexpectedErrorMessage;
            }
            if (this.isLegacyValidity()) {
                return this.getLegacyErrorMessage();
            }
            return null;
        }

        private String getLegacyErrorMessage() {
            if (this.validity instanceof LegacyValidity) {
                int version = ((LegacyValidity)this.validity).getLegacyVersion();
                if (LegacyValidity.LegacyVersion.XMIND_2012.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 2012");
                }
                if (LegacyValidity.LegacyVersion.XMIND_2013_PRO.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 2013 Pro");
                }
                if (LegacyValidity.LegacyVersion.XMIND_2013_PLUS.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 2013 Plus");
                }
                if (LegacyValidity.LegacyVersion.XMIND_6_PRO.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 6 Pro");
                }
                if (LegacyValidity.LegacyVersion.XMIND_6_PLUS.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 6 Plus");
                }
                if (LegacyValidity.LegacyVersion.XMIND_7_PRO.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 7 Pro");
                }
                if (LegacyValidity.LegacyVersion.XMIND_7_PLUS.getValue() == version) {
                    return NLS.bind((String)Messages.LicenseInputDialog_LegacyLicenseKeyErrorMessage, (Object)"XMind 7 Plus");
                }
            }
            return null;
        }

        private Properties backupLocalData() {
            Properties data = new Properties();
            if (this.licenseEmail != null) {
                data.setProperty("TimeSmilesInMyHand", this.licenseEmail);
            }
            if (this.licenseKey != null) {
                data.setProperty("WalkingInTheMorning", this.licenseKey);
            }
            if (this.user != null) {
                data.setProperty("user", this.user);
            }
            if (this.authToken != null) {
                data.setProperty("token", this.authToken);
            }
            if (this.uid != null) {
                data.setProperty("ThisDawn", this.uid);
            }
            if (this.expiration != null) {
                data.setProperty("LastsAllDay", this.expiration);
            }
            if (this.subscriptionExpireDate != null) {
                data.setProperty("LastAllDay", this.subscriptionExpireDate);
            }
            return data;
        }

        private int openPlusMessageDialog(IProgressMonitor monitor, IWorkbench workbench) {
            final Shell parentShell = this.getParentShell(workbench);
            this.runWithUI(monitor, workbench, new Runnable(){

                public void run() {
                    new MessageDialog(parentShell, Messages.LicenseVerifyPlustoPro_Title, null, Messages.LicenseVerifyPlustoPro_Message, 4, new String[]{IDialogConstants.CLOSE_LABEL}, 0).open();
                }
            }, false);
            return -1;
        }

        private int openLicenseDialog(IProgressMonitor monitor, final IWorkbench workbench) {
            final int[] target = new int[]{-1};
            this.runWithUI(monitor, workbench, new Runnable(){

                public void run() {
                    Shell parentShell = VerificationJob.this.getParentShell(workbench);
                    LicenseInfoDialog2 dialog = new LicenseInfoDialog2(parentShell, VerificationJob.this.featureKeys, VerificationJob.joinStr(VerificationJob.this.actionNames), VerificationJob.this.requiredStatus, VerificationJob.this.validity.getCode(), (VerificationJob.this.style & 4) != 0, (VerificationJob.this.style & 8) != 0, VerificationJob.this.validity instanceof IValidity && (VerificationJob.this.validity.getCode() & 7) != 0 ? ((IValidity)VerificationJob.this.validity).getLicensedTo() : null);
                    VerificationJob.this.currentDialog = (Window)dialog;
                    int code = dialog.open();
                    VerificationJob.this.currentDialog = null;
                    target[0] = code == 0 ? dialog.getTargetStatus() : -1;
                }
            }, false);
            return target[0];
        }

        private boolean hasLicenseOrSubscription() {
            return LicenseVerifier.hasValidity(this.validity, 4) || LicenseVerifier.hasValidity(this.validity, 2) || LicenseVerifier.hasValidity(this.validity, 1);
        }

        private Properties openInputDialog(final IProgressMonitor monitor, final IWorkbench workbench, final int targetStatus, final String errorMessage) {
            final Properties data = this.backupLocalData();
            Properties input = this.userInput;
            this.userInput = null;
            if (input != null) {
                if (input.containsKey(LicenseVerifier.PROP_LICENSE_EMAIL)) {
                    data.setProperty("TimeSmilesInMyHand", input.getProperty(LicenseVerifier.PROP_LICENSE_EMAIL));
                }
                if (input.containsKey(LicenseVerifier.PROP_LICENSE_KEY)) {
                    data.setProperty("WalkingInTheMorning", input.getProperty(LicenseVerifier.PROP_LICENSE_KEY));
                }
            }
            final boolean[] canceled = new boolean[1];
            if ((targetStatus & 6) != 0) {
                this.runWithUI(monitor, workbench, new Runnable(){

                    public void run() {
                        Shell parentShell = VerificationJob.this.getParentShell(workbench);
                        LicenseKeyInputDialog2 dialog = new LicenseKeyInputDialog2(parentShell, data, VerificationJob.this.requiredStatus, VerificationJob.this.validity, false, LicenseVerifier.hasValidity(VerificationJob.this.validity, targetStatus));
                        dialog.setErrorMessage(errorMessage);
                        VerificationJob.this.currentDialog = (Window)dialog;
                        int code = dialog.open();
                        VerificationJob.this.currentDialog = null;
                        if (code == 1024) {
                            data.setProperty(VerificationJob.CLEARED, "yes");
                        }
                        if (code == 0 && LicenseVerifier.hasValidity(VerificationJob.this.validity, 6) && !LicenseVerifier.hasValidity(VerificationJob.this.validity, 1)) {
                            monitor.setCanceled(true);
                        }
                        if (code == 1025) {
                            monitor.setCanceled(true);
                        }
                        if (code == 1 && VerificationJob.this.hasLicenseOrSubscription()) {
                            monitor.setCanceled(true);
                        }
                        canceled[0] = code != 0 && code != 1024;
                    }
                }, false);
            } else if (!(targetStatus != 1 || this.hasUser() && this.hasAuthToken())) {
                this.runWithUI(monitor, workbench, new Runnable(){

                    public void run() {
                        Shell parentShell = VerificationJob.this.getParentShell(workbench);
                        IAccount account = AccountManager.getPrimaryAccount();
                        AuthenticationDialog dialog = new AuthenticationDialog(parentShell, account, null);
                        dialog.setErrorMessage(errorMessage);
                        VerificationJob.this.currentDialog = (Window)dialog;
                        int code = dialog.open();
                        VerificationJob.this.currentDialog = null;
                        boolean bl = canceled[0] = code != 0;
                        if (code == 0) {
                            data.put("token", account.getProperty("token"));
                            data.put("user", account.getProperty("user"));
                            data.remove("ThisDawn");
                            data.remove("LastsAllDay");
                            data.remove("LastAllDay");
                            subscriptionVerified = false;
                        }
                    }
                }, false);
            }
            if (canceled[0]) {
                return null;
            }
            return data;
        }

        private void runWithUI(IProgressMonitor monitor, IWorkbench workbench, Runnable runnable, boolean async) {
            this.runWithUI(monitor, workbench, runnable, async, 0);
        }

        private void runWithUI(IProgressMonitor monitor, IWorkbench workbench, final Runnable runnable, boolean async, final int delay) {
            final Display display = workbench.getDisplay();
            if (display == null || display.isDisposed()) {
                this.cancel();
                monitor.setCanceled(true);
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            final Throwable[] exception = new Throwable[]{null};
            final Runnable job = new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        exception[0] = e;
                    }
                }
            };
            if (async) {
                if (delay > 0) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            display.timerExec(delay, job);
                        }
                    });
                } else {
                    display.asyncExec(job);
                }
            } else {
                display.syncExec(job);
            }
            if (exception[0] != null) {
                throw new IllegalStateException(exception[0].getLocalizedMessage(), exception[0]);
            }
        }

        private Shell getParentShell(IWorkbench workbench) {
            Shell parentShell;
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            Shell shell = parentShell = window == null ? null : window.getShell();
            if (parentShell != null && parentShell.isDisposed()) {
                parentShell = null;
            }
            return parentShell;
        }

        private static String joinStr(Collection<String> strings) {
            StringBuffer sb = new StringBuffer(strings.size() * 10);
            for (String s : strings) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(s);
            }
            return sb.toString();
        }

        private void loadDataFromUserInput(Properties data) {
            this.licenseEmail = data.getProperty("TimeSmilesInMyHand");
            this.licenseKey = data.getProperty("WalkingInTheMorning");
            this.user = data.getProperty("user");
            this.authToken = data.getProperty("token");
            this.uid = data.getProperty("ThisDawn");
            this.expiration = data.getProperty("LastsAllDay");
            this.subscriptionExpireDate = data.getProperty("LastAllDay");
        }

        private void retrieveSubscription(IProgressMonitor monitor) {
            boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
            this.retrieveSubscriptionRequest.uri(LinkUtils.getLinkByUser((boolean)isCnUser, (boolean)true, (boolean)true, (String)EncodingUtils.format((String)"/_res/verify/%s", (Object[])new Object[]{this.user}))).addHeader("UID", this.uid).get();
            if (monitor.isCanceled() || this.retrieveSubscriptionRequest.isAborted()) {
                return;
            }
            int code = this.retrieveSubscriptionRequest.getStatusCode();
            IDataStore data = this.retrieveSubscriptionRequest.getData();
            if (code == 200 && data != null) {
                this.expiration = LicenseVerifier.extractExpiration(data, this.uid);
                this.subscriptionExpireDate = LicenseVerifier.extractExpireDate(data, this.uid);
                this.validity = this.expiration == null ? LicenseVerifier.createValidity(4096) : LicenseVerifier.createValidity(LicenseVerifier.parseExpiration(this.expiration, this.uid), this.user, null);
            } else if (this.retrieveUIDRequest.getError() != null) {
                this.validity = LicenseVerifier.createValidity(0x40000000, this.retrieveUIDRequest.getError());
            } else if (code >= 500 || code < 400) {
                this.validity = LicenseVerifier.createValidity(0x40000000);
            }
        }

        private void retrieveUID(IProgressMonitor monitor) {
            boolean isCnUser = AccountManager.getPrimaryAccount().isCnUser();
            this.retrieveUIDRequest.uri(LinkUtils.getLinkByUser((boolean)isCnUser, (boolean)true, (boolean)true, (String)EncodingUtils.format((String)"/_res/uid/%s", (Object[])new Object[]{this.user}))).setAuthToken(this.authToken).get();
            if (monitor.isCanceled() || this.retrieveUIDRequest.isAborted()) {
                return;
            }
            int code = this.retrieveUIDRequest.getStatusCode();
            IDataStore data = this.retrieveUIDRequest.getData();
            if (code == 200 && data != null) {
                this.uid = data.getString("uid");
            } else if (this.retrieveUIDRequest.getError() != null) {
                this.validity = LicenseVerifier.createValidity(0x40000000, this.retrieveUIDRequest.getError());
            } else if (code >= 500 || code < 400) {
                this.validity = LicenseVerifier.createValidity(0x40000000);
            }
        }

        private boolean hasLicenseKey() {
            return this.licenseKey != null && !"".equals(this.licenseKey);
        }

        private boolean hasLicenseEmail() {
            return this.licenseEmail != null && !"".equals(this.licenseEmail);
        }

        private boolean hasUser() {
            return this.user != null && !"".equals(this.user);
        }

        private boolean hasAuthToken() {
            return this.authToken != null && !"".equals(this.authToken);
        }

        private boolean hasSubscriptionExpireDate() {
            return this.subscriptionExpireDate != null && !"".equals(this.subscriptionExpireDate);
        }

        private boolean hasUID() {
            return this.uid != null && !"".equals(this.uid);
        }

        private boolean hasExpiration() {
            return this.expiration != null && !"".equals(this.expiration);
        }

        protected void canceling() {
            Display display;
            IWorkbench workbench;
            this.retrieveUIDRequest.abort();
            this.retrieveSubscriptionRequest.abort();
            final Window dialog = this.currentDialog;
            if (dialog != null && (workbench = PlatformUI.getWorkbench()) != null && (display = workbench.getDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        dialog.close();
                    }
                });
            }
            super.canceling();
        }

        private static Object[] getCommonVerifierParameters(String type) {
            if (VerifyPlugin.getDefault().isDebugging(LicenseVerifier.DEBUG_KEYS)) {
                return VerificationJob.getDebuggingCommonVerifierParameters(type);
            }
            if ("A".equals(type)) {
                return new Object[]{"Ae;\t&2}w#n`If5!nu6#{!hBA1IMDx%\n", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 67, 110, 47, 79, 88, 111, 85, 112, 98, 87, 70, 81, 117, 54, 78, 104, 55, 72, 85, 83, 66, 47, 115, 100, 74, 100, 114, 87, 110, 98, 72, 97, 74, 108, 75, 120, 87, 53, 76, 77, 69, 85, 88, 114, 75, 119, 47, 88, 85, 87, 65, 107, 81, 53, 100, 114, 69, 51, 89, 106, 66, 101, 84, 53, 47, 90, 87, 71, 110, 79, 85, 50, 81, 84, 108, 68, 48, 75, 72, 71, 87, 86, 48, 82, 122, 79, 110, 106, 97, 108, 119, 71, 122, 85, 85, 50, 116, 54, 87, 113, 84, 67, 118, 101, 104, 117, 55, 70, 84, 113, 52, 47, 105, 110, 119, 89, 48, 81, 83, 113, 47, 114, 97, 107, 116, 121, 51, 69, 74, 52, 76, 52, 70, 75, 100, 69, 122, 117, 113, 100, 82, 84, 109, 79, 77, 107, 47, 52, 78, 73, 54, 79, 57, 77, 50, 89, 55, 115, 99, 80, 81, 82, 79, 55, 83, 97, 97, 100, 67, 55, 47, 81, 73, 68, 65, 81, 65, 66}};
            }
            if ("B".equals(type)) {
                return new Object[]{"/[{%R<M$MP\t%6$(hp}Cs=49<JQ\"V4m\n", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 67, 101, 98, 71, 118, 48, 69, 51, 43, 67, 80, 108, 43, 107, 120, 116, 51, 86, 111, 87, 114, 76, 86, 66, 66, 50, 118, 65, 43, 71, 74, 84, 57, 109, 84, 107, 67, 109, 122, 121, 49, 119, 115, 47, 110, 86, 97, 65, 48, 51, 103, 84, 49, 103, 85, 111, 97, 72, 65, 79, 87, 122, 98, 73, 54, 115, 49, 120, 51, 108, 79, 75, 86, 113, 81, 114, 122, 66, 56, 98, 51, 80, 75, 51, 78, 56, 71, 56, 122, 51, 86, 50, 79, 82, 71, 73, 76, 100, 57, 84, 100, 81, 72, 120, 43, 57, 97, 79, 102, 102, 119, 111, 76, 69, 86, 87, 98, 75, 108, 80, 68, 74, 79, 107, 51, 56, 115, 90, 75, 53, 47, 70, 109, 83, 85, 81, 89, 74, 122, 113, 49, 56, 75, 72, 89, 81, 107, 68, 52, 100, 47, 69, 103, 55, 117, 86, 47, 57, 66, 54, 76, 68, 118, 83, 117, 103, 86, 115, 101, 57, 85, 119, 73, 68, 65, 81, 65, 66}};
            }
            if ("C".equals(type)) {
                return new Object[]{"VqNMK{?5o<8SdD^hNb#.\n\\5}pN4<_L\t", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 80, 114, 81, 112, 81, 43, 101, 71, 65, 49, 49, 83, 102, 48, 82, 100, 43, 68, 102, 74, 115, 80, 72, 81, 81, 110, 71, 79, 43, 99, 89, 87, 72, 120, 90, 82, 84, 102, 114, 50, 121, 106, 54, 86, 79, 97, 97, 100, 49, 98, 119, 68, 74, 90, 110, 67, 83, 65, 90, 69, 75, 97, 115, 52, 48, 122, 102, 114, 84, 47, 117, 43, 70, 80, 71, 86, 71, 113, 107, 120, 76, 121, 76, 88, 66, 74, 113, 99, 111, 72, 79, 69, 66, 104, 116, 55, 100, 87, 113, 108, 117, 112, 120, 85, 85, 72, 54, 108, 55, 78, 122, 107, 100, 118, 117, 122, 71, 108, 114, 106, 67, 119, 103, 77, 65, 71, 100, 98, 73, 115, 77, 78, 115, 114, 111, 65, 57, 116, 119, 82, 76, 104, 79, 99, 43, 56, 89, 85, 65, 97, 97, 87, 115, 57, 67, 84, 122, 55, 122, 54, 85, 77, 80, 57, 67, 66, 119, 111, 102, 112, 119, 73, 68, 65, 81, 65, 66}};
            }
            return null;
        }

        private static Object[] getDebuggingCommonVerifierParameters(String type) {
            if ("A".equals(type)) {
                return new Object[]{"PRO\n\t1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~-=!@#$%^&*()_+[]\\{}|;':\",./<>?", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 67, 49, 114, 77, 99, 87, 113, 112, 111, 67, 87, 107, 75, 86, 84, 71, 108, 48, 57, 43, 117, 120, 43, 112, 111, 112, 54, 72, 105, 121, 51, 78, 88, 75, 104, 50, 80, 90, 107, 118, 86, 90, 97, 86, 105, 99, 88, 84, 78, 55, 108, 88, 47, 71, 116, 78, 100, 83, 111, 75, 70, 71, 83, 121, 115, 110, 56, 110, 84, 84, 49, 87, 109, 114, 66, 67, 122, 85, 111, 114, 89, 66, 115, 78, 73, 102, 89, 110, 51, 113, 88, 102, 111, 70, 122, 57, 104, 111, 50, 121, 57, 99, 68, 49, 98, 55, 83, 110, 120, 114, 110, 84, 81, 67, 99, 81, 119, 49, 86, 98, 104, 109, 57, 119, 102, 109, 100, 111, 48, 53, 74, 81, 71, 86, 102, 56, 106, 86, 84, 106, 105, 68, 74, 76, 104, 102, 109, 70, 57, 75, 104, 121, 79, 111, 103, 114, 105, 107, 89, 76, 73, 56, 73, 104, 67, 84, 70, 99, 121, 50, 107, 119, 73, 68, 65, 81, 65, 66}};
            }
            if ("B".equals(type)) {
                return new Object[]{"PLUS\n\t1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~-=!@#$%^&*()_+[]\\{}|;':\",./<>?", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 68, 83, 86, 47, 102, 87, 118, 82, 101, 98, 120, 71, 120, 65, 53, 50, 68, 47, 110, 65, 47, 69, 113, 54, 117, 98, 56, 48, 98, 112, 116, 120, 74, 73, 74, 49, 107, 108, 66, 90, 120, 88, 85, 51, 108, 116, 65, 79, 108, 112, 105, 102, 100, 68, 99, 111, 50, 109, 71, 47, 89, 50, 118, 97, 83, 100, 67, 70, 104, 82, 50, 51, 71, 111, 107, 84, 65, 107, 48, 108, 122, 78, 70, 89, 66, 106, 119, 43, 65, 99, 86, 51, 55, 99, 105, 68, 119, 65, 109, 57, 70, 104, 83, 118, 115, 73, 67, 86, 84, 111, 88, 118, 69, 119, 109, 78, 55, 121, 98, 107, 122, 82, 100, 104, 89, 99, 119, 65, 83, 108, 81, 67, 116, 118, 50, 110, 47, 113, 116, 68, 55, 51, 99, 114, 76, 85, 66, 103, 122, 116, 89, 49, 84, 56, 74, 74, 110, 119, 79, 56, 107, 75, 118, 113, 67, 114, 110, 110, 68, 48, 71, 81, 73, 68, 65, 81, 65, 66}};
            }
            if ("C".equals(type)) {
                return new Object[]{"VINDY\n\t1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~-=!@#$%^&*()_+[]\\{}|;':\",./<>?", new byte[]{77, 73, 71, 102, 77, 65, 48, 71, 67, 83, 113, 71, 83, 73, 98, 51, 68, 81, 69, 66, 65, 81, 85, 65, 65, 52, 71, 78, 65, 68, 67, 66, 105, 81, 75, 66, 103, 81, 67, 118, 86, 85, 99, 120, 116, 53, 114, 103, 81, 97, 84, 90, 74, 104, 68, 103, 108, 70, 70, 99, 65, 48, 71, 103, 69, 89, 85, 119, 49, 74, 47, 100, 117, 78, 114, 122, 98, 86, 53, 78, 119, 122, 84, 73, 85, 76, 117, 108, 75, 48, 55, 48, 118, 82, 52, 112, 102, 109, 43, 55, 114, 114, 87, 120, 80, 119, 121, 84, 49, 106, 67, 117, 85, 101, 99, 110, 67, 101, 112, 77, 109, 103, 113, 56, 72, 74, 121, 119, 89, 55, 111, 89, 71, 106, 85, 74, 116, 47, 114, 86, 67, 114, 117, 118, 116, 118, 111, 118, 57, 54, 84, 97, 57, 69, 75, 107, 88, 103, 100, 115, 85, 88, 51, 119, 65, 109, 51, 56, 90, 100, 117, 111, 67, 101, 81, 71, 80, 43, 108, 109, 122, 82, 87, 118, 49, 110, 87, 111, 114, 50, 120, 84, 54, 66, 51, 120, 99, 49, 116, 114, 103, 89, 66, 110, 98, 75, 114, 75, 110, 81, 73, 68, 65, 81, 65, 66}};
            }
            return null;
        }

        private boolean isLegacyValidity() {
            return LicenseVerifier.checkValid(this.validity, 16384);
        }
    }
}

