/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.dialog;

import java.util.HashMap;
import java.util.Map;
import net.xmind.share.Messages;
import net.xmind.share.dialog.UploaderPage;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.resources.FontUtils;

public class PrivacyUploaderPage
extends UploaderPage {
    private static boolean SmallFonts = Util.isMac() && System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
    private Map<Object, Button> optionButtons;
    private Button downloadCheck;

    public PrivacyUploaderPage() {
        this.setTitle(Messages.UploaderDialog_Privacy_title);
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        composite.setLayout((Layout)layout);
        this.optionButtons = new HashMap<Object, Button>();
        Listener optionHandler = new Listener(){

            public void handleEvent(Event event) {
                PrivacyUploaderPage.this.handleOptionSelected((Button)event.widget);
            }
        };
        this.createOption(composite, Messages.UploaderDialog_Privacy_Public_title, "1", optionHandler);
        this.createDescription(composite, Messages.UploaderDialog_Privacy_Public_description);
        this.createOption(composite, Messages.UploaderDialog_Privacy_Unlisted_title, "3", optionHandler);
        this.createDescription(composite, Messages.UploaderDialog_Privacy_Unlisted_description);
        this.createOption(composite, Messages.UploaderDialog_Privacy_Private_title, "2", optionHandler);
        this.createDescription(composite, Messages.UploaderDialog_Privacy_Private_description);
        this.createDownloadCheck(composite);
        this.updateWidgets();
        this.setAccessibility(this.getAccessibility());
        this.setDownloadable(this.getDownloadable());
        this.setControl((Control)composite);
    }

    private void createOption(Composite parent, String text, Object data, Listener optionHandler) {
        Button button = new Button(parent, 16);
        button.setBackground(parent.getBackground());
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        if (SmallFonts) {
            button.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)2));
        } else {
            button.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)1));
        }
        button.setText(text);
        button.setData(data);
        this.optionButtons.put(data, button);
        button.addListener(13, optionHandler);
    }

    private void createDescription(Composite parent, String description) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 15;
        layout.marginLeft = 20;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setBackground(composite.getBackground());
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!SmallFonts) {
            label.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        }
        label.setText(description);
    }

    private void createDownloadCheck(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginTop = 10;
        composite.setLayout((Layout)layout);
        this.downloadCheck = new Button(composite, 32);
        this.downloadCheck.setBackground(parent.getBackground());
        this.downloadCheck.setText(Messages.UploaderDialog_Privacy_AllowDownload_text);
        this.downloadCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.downloadCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PrivacyUploaderPage.this.setDownloadable(((Button)event.widget).getSelection());
            }
        });
    }

    private void handleOptionSelected(Button button) {
        Object data = button.getData();
        if (data == null) {
            return;
        }
        this.setAccessibility(data);
    }

    private void updateWidgets() {
        Object accessibility = this.getAccessibility();
        if (this.optionButtons != null) {
            Button selectedButton = this.optionButtons.get(accessibility);
            for (Button button : this.optionButtons.values()) {
                button.setSelection(button == selectedButton);
            }
        }
        if (this.downloadCheck != null && !this.downloadCheck.isDisposed()) {
            this.downloadCheck.setSelection(this.getDownloadable());
        }
    }

    private Object getAccessibility() {
        Object value = this.getInfo().getProperty("Share/Privacy");
        if (value == null && (value = this.getContainer().getDialogSettings().get("Share/Privacy")) == null) {
            value = "1";
        }
        return value;
    }

    private boolean getDownloadable() {
        Object value = this.getInfo().getProperty("Share/Downloadable");
        if (value == null && (value = this.getContainer().getDialogSettings().get("Share/Downloadable")) == null) {
            value = "1";
        }
        return !"0".equals(value);
    }

    private void setAccessibility(Object value) {
        if (value == null || !(value instanceof String)) {
            return;
        }
        this.getInfo().setProperty("Share/Privacy", value);
    }

    private void setDownloadable(boolean value) {
        String data = value ? "1" : "0";
        this.getInfo().setProperty("Share/Downloadable", data);
    }
}

