/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.brainstorm.Activator;
import org.xmind.ui.internal.brainstorm.BrainstormMessages;
import org.xmind.ui.internal.brainstorm.TimerService;
import org.xmind.ui.resources.FontUtils;

public class TimerSettingsDialog
extends Dialog {
    private static final String KEY_DIDA = "dida";
    private static final String KEY_MIN_VALUE = "MIN_VALUE";
    private static final String KEY_HOUR_VALUE = "HOUR_VALUE";
    private IGraphicalViewer viewer;
    private Button dida;
    private Text hourText;
    private Text minText;

    protected TimerSettingsDialog(IGraphicalViewer viewer, Shell parentShell) {
        super(parentShell);
        this.viewer = viewer;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(BrainstormMessages.TimerSettingsDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings dialogSetting = Activator.getDefault().getDialogSettings();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 35;
        layout.marginBottom = 15;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.horizontalSpacing = 5;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Composite hourContrain = new Composite(composite, 0);
        GridLayout hourLayout = new GridLayout();
        hourLayout.makeColumnsEqualWidth = true;
        hourLayout.numColumns = 2;
        hourLayout.horizontalSpacing = 5;
        hourContrain.setLayout((Layout)hourLayout);
        this.hourText = new Text(hourContrain, 133120);
        GridData hourTextData = new GridData();
        hourTextData.widthHint = 60;
        this.hourText.setLayoutData((Object)hourTextData);
        String hourValue = dialogSetting.get(KEY_HOUR_VALUE);
        if (hourValue != null) {
            this.hourText.setText(hourValue);
        } else {
            this.hourText.setText(String.valueOf(0));
        }
        this.hourText.setTextLimit(2);
        this.hourText.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String text = event.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        event.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        Label hourLabel = new Label(hourContrain, 0);
        hourLabel.setText(BrainstormMessages.TimerSettingsDialog_HoursLabel_text);
        hourLabel.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        Composite minContrain = new Composite(composite, 0);
        GridLayout minLayout = new GridLayout();
        minLayout.makeColumnsEqualWidth = true;
        minLayout.numColumns = 2;
        minLayout.horizontalSpacing = 5;
        minContrain.setLayout((Layout)minLayout);
        this.minText = new Text(minContrain, 133120);
        GridData minTextData = new GridData();
        minTextData.widthHint = 60;
        this.minText.setLayoutData((Object)minTextData);
        String minValue = dialogSetting.get(KEY_MIN_VALUE);
        if (minValue != null) {
            this.minText.setText(minValue);
        } else {
            this.minText.setText(String.valueOf(1));
        }
        this.minText.setTextLimit(2);
        this.minText.setSelection(0, 2);
        this.minText.setFocus();
        this.minText.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String text = event.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        event.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        Label minLabel = new Label(minContrain, 0);
        minLabel.setText(BrainstormMessages.TimerSettingsDialog_MinutesLabel_text);
        minLabel.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 10;
        composite.setLayout((Layout)gridLayout);
        this.dida = new Button(composite, 16416);
        this.dida.setText(BrainstormMessages.TimerSettingsDialog_DiDaButton_text);
        this.dida.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        boolean isChecked = Activator.getDefault().getDialogSettings().getBoolean(KEY_DIDA);
        this.dida.setSelection(isChecked);
        Composite buttonBar = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        buttonBar.setLayout((Layout)layout);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.createButton(buttonBar, 0, BrainstormMessages.TimerSettingsDialog_StartButton_text, true).setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)1));
        return buttonBar;
    }

    protected void okPressed() {
        String hourContent = this.hourText.getText();
        String minContent = this.minText.getText();
        int hour = Integer.valueOf(hourContent == "" ? String.valueOf(0) : hourContent);
        int min = Integer.valueOf(minContent == "" ? String.valueOf(0) : minContent);
        if (hour != 0 || min != 0) {
            IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
            dialogSettings.put(KEY_HOUR_VALUE, hourContent);
            dialogSettings.put(KEY_MIN_VALUE, minContent);
            dialogSettings.put(KEY_DIDA, this.dida.getSelection());
            TimerService timerService = (TimerService)this.viewer.getService(TimerService.class);
            if (timerService == null) {
                timerService = new TimerService(this.viewer);
            }
            timerService.setActive(false);
            timerService.getTimer().setTotal(hour * 3600 + min * 60);
            timerService.setDida(this.dida.getSelection());
            timerService.setActive(true);
            timerService.start();
        }
        super.okPressed();
    }
}

