/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.biggerplate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xmind.core.Core;
import org.xmind.core.IMeta;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.gef.GEF;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.biggerplate.BiggerplateMessages;
import org.xmind.ui.dialogs.Notification;
import org.xmind.ui.internal.biggerplate.FileValidationException;
import org.xmind.ui.internal.biggerplate.Info;
import org.xmind.ui.internal.biggerplate.dialog.BiggerplateUploaderDialog;
import org.xmind.ui.internal.biggerplate.jobs.AuthoriseJob;
import org.xmind.ui.internal.biggerplate.jobs.BiggerplateUploadJob;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExtractor;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.TextFormatter;

public class BiggerplateUploader
extends JobChangeAdapter {
    private static BiggerplateUploader uploader = new BiggerplateUploader();
    private Shell parentShell;
    private IMindMapViewer sourceViewer;
    private IWorkbook workbook;
    private MindMapExtractor extractor;
    private Info info;
    private Point origin;
    private Image previewImage;
    private File file;
    private BiggerplateUploaderDialog dialog;
    private boolean isRunning = false;

    private BiggerplateUploader() {
    }

    public static BiggerplateUploader getUploader(Shell parentShell, IMindMapViewer sourceViewer) {
        BiggerplateUploader.uploader.parentShell = parentShell;
        BiggerplateUploader.uploader.sourceViewer = sourceViewer;
        return uploader;
    }

    public void upload() {
        if (this.isRunning) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            return;
        }
        this.isRunning = true;
        this.info = new Info();
        AuthoriseJob authoriseJob = new AuthoriseJob(this.info);
        authoriseJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final IStatus result = event.getResult();
                if (result == Status.OK_STATUS) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            BiggerplateUploader.this.doUpload();
                        }
                    });
                } else if (result.matches(6)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            BiggerplateUploader.this.promptError(result);
                        }
                    });
                    BiggerplateUploader.this.isRunning = false;
                } else {
                    BiggerplateUploader.this.isRunning = false;
                }
            }
        });
        authoriseJob.schedule();
    }

    private void doUpload() {
        boolean prepared = false;
        try {
            prepared = this.prepare();
        }
        catch (OutOfMemoryError e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.xmind.ui.biggerplate", BiggerplateMessages.ErrorDialog_OutOfMemory_message, (Throwable)e), 2);
        }
        catch (Throwable e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.xmind.ui.biggerplate", BiggerplateMessages.ErrorDialog_UnexpectedError_message, e), 2);
        }
        if (!prepared) {
            this.cancel();
            return;
        }
        BiggerplateUploadJob uploadJob = new BiggerplateUploadJob(this.info);
        uploadJob.setSystem(false);
        uploadJob.setUser(true);
        uploadJob.addJobChangeListener((IJobChangeListener)this);
        uploadJob.schedule();
    }

    private boolean prepare() throws Exception {
        this.info.setBoolean("multiSheets", this.multiSheets(this.sourceViewer));
        this.extractor = new MindMapExtractor(this.sourceViewer);
        this.workbook = this.extractor.extract();
        this.generatePreview(this.parentShell.getDisplay());
        if (this.previewImage == null || this.origin == null) {
            throw new RuntimeException(BiggerplateMessages.failedToGenerateThumbnail);
        }
        this.info.setProperty("Title", this.getDefaultMapTitle());
        this.info.setProperty("FullImage", this.previewImage);
        this.info.setInt("Thumbnail/Origin/X", this.origin.x);
        this.info.setInt("Thumbnail/Origin/Y", this.origin.y);
        this.info.setProperty("Thumbnail/BackgroundColor", this.getBackgroundColor());
        this.dialog = this.createUploadDialog();
        int ret = this.dialog.open();
        if (ret != 0) {
            return false;
        }
        this.dialog = null;
        int x = this.info.getInt("Thumbnail/X", 0);
        int y = this.info.getInt("Thumbnail/Y", 0);
        double scale = this.info.getDouble("Thumbnail/Scale", 1.0);
        IMeta meta = this.workbook.getMeta();
        meta.setValue("Description", this.info.getString("Description"));
        meta.setValue("Thumbnail/X", String.valueOf(x));
        meta.setValue("Thumbnail/Y", String.valueOf(y));
        meta.setValue("Thumbnail/Scale", String.valueOf(scale /= 2.0));
        meta.setValue("Thumbnail/Origin/X", String.valueOf(this.origin.x));
        meta.setValue("Thumbnail/Origin/Y", String.valueOf(this.origin.y));
        meta.setValue("Thumbnail/BackgroundColor", this.info.getString("Thumbnail/BackgroundColor"));
        if (this.file == null) {
            String tempFile = Core.getWorkspace().getTempFile("biggerplate/" + UUID.randomUUID().toString() + ".xmind");
            this.file = new File(tempFile);
        }
        ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
        serializer.setWorkbook(this.workbook);
        FileOutputStream output = new FileOutputStream(this.file);
        try {
            serializer.setOutputStream((OutputStream)output);
            serializer.serialize(null);
        }
        finally {
            ((OutputStream)output).close();
        }
        BiggerplateUploader.validateUploadFile(this.file.getAbsolutePath());
        if (!this.file.exists() || !this.file.canRead()) {
            throw new FileNotFoundException(BiggerplateMessages.FailedToGenerateUploadFile);
        }
        this.info.setProperty("File", this.file);
        this.info.setProperty("Workbook", this.workbook);
        return true;
    }

    private void cancel() {
        this.clearTemp();
        this.isRunning = false;
    }

    private Boolean multiSheets(IMindMapViewer sourceViewer) {
        IWorkbook workbook = (IWorkbook)sourceViewer.getAdapter(IWorkbook.class);
        if (workbook.getSheets().size() > 1) {
            return true;
        }
        return false;
    }

    private void generatePreview(Display display) {
        MindMapImageExporter exporter = new MindMapImageExporter(display);
        exporter.setSource((Object)new MindMap(this.workbook.getPrimarySheet()), null, null);
        exporter.setTargetWorkbook(this.workbook);
        this.previewImage = exporter.createImage();
        exporter.export(this.previewImage);
        this.origin = exporter.calcRelativeOrigin();
    }

    private String getDefaultMapTitle() {
        if (this.workbook != null) {
            return TextFormatter.removeNewLineCharacter((String)(this.workbook.getPrimarySheet().getRootTopic() != null ? this.workbook.getPrimarySheet().getRootTopic().getTitleText() : ""));
        }
        return null;
    }

    private String getBackgroundColor() {
        Color color;
        Layer layer = this.sourceViewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer != null && (color = layer.getBackgroundColor()) != null) {
            return ColorUtils.toString((Color)color);
        }
        return "#ffffff";
    }

    private BiggerplateUploaderDialog createUploadDialog() {
        BiggerplateUploaderDialog dialog = new BiggerplateUploaderDialog(this.parentShell);
        dialog.setInfo(this.info);
        return dialog;
    }

    private void clearTemp() {
        if (this.previewImage != null) {
            this.previewImage.dispose();
            this.previewImage = null;
        }
        if (this.extractor != null) {
            this.extractor.delete();
            this.extractor = null;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        this.workbook = null;
    }

    public void done(IJobChangeEvent event) {
        this.clearTemp();
        final IStatus result = event.getResult();
        this.runInUI(new Runnable(){

            public void run() {
                if (result.isOK()) {
                    BiggerplateUploader.this.promptCompletion(BiggerplateUploader.this.info.getString("resultUrl"));
                } else if (result.matches(6)) {
                    BiggerplateUploader.this.promptError(result);
                }
            }
        });
        this.isRunning = false;
    }

    private void runInUI(Runnable runnable) {
        Display display = this.parentShell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void promptCompletion(final String permalink) {
        Control control;
        if (permalink == null) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Action viewAction = new Action(){

            public void run() {
                try {
                    Program.launch((String)permalink);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        };
        viewAction.setText(BiggerplateMessages.Uploader_OpenAction_text);
        Rectangle bounds = null;
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor && (control = ((IGraphicalEditor)activeEditor).getActivePageInstance().getControl()) != null && !control.isDisposed()) {
            Rectangle bounds2 = control.getBounds();
            org.eclipse.swt.graphics.Point toDisplay = control.getParent().toDisplay(bounds2.x, bounds2.y);
            bounds = new Rectangle(toDisplay.x, toDisplay.y, bounds2.width, bounds2.height);
        }
        Notification popup = new Notification(window.getShell(), BiggerplateMessages.UploadJob_OpenMap_message, (IAction)viewAction, bounds, true, false, true, null);
        popup.setDuration(5000);
        popup.open();
    }

    private void promptError(IStatus error) {
        MessageDialog.openWarning(null, (String)BiggerplateMessages.ErrorDialog_title, (String)error.getMessage());
    }

    public static void validateUploadFile(String path) {
        HashSet<String> entries = new HashSet<String>();
        try {
            ZipInputStream zin = new ZipInputStream(new FileInputStream(path));
            try {
                ZipEntry e;
                while ((e = zin.getNextEntry()) != null) {
                    String name = e.getName();
                    entries.add(name);
                }
            }
            finally {
                zin.close();
            }
        }
        catch (Throwable e) {
            throw new FileValidationException("File Validation Failed: " + e.getLocalizedMessage(), e);
        }
        if (!entries.contains("Thumbnails/thumbnail.png")) {
            throw new FileValidationException("File Validation Failed: missing entry 'Thumbnails/thumbnail.png'");
        }
    }
}

