/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.browser.IBrowserViewer;
import org.xmind.ui.browser.IBrowserViewerContainer;
import org.xmind.ui.internal.browser.BrowserImages;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserPlugin;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.internal.browser.BrowserViewer;
import org.xmind.ui.internal.browser.InternalBrowser;
import org.xmind.ui.internal.browser.InternalBrowserEditor;
import org.xmind.ui.internal.browser.actions.CopyAction;
import org.xmind.ui.internal.browser.actions.CutAction;
import org.xmind.ui.internal.browser.actions.DeleteAction;
import org.xmind.ui.internal.browser.actions.PasteAction;

public class InternalBrowserView
extends ViewPart
implements IBrowserViewerContainer {
    public static final String BROWSER_VIEW_ID = "org.xmind.ui.BrowserView";
    private static final String GROUP_CONTROLS = "org.xmind.ui.browser.controls";
    private static final String KEY_STYLE = "style";
    private BrowserViewer viewer;
    private String clientId;
    private int style;
    private ActionContributionItem backActionItem = null;
    private ActionContributionItem forwardActionItem = null;
    private ActionContributionItem stopRefreshActionItem = null;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void changeStyle(int newStyle) {
        if ((newStyle & 0x400) != 0 && (newStyle & 0x800) != 0) {
            newStyle |= 0x1000;
        }
        this.style = newStyle;
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            boolean hasNoToolBar;
            int oldStyle = this.viewer.getStyle();
            this.viewer.changeStyle(newStyle);
            boolean hadNoToolBar = (oldStyle & 0x1000) != 0;
            boolean bl = hasNoToolBar = (newStyle & 0x1000) != 0;
            if (hasNoToolBar && !hadNoToolBar) {
                IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
                this.removeControls(toolBar);
                toolBar.update(true);
            } else if (hadNoToolBar && !hasNoToolBar) {
                IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
                this.addControls(toolBar);
                toolBar.update(true);
            }
        }
    }

    private void removeControls(IToolBarManager toolBar) {
        if (this.backActionItem != null) {
            toolBar.remove((IContributionItem)this.backActionItem);
            this.backActionItem.dispose();
            this.backActionItem = null;
        }
        if (this.forwardActionItem != null) {
            toolBar.remove((IContributionItem)this.forwardActionItem);
            this.forwardActionItem.dispose();
            this.forwardActionItem = null;
        }
        if (this.stopRefreshActionItem != null) {
            toolBar.remove((IContributionItem)this.stopRefreshActionItem);
            this.stopRefreshActionItem.dispose();
            this.stopRefreshActionItem = null;
        }
    }

    private void addControls(IToolBarManager toolBar) {
        this.stopRefreshActionItem = new ActionContributionItem((IAction)this.viewer.getStopRefreshAction());
        toolBar.prependToGroup(GROUP_CONTROLS, (IContributionItem)this.stopRefreshActionItem);
        this.forwardActionItem = new ActionContributionItem((IAction)this.viewer.getForwardAction());
        toolBar.prependToGroup(GROUP_CONTROLS, (IContributionItem)this.forwardActionItem);
        this.backActionItem = new ActionContributionItem((IAction)this.viewer.getBackAction());
        toolBar.prependToGroup(GROUP_CONTROLS, (IContributionItem)this.backActionItem);
    }

    public void saveState(IMemento memento) {
        memento.putInteger(KEY_STYLE, this.style);
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.clientId = site.getSecondaryId();
        Integer styleValue = memento == null ? null : memento.getInteger(KEY_STYLE);
        this.style = styleValue == null ? 0 : styleValue;
        super.init(site, memento);
    }

    public void createPartControl(final Composite parent) {
        this.viewer = new BrowserViewer(parent, this.style, this);
        this.initActions();
        final Image defaultImage = this.getTitleImage();
        this.viewer.getBusyIndicator().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!parent.isDisposed()) {
                    parent.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!parent.isDisposed() && defaultImage != null && !defaultImage.isDisposed()) {
                                Image currentImage = InternalBrowserView.this.viewer.getBusyIndicator().getCurrentImage();
                                if (currentImage == null || !InternalBrowserView.this.viewer.getBusyIndicator().isAnimating()) {
                                    InternalBrowserView.this.setTitleImage(defaultImage);
                                } else {
                                    InternalBrowserView.this.setTitleImage(currentImage);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private void initActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        OpenInExternalAction openInExternalAction = new OpenInExternalAction();
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new GroupMarker(GROUP_CONTROLS));
        menu.add((IAction)openInExternalAction);
        menu.add((IContributionItem)new Separator("additions"));
        this.registerAction(actionBars, (IAction)new CopyAction(this.viewer));
        this.registerAction(actionBars, (IAction)new CutAction(this.viewer));
        this.registerAction(actionBars, (IAction)new PasteAction(this.viewer));
        this.registerAction(actionBars, (IAction)new DeleteAction(this.viewer));
    }

    private void registerAction(IActionBars actionBars, IAction action) {
        actionBars.setGlobalActionHandler(action.getId(), action);
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void openURL(String url) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setURL(url);
        }
    }

    public BrowserViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IBrowserViewer.class) {
            return this.viewer;
        }
        if (adapter == IBrowserViewerContainer.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean close() {
        try {
            this.getSite().getPage().hideView((IViewPart)this);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void openInExternalBrowser(String url) {
        BrowserUtil.gotoUrl(url);
    }

    public Browser openNewBrowser() {
        final Browser[] ret = new Browser[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IWorkbenchPart part;
                IBrowser browser = BrowserSupport.getInstance().createBrowser(4, InternalBrowserView.this.getClientId());
                browser.openURL("");
                if (browser instanceof InternalBrowser && (part = ((InternalBrowser)browser).getPart()) instanceof InternalBrowserEditor) {
                    ret[0] = ((InternalBrowserEditor)part).getViewer().getBrowser();
                }
            }
        });
        return ret[0];
    }

    private class OpenInExternalAction
    extends Action {
        public OpenInExternalAction() {
            super(BrowserMessages.BrowserView_OpenInExternalBrowser_text, BrowserImages.getImageDescriptor("icons/browser.gif"));
            this.setToolTipText(BrowserMessages.BrowserView_OpenInExternalBrowser_toolTip);
        }

        public void run() {
            if (InternalBrowserView.this.viewer == null || InternalBrowserView.this.viewer.getControl() == null || InternalBrowserView.this.viewer.getControl().isDisposed()) {
                return;
            }
            IBrowser browser = BrowserSupport.getInstance().createBrowser(1);
            try {
                browser.openURL(InternalBrowserView.this.viewer.getURL());
            }
            catch (PartInitException e) {
                BrowserPlugin.log(e);
            }
        }
    }
}

