/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.SheetSettings;
import org.xmind.core.internal.dom.SettingEntryImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetSettingsImpl
extends SheetSettings {
    private Element implementation;
    private SheetImpl ownedSheet;
    private ElementRegistry elementRegistry;

    public SheetSettingsImpl(Element implementation, SheetImpl ownedSheet) {
        this.implementation = implementation;
        this.ownedSheet = ownedSheet;
    }

    @Override
    public Set<String> getPaths() {
        HashSet<String> paths = new HashSet<String>();
        Element e = DOMUtils.getFirstChildElementByTag(this.implementation, "sheet-settings");
        if (e == null) {
            return paths;
        }
        this.collectPaths(paths, e, null);
        return paths;
    }

    private void collectPaths(Set<String> paths, Element p, String path) {
        Iterator<Element> childIt = DOMUtils.childElementIter(p);
        if (childIt.hasNext()) {
            while (childIt.hasNext()) {
                Element c = childIt.next();
                String subTag = c.getTagName();
                String subPath = path == null ? subTag : String.valueOf(path) + "/" + subTag;
                this.collectPaths(paths, c, subPath);
            }
        } else if (path != null) {
            paths.add(path);
        }
    }

    @Override
    public List<ISettingEntry> getEntries(String path) {
        if (path == null || "".equals(path)) {
            return Collections.emptyList();
        }
        Element e = DOMUtils.getFirstChildElementByTag(this.implementation, "sheet-settings");
        if (e == null) {
            return Collections.emptyList();
        }
        String[] keys = path.split("/");
        if (keys.length > 0) {
            String endKey = keys[keys.length - 1];
            Element c = null;
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key != endKey) {
                    c = DOMUtils.getFirstChildElementByTag(e, key);
                    if (c == null) break;
                } else {
                    ArrayList<ISettingEntry> entries = new ArrayList<ISettingEntry>();
                    Iterator<Element> es = DOMUtils.childElementIterByTag(e, key);
                    while (es.hasNext()) {
                        Element entryEle = es.next();
                        SettingEntryImpl entry = this.getEntry(entryEle, path);
                        if (entry == null) continue;
                        entries.add(entry);
                    }
                    return entries;
                }
                e = c;
                ++n2;
            }
        }
        return Collections.emptyList();
    }

    protected SettingEntryImpl getEntry(Element entryEle, String path) {
        Object entry;
        if (this.elementRegistry != null && (entry = this.elementRegistry.getElement(entryEle)) != null && entry instanceof ISettingEntry) {
            return (SettingEntryImpl)entry;
        }
        entry = new SettingEntryImpl(entryEle, path, this.ownedSheet);
        this.getElementRegistry().registerByKey(entryEle, entry);
        return entry;
    }

    @Override
    public ISettingEntry createEntry(String path) {
        String[] keys;
        if (path != null && (keys = path.split("/")).length > 0) {
            String tag = keys[keys.length - 1];
            Element entryEle = this.implementation.getOwnerDocument().createElement(tag);
            SettingEntryImpl entry = new SettingEntryImpl(entryEle, path, this.ownedSheet);
            this.getElementRegistry().registerByKey(entryEle, entry);
            return entry;
        }
        return null;
    }

    @Override
    public void addEntry(ISettingEntry entry) {
        SettingEntryImpl entryImpl = (SettingEntryImpl)entry;
        String path = entryImpl.getPath();
        String[] keys = path.split("/");
        String lastKey = keys[keys.length - 1];
        Element p = DOMUtils.ensureChildElement(this.implementation, "sheet-settings");
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key != lastKey) {
                p = DOMUtils.ensureChildElement(p, key);
            } else {
                p.appendChild(entryImpl.getImplementation());
                for (String attrKey : entry.getAttributeKeys()) {
                    CoreEvent event = new CoreEvent((ICoreEventSource)this.ownedSheet, "sheetSettings", (Object)attrKey, null, entry.getAttribute(attrKey));
                    event.setData(path);
                    this.ownedSheet.getCoreEventSupport().dispatch(this.ownedSheet, event);
                }
            }
            ++n2;
        }
    }

    @Override
    public void removeEntry(ISettingEntry entry) {
        Element settingsEle = DOMUtils.getFirstChildElementByTag(this.implementation, "sheet-settings");
        if (settingsEle == null) {
            return;
        }
        String path = entry.getPath();
        Element entryEle = ((SettingEntryImpl)entry).getImplementation();
        settingsEle.removeChild(entryEle);
        for (String attrKey : entry.getAttributeKeys()) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this.ownedSheet, "sheetSettings", (Object)attrKey, (Object)entry.getAttribute(attrKey), null);
            event.setData(path);
            this.ownedSheet.getCoreEventSupport().dispatch(this.ownedSheet, event);
        }
    }

    protected Element getImplementation() {
        return this.implementation;
    }

    public ElementRegistry getElementRegistry() {
        if (this.elementRegistry == null) {
            this.elementRegistry = new ElementRegistry();
        }
        return this.elementRegistry;
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.ownedSheet;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedSheet.getOwnedWorkbook();
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SheetSettingsImpl)) {
            return false;
        }
        SheetSettingsImpl that = (SheetSettingsImpl)obj;
        return that.implementation == this.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }
}

