/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.export;

import com.evernote.clients.NoteStoreClient;
import com.evernote.clients.UserStoreClient;
import com.evernote.edam.error.EDAMErrorCode;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.BusinessUserInfo;
import com.evernote.edam.type.PremiumInfo;
import com.evernote.edam.type.User;
import com.evernote.thrift.TException;
import com.evernote.thrift.transport.TTransportException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.evernote.EvernoteStore;
import org.xmind.ui.evernote.signin.IEvernoteAccount;
import org.xmind.ui.internal.evernote.EvernoteMessages;
import org.xmind.ui.internal.evernote.export.EvernoteExportDialog;
import org.xmind.ui.internal.evernote.export.EvernoteExporter;
import org.xmind.ui.mindmap.IMindMapViewer;

public class EvernoteExportJob
extends Job {
    private IMindMapViewer viewer;
    private IEvernoteAccount accountInfo;
    private User user;

    public EvernoteExportJob(IMindMapViewer viewer, IEvernoteAccount accountInfo) {
        super(NLS.bind((String)EvernoteMessages.EvernoteExportJob_jobName_withCentralTopicTitle, (Object)viewer.getCentralTopic().getTitleText()));
        this.viewer = viewer;
        this.accountInfo = accountInfo;
    }

    protected IStatus run(IProgressMonitor monitor) {
        List notebooks;
        NoteStoreClient noteStore;
        if (!PlatformUI.isWorkbenchRunning()) {
            return new Status(4, "org.xmind.ui.evernote", "No workbench is running.");
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return new Status(4, "org.xmind.ui.evernote", "No workbench is available.");
        }
        final Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return new Status(4, "org.xmind.ui.evernote", "No display is available.");
        }
        final EvernoteStore evernoteStore = new EvernoteStore(this.accountInfo);
        try {
            noteStore = evernoteStore.getNoteStore();
            UserStoreClient userStore = evernoteStore.getUserStore();
            notebooks = noteStore.listNotebooks();
            this.user = userStore.getUser();
        }
        catch (EDAMUserException e) {
            return this.error(e);
        }
        catch (EDAMSystemException e) {
            return this.error(e);
        }
        catch (TTransportException e) {
            return this.error(e);
        }
        catch (TException e) {
            return new Status(2, "org.xmind.ui.evernote", e.getMessage(), (Throwable)e);
        }
        final EvernoteExportDialog[] dialog = new EvernoteExportDialog[1];
        final int[] result = new int[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell;
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell shell2 = shell = window == null ? display.getActiveShell() : window.getShell();
                if (shell != null) {
                    shell.setActive();
                }
                dialog[0] = new EvernoteExportDialog(shell, notebooks, evernoteStore.getEvernoteService());
                result[0] = dialog[0].open();
            }
        });
        if (result[0] == 0) {
            try {
                new EvernoteExporter(this.viewer, noteStore).export();
            }
            catch (EDAMSystemException e) {
                return this.error(e);
            }
            catch (EDAMUserException e) {
                return this.error(e);
            }
            catch (TTransportException e) {
                return this.error(e);
            }
            catch (TException e) {
                e.printStackTrace();
            }
            catch (EDAMNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private String getErrorMessage(EDAMErrorCode errorCode, String message) {
        if (errorCode == null || errorCode.equals((Object)EDAMErrorCode.UNKNOWN)) {
            return EvernoteMessages.EvernoteExportJob_UnknownError_message;
        }
        if (errorCode.equals((Object)EDAMErrorCode.AUTH_EXPIRED)) {
            return EvernoteMessages.EvernoteExportJob_AuthExpired_message;
        }
        if (errorCode.equals((Object)EDAMErrorCode.INVALID_AUTH)) {
            return EvernoteMessages.EvernoteExportJob_InvalidAuth_message;
        }
        if (errorCode.equals((Object)EDAMErrorCode.QUOTA_REACHED)) {
            return NLS.bind((String)EvernoteMessages.EvernoteExportJob_QuotaReached_message_withMonthlyQuota, (Object)this.getMonthlyQuota());
        }
        if (errorCode.equals((Object)EDAMErrorCode.LIMIT_REACHED)) {
            return NLS.bind((String)EvernoteMessages.EvernoteExportJob_LimitReached_message_withMaximumNoteSize, (Object)this.getMaximumNoteSize());
        }
        if (message != null) {
            return NLS.bind((String)EvernoteMessages.EvernoteExportJob_OtherException_message_withErrorMessage, (Object)message);
        }
        return NLS.bind((String)EvernoteMessages.EvernoteExportJob_systemErrorText_withErrorMessage, (Object)errorCode.toString());
    }

    private IStatus error(EDAMUserException e) {
        EDAMErrorCode errorCode = e.getErrorCode();
        return new Status(2, "org.xmind.ui.evernote", errorCode.getValue(), this.getErrorMessage(errorCode, e.getParameter()), (Throwable)e);
    }

    private IStatus error(EDAMSystemException e) {
        EDAMErrorCode errorCode = e.getErrorCode();
        return new Status(2, "org.xmind.ui.evernote", errorCode.getValue(), this.getErrorMessage(errorCode, null), (Throwable)e);
    }

    private IStatus error(TTransportException e) {
        return new Status(2, "org.xmind.ui.evernote", NLS.bind((String)EvernoteMessages.EvernoteExportJob_networkErrorText_withErrorMessage, (Object)e.getMessage()), (Throwable)e);
    }

    private long getMonthlyQuota() {
        long monthlyQuota = this.user.getAccounting().getUploadLimit();
        return this.byteToMB(monthlyQuota);
    }

    private long getMaximumNoteSize() {
        PremiumInfo info = this.user.getPremiumInfo();
        BusinessUserInfo businessInfo = this.user.getBusinessUserInfo();
        if (info != null && info.isPremium()) {
            return this.byteToMB(0x6400000L);
        }
        if (businessInfo != null) {
            return this.byteToMB(0x6400000L);
        }
        return this.byteToMB(0x1900000L);
    }

    private int byteToMB(long bytes) {
        return (int)bytes / 1024 / 1024;
    }
}

