/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.de.erichseifert.vectorgraphics2d.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public abstract class GraphicsUtils {
    protected GraphicsUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasAlpha(Image image) {
        ColorModel cm;
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            cm = bimage.getColorModel();
        } else {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            cm = pg.getColorModel();
        }
        return cm.hasAlpha();
    }

    public static boolean usesAlpha(Image image) {
        if (image == null) {
            return false;
        }
        BufferedImage bimage = GraphicsUtils.toBufferedImage(image);
        WritableRaster alphaRaster = bimage.getAlphaRaster();
        if (alphaRaster == null) {
            return false;
        }
        DataBuffer dataBuffer = alphaRaster.getDataBuffer();
        int i = 0;
        while (i < dataBuffer.getSize()) {
            int alpha = dataBuffer.getElem(i);
            if (alpha < 255) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static BufferedImage toBufferedImage(RenderedImage image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ColorModel cm = image.getColorModel();
        WritableRaster raster = cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight());
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = null;
        if (image.getPropertyNames() != null) {
            properties = new Hashtable<String, Object>();
            String[] stringArray = image.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                properties.put(key, image.getProperty(key));
                ++n2;
            }
        }
        BufferedImage bimage = new BufferedImage(cm, raster, isRasterPremultiplied, properties);
        image.copyData(raster);
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = GraphicsUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 3;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException headlessException) {
            bimage = null;
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

