/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;
import org.xmind.ui.internal.e4models.ModelPage;
import org.xmind.ui.internal.e4models.ViewModelFolderRenderer;
import org.xmind.ui.internal.e4models.ViewModelPart;

public class MultiPageModelPart
extends ViewModelPart {
    public static final String PERSISTED_STATE_PAGES_CONTRIBUTIONURI = "modelPart.pages.contributionUri";
    public static final String KEY_MODEL_PART_CURRENT_PAGE_ID = "org.xmind.ui.modelPart.currentPageId";
    protected static final String OWING_ME = "modelPage";
    private List<ModelPage> registeredModelPageItems;
    private CTabFolder ctf;

    @Override
    protected void createContent(Composite parent) {
        this.ctf = new CTabFolder(parent, 2048);
        this.ctf.setRenderer((CTabFolderRenderer)new ViewModelFolderRenderer(this.ctf));
        this.ctf.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ctf.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiPageModelPart.this.showModelPage((CTabItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        String pageId = (String)this.getAdapter(MPart.class).getPersistedState().get(KEY_MODEL_PART_CURRENT_PAGE_ID);
        CTabItem currentSelectedItem = null;
        for (ModelPage modelPage : this.registeredModelPageItems) {
            CTabItem cti = new CTabItem(this.ctf, 0);
            cti.setData(OWING_ME, (Object)modelPage);
            cti.setText(modelPage.getModelPageTitle());
            if (!modelPage.getModelPageId().equals(pageId)) continue;
            currentSelectedItem = cti;
        }
        if (currentSelectedItem == null) {
            currentSelectedItem = this.ctf.getItem(0);
        }
        this.ctf.setSelection(currentSelectedItem);
        this.showModelPage(currentSelectedItem);
        this.addTopRight(this.ctf, false);
        this.adjustViewMenuBar(false);
    }

    @Override
    protected void handleBringToTop() {
        super.handleBringToTop();
        if (this.ctf != null && !this.ctf.isDisposed()) {
            CTabItem[] items;
            String pageId = (String)this.getAdapter(MPart.class).getPersistedState().get(KEY_MODEL_PART_CURRENT_PAGE_ID);
            CTabItem itemToShow = null;
            CTabItem[] cTabItemArray = items = this.ctf.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                Object modelPage = item.getData(OWING_ME);
                if (modelPage instanceof ModelPage && ((ModelPage)modelPage).getModelPageId().equals(pageId)) {
                    itemToShow = item;
                    break;
                }
                ++n2;
            }
            if (itemToShow == null && this.ctf.getItemCount() > 0) {
                itemToShow = this.ctf.getItem(0);
            }
            this.ctf.setSelection(itemToShow);
            this.showModelPage(itemToShow);
        }
    }

    private void showModelPage(CTabItem cti) {
        Object modelPage = cti.getData(OWING_ME);
        if (modelPage instanceof ModelPage) {
            ModelPage modelPageItem = (ModelPage)modelPage;
            Control control = modelPageItem.getControl();
            if (control == null || control.isDisposed()) {
                modelPageItem.createControl((Composite)this.ctf);
                cti.setControl(modelPageItem.getControl());
            }
            if (modelPageItem.getControl().getParent() != this.ctf) {
                control.setParent((Composite)this.ctf);
            }
            this.setSelectionProvider(modelPageItem.getAdapter(ISelectionProvider.class));
            String pageId = modelPageItem.getModelPageId();
            this.getAdapter(MPart.class).getPersistedState().put(KEY_MODEL_PART_CURRENT_PAGE_ID, pageId);
            this.adjustViewMenuBar(false);
        }
    }

    @Override
    protected MMenu getViewMenu(MPart part) {
        if (this.ctf == null) {
            return null;
        }
        if (part == null || part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            boolean viewMenu = menu.getTags().contains("ViewMenu");
            String pageId = this.getCurrentModelPageItem().getModelPageId();
            boolean ofThePage = menu.getTags().contains(pageId);
            if (!viewMenu || !ofThePage) continue;
            return menu;
        }
        return null;
    }

    private ModelPage getCurrentModelPageItem() {
        return (ModelPage)this.ctf.getSelection().getData(OWING_ME);
    }

    @Override
    protected void init() {
        super.init();
        this.registeredModelPageItems = new ArrayList<ModelPage>();
        Map persistedState = this.getAdapter(MPart.class).getPersistedState();
        String originPages = (String)persistedState.get(PERSISTED_STATE_PAGES_CONTRIBUTIONURI);
        if (originPages != null) {
            String[] pages;
            String[] stringArray = pages = originPages.split(",");
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                String page = stringArray[n2];
                ModelPage modelPage = (ModelPage)this.readPage(page);
                this.registeredModelPageItems.add(modelPage);
                ++n2;
            }
        }
    }

    private Object readPage(String pageUri) {
        Class cls;
        String contributionURI = pageUri;
        if (contributionURI == null || !contributionURI.startsWith("bundleclass://")) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String[] contributionPaths = contributionURI.substring(14).split("/");
        if (contributionPaths.length != 2) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String bundleId = contributionPaths[0];
        String className = contributionPaths[1];
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                throw new ClassNotFoundException();
            }
            cls = bundle.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object contribution = ContextInjectionFactory.make((Class)cls, (IEclipseContext)this.getAdapter(MPart.class).getContext());
        return contribution;
    }

    @Override
    protected void setFocus() {
        super.setFocus();
        if (this.ctf == null) {
            return;
        }
        ModelPage pageItem = this.getCurrentModelPageItem();
        pageItem.setFocus();
    }
}

