/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MDialog;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.framework.FrameworkUtil;

public class ProgressProcessor {
    private static final String DIALOG_PREFIX = "DIALOG:";
    private static final String CUSTOM_LOCATION_KEY = "customLocation";
    private static final int DEFAULT_DIALOG_Y = 0;
    private static final int DEFAULT_DIALOG_X = 0;
    private static final int DEFAULT_DIALOG_WIDTH = 600;
    private static final int DEFAULT_DIALOG_HEIGHT = 700;

    @Execute
    public void execute(EModelService modelService, MApplication application) {
        MPart part;
        List parts;
        MPartStack partStack;
        List partStacks;
        String partId = "org.eclipse.ui.views.ProgressView";
        String partStackId = "org.xmind.ui.stack.progress";
        MPartDescriptor partDescriptor = null;
        for (MPartDescriptor mp : application.getDescriptors()) {
            if (!partId.equals(mp.getElementId())) continue;
            partDescriptor = mp;
            break;
        }
        if (partDescriptor == null) {
            return;
        }
        List existingDialogs = modelService.findElements((MUIElement)application, DIALOG_PREFIX + partId, MDialog.class, null);
        boolean dialogExisted = !existingDialogs.isEmpty();
        MDialog dialogModel = dialogExisted ? (MDialog)existingDialogs.get(0) : this.createDialog(modelService, partDescriptor, partId);
        dialogModel.setToBeRendered(false);
        if (!dialogExisted) {
            ((MWindow)application.getChildren().get(0)).getWindows().add(dialogModel);
        }
        boolean partStackExisted = !(partStacks = modelService.findElements((MUIElement)dialogModel, partStackId, MPartStack.class, null)).isEmpty();
        MPartStack mPartStack = partStack = partStackExisted ? (MPartStack)partStacks.get(0) : this.createPartStack(modelService, partStackId);
        if (!partStackExisted) {
            dialogModel.getChildren().add(partStack);
        }
        boolean partExisted = !(parts = modelService.findElements((MUIElement)partStack, partId, MPart.class, null)).isEmpty();
        MPart mPart = part = partExisted ? (MPart)parts.get(0) : null;
        if (part == null) {
            part = (MPart)modelService.createModelElement(MPart.class);
            part.setElementId(partId);
            part.setContributionURI(partDescriptor.getContributionURI());
            partStack.getChildren().add(part);
            partStack.setSelectedElement((MUIElement)part);
        }
    }

    private MDialog createDialog(EModelService modelService, MPartDescriptor partDescriptor, String partId) {
        String contributorURI = "platform:/plugin/" + FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        MDialog dialogModel = (MDialog)modelService.createModelElement(MDialog.class);
        dialogModel.setElementId(DIALOG_PREFIX + partId);
        dialogModel.setLabel(partDescriptor.getLabel());
        dialogModel.setContributorURI(contributorURI);
        String dialogStyle = (String)partDescriptor.getPersistedState().get("styleOverride");
        dialogModel.getPersistedState().put("styleOverride", dialogStyle);
        this.configDialog(dialogModel, partDescriptor);
        return dialogModel;
    }

    private void configDialog(MDialog dialogModel, MPartDescriptor partDescriptor) {
        String[] locations;
        String location = (String)dialogModel.getPersistedState().get("org.xmind.ui.dialogPart.customLocation");
        if (location == null || location.equals("")) {
            location = (String)partDescriptor.getPersistedState().get("org.xmind.ui.dialogPart.customLocation");
        }
        if ((locations = (location = location == null ? "" : location).split(",")).length < 4) {
            String[] tempLocations = new String[4];
            int i = 0;
            while (i < locations.length) {
                tempLocations[i] = locations[i];
                ++i;
            }
            locations = tempLocations;
        }
        int dialogX = this.getDigitalValue(locations[0], 0);
        int dialogY = this.getDigitalValue(locations[1], 0);
        int dialogW = this.getDigitalValue(locations[2], 600);
        int dialogH = this.getDigitalValue(locations[3], 700);
        dialogModel.setX(dialogX);
        dialogModel.setY(dialogY);
        dialogModel.setWidth(dialogW);
        dialogModel.setHeight(dialogH);
        dialogModel.getPersistedState().put("org.xmind.ui.dialogPart.customLocation", location);
    }

    private int getDigitalValue(String value, int defaultValue) {
        return this.isNone(value) ? defaultValue : Integer.valueOf(value);
    }

    private boolean isNone(String value) {
        return value == null || "".equals(value);
    }

    private MPartStack createPartStack(EModelService modelService, String partStackId) {
        MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        partStack.setElementId(partStackId);
        partStack.setVisible(true);
        partStack.getTags().add("XStack");
        return partStack;
    }
}

