/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.ui.gantt2.gefext.HandleFigure;
import org.xmind.ui.gantt2.gefext.SelectionFeedback;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.TaskBarPart;

public class TaskBarProgressFeedback
extends SelectionFeedback {
    private IFigure moveHandle;

    public TaskBarPart getHost() {
        return (TaskBarPart)super.getHost();
    }

    protected IFigure getMainFigure() {
        return this.getHost().getProgressFigure();
    }

    public void activate() {
        super.activate();
        this.moveHandle = this.registerHandle((IFigure)new MoveProgressHandle(this.getMainFigure()), GEF.LAYER_HANDLE);
        this.moveHandle.addMouseMotionListener((MouseMotionListener)new HandleToolTipHook());
    }

    public void deactivate() {
        this.unregisterHandle(this.moveHandle);
        super.deactivate();
    }

    protected void onPreselected() {
        super.onPreselected();
        if (this.isMainFigureAvailable()) {
            this.activateHandles(this.moveHandle);
        }
    }

    protected void onDepreselected() {
        this.deactivateHandles(this.moveHandle);
        super.onDepreselected();
    }

    private boolean isMainFigureAvailable() {
        return this.getHost().getBarFigure().isVisible();
    }

    private class HandleToolTipHook
    extends MouseMotionListener.Stub {
        private HandleToolTipHook() {
        }

        public void mouseEntered(MouseEvent me) {
            TaskBarProgressFeedback.this.getHost().addTooltipRequester((Object)this);
        }

        public void mouseExited(MouseEvent me) {
            TaskBarProgressFeedback.this.getHost().removeTooltipRequester((Object)this);
        }
    }

    private class MoveProgressHandle
    extends HandleFigure {
        public MoveProgressHandle(IFigure host) {
            this.setHost(host);
            this.setBackgroundColor(Colors.moveHandleBackground());
            this.setForegroundColor(Colors.moveHandleBorder());
            this.setOpaque(false);
        }

        protected void calculateBounds(Rectangle source, Rectangle target) {
            int r = 4;
            target.width = target.height = r + r;
            target.x = source.x + source.width - r;
            target.y = source.y + source.height / 2 - r;
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.fillOval(this.getBounds());
            graphics.drawOval(this.getBounds().getResized(-1, -1));
        }
    }
}

