/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.ui.internal.auth;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.xmind.core.IAccount;
import net.xmind.core.internal.Account;
import net.xmind.signin.XMindNet;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.Messages;
import net.xmind.ui.internal.auth.CredentialsInput;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.net.http.HttpException;
import org.xmind.ui.resources.ColorUtils;

public class AuthenticationDialog
extends TitleAreaDialog {
    private IAccount account;
    private String message;
    private CredentialsInput credentialsInput;
    private ProgressMonitorPart progressPart;
    private boolean authenticating;
    private ResourceManager resources;

    public AuthenticationDialog(Shell parentShell, IAccount account, String message) {
        super(parentShell);
        Assert.isLegal((account != null ? 1 : 0) != 0);
        this.account = account;
        this.message = message;
        this.authenticating = false;
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.setBlockOnOpen(true);
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.AuthenticationDialog_shell_title);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getShell());
        ImageDescriptor logoImage = XMindNet.getBannerLogoImage();
        if (logoImage != null) {
            this.setTitleImage((Image)resources.get((DeviceResourceDescriptor)logoImage));
        }
        this.setTitle(Messages.AuthenticationDialog_title);
        if (this.message == null) {
            this.setMessage(Messages.AuthenticationDialog_message);
        } else {
            this.setMessage(this.message);
        }
        String userName = (String)this.account.getProperty("user");
        if (userName != null) {
            this.credentialsInput.setUserName(userName);
        }
        this.updateButtons();
        this.credentialsInput.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Control form = this.createForm(composite);
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private Control createForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 30;
        layout.marginTop = 15;
        layout.marginBottom = 5;
        layout.verticalSpacing = 7;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.credentialsInput = new CredentialsInput(composite);
        this.credentialsInput.setLayoutData(new GridData(4, 4, true, true));
        this.credentialsInput.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AuthenticationDialog.this.updateButtons();
                AuthenticationDialog.this.setErrorMessage(null);
            }
        });
        this.progressPart = new ProgressMonitorPart(composite, null);
        this.progressPart.setVisible(false);
        this.progressPart.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.progressPart.getLayoutData()).exclude = true;
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite.setFont(parent.getFont());
        Control signUpControl = this.createSignUpControl(composite);
        ((GridData)signUpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        Control buttonSection = super.createButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    private Control createSignUpControl(Composite parent) {
        Hyperlink link = new Hyperlink(parent, 0);
        link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
        link.setUnderlined(true);
        link.setText(Messages.AuthenticationDialog_signUp_link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                XMindNet.gotoURL(Activator.URL_SIGN_UP, new Object[0]);
            }
        });
        link.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        parent.setFocus();
        return link;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.SignInDialog_SignIn_text, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void okPressed() {
        boolean canceled;
        Button cancelButton;
        block13: {
            Shell shell = this.getShell();
            Control focusControl = shell.getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != shell) {
                focusControl = null;
            }
            String userName = this.credentialsInput.getUserName();
            String password = this.credentialsInput.getPassword();
            final Object credentials = this.account.newCredentialsBuilder().withUserName(userName).withPassword(password).buildCredentials();
            this.updateButton(0, false);
            cancelButton = this.getButton(1);
            this.credentialsInput.setEnabled(false);
            this.progressPart.attachToCancelComponent((Control)cancelButton);
            this.authenticating = true;
            canceled = false;
            try {
                ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            AuthenticationDialog.this.account.authenticate(monitor, credentials);
                        }
                        catch (HttpException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }, (boolean)true, (IProgressMonitor)this.progressPart, (Display)shell.getDisplay());
                if (!this.progressPart.isCanceled()) {
                    super.okPressed();
                    this.authenticating = false;
                    return;
                }
            }
            catch (InvocationTargetException e) {
                this.handleError(e);
                this.authenticating = false;
                break block13;
            }
            catch (InterruptedException interruptedException) {
                canceled = true;
                break block13;
                catch (OperationCanceledException operationCanceledException) {
                    canceled = true;
                    this.authenticating = false;
                    break block13;
                }
                finally {
                    this.authenticating = false;
                }
            }
            {
                canceled = true;
            }
            this.authenticating = false;
        }
        this.progressPart.removeFromCancelComponent((Control)cancelButton);
        this.progressPart.done();
        if (canceled) {
            this.cancelPressed();
            return;
        }
        this.credentialsInput.setEnabled(true);
        this.updateButtons();
    }

    protected void cancelPressed() {
        if (this.authenticating) {
            return;
        }
        super.cancelPressed();
    }

    private void handleError(Throwable e) {
        int code;
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        String errorMessage = e instanceof HttpException ? ((code = ((HttpException)e).getCode()) < 100 ? Messages.SignInDialog_NetworkError_message : (code < 400 ? Messages.SignInDialog_ApplicationError_message : (code < 500 ? Messages.SignInDialog_RequestError_message : (code < 600 ? Messages.SignInDialog_ServerError_message : Messages.SignInDialog_ApplicationError_message)))) : (e instanceof IOException ? Messages.SignInDialog_NetworkError_message : e.getLocalizedMessage());
        this.setErrorMessage(errorMessage);
    }

    private void updateButtons() {
        String userName = this.credentialsInput.getUserName();
        String password = this.credentialsInput.getPassword();
        this.updateButton(0, userName != null && !"".equals(userName) && password != null && !"".equals(password));
        this.updateButton(1, true);
    }

    private void updateButton(int buttonId, boolean enabled) {
        Button button = this.getButton(buttonId);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        AuthenticationDialog dialog = new AuthenticationDialog(null, (IAccount)new Account(), null);
        dialog.open();
        display.dispose();
    }
}

