/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.time.Duration;
import java.util.Optional;
import org.gradle.caching.internal.BuildCacheKeyInternal;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.ExecutionOutputState;
import org.gradle.internal.execution.history.impl.DefaultExecutionOutputState;
import org.gradle.internal.execution.steps.AfterExecutionOutputFilter;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class CaptureOutputsAfterExecutionStep<C extends WorkspaceContext>
extends BuildOperationStep<C, AfterExecutionResult> {
    private final UniqueId buildInvocationScopeId;
    private final OutputSnapshotter outputSnapshotter;
    private final AfterExecutionOutputFilter<? super C> outputFilter;
    private final Step<? super C, ? extends Result> delegate;

    public CaptureOutputsAfterExecutionStep(BuildOperationExecutor buildOperationExecutor, UniqueId buildInvocationScopeId, OutputSnapshotter outputSnapshotter, AfterExecutionOutputFilter<? super C> outputFilter, Step<? super C, ? extends Result> delegate) {
        super(buildOperationExecutor);
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.outputSnapshotter = outputSnapshotter;
        this.outputFilter = outputFilter;
        this.delegate = delegate;
    }

    @Override
    public AfterExecutionResult execute(UnitOfWork work, C context) {
        Result result = this.delegate.execute(work, context);
        Optional<ExecutionOutputState> afterExecutionOutputState = ((CachingContext)context).getCachingState().getCacheKeyCalculatedState().map(cacheKeyCalculatedState -> this.captureOutputsAfterExecution(work, context, (CachingState.CacheKeyCalculatedState)cacheKeyCalculatedState, result));
        return new AfterExecutionResult(result, afterExecutionOutputState.orElse(null));
    }

    private ExecutionOutputState captureOutputsAfterExecution(UnitOfWork work, C context, CachingState.CacheKeyCalculatedState cacheKeyCalculatedState, Result result) {
        return this.operation(operationContext -> {
            Timer timer = Time.startTimer();
            ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
            ImmutableSortedMap<String, FileSystemSnapshot> outputsProducedByWork = this.outputFilter.filterOutputs((WorkspaceContext)context, cacheKeyCalculatedState.getBeforeExecutionState(), unfilteredOutputSnapshotsAfterExecution);
            OriginMetadata originMetadata = this.createOriginMetadata(cacheKeyCalculatedState, result, timer);
            operationContext.setResult((Object)Operation.Result.INSTANCE);
            return new DefaultExecutionOutputState(result.getExecution().isSuccessful(), outputsProducedByWork, originMetadata, false);
        }, BuildOperationDescriptor.displayName((String)("Snapshot outputs after executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    private OriginMetadata createOriginMetadata(CachingState.CacheKeyCalculatedState cacheKeyCalculatedState, Result result, Timer timer) {
        long snapshotOutputDuration = timer.getElapsedMillis();
        Duration originExecutionTime = result.getDuration().plus(Duration.ofMillis(snapshotOutputDuration));
        HashCode buildCacheKey = ((BuildCacheKeyInternal)cacheKeyCalculatedState.getKey()).getHashCodeInternal();
        return new OriginMetadata(this.buildInvocationScopeId.asString(), buildCacheKey, originExecutionTime);
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

