/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.TreeMap;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.AmbiguousGraphVariantsException;
import org.gradle.internal.component.model.AttributeDescriberSelector;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.resolution.failure.CapabilitiesDescriber;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.VariantAwareAmbiguousResolutionFailure;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AmbiguousGraphVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<AmbiguousGraphVariantsException, VariantAwareAmbiguousResolutionFailure> {
    private static final String AMBIGUOUS_VARIANTS_PREFIX = "Ambiguity errors are explained in more detail at ";
    private static final String AMBIGUOUS_VARIANTS_SECTION = "sub:variant-ambiguity";

    @Override
    public AmbiguousGraphVariantsException describeFailure(VariantAwareAmbiguousResolutionFailure failure) {
        String message = this.buildAmbiguousGraphVariantsFailureMsg(failure);
        AmbiguousGraphVariantsException result = new AmbiguousGraphVariantsException(message);
        this.suggestSpecificDocumentation(result, AMBIGUOUS_VARIANTS_PREFIX, AMBIGUOUS_VARIANTS_SECTION);
        this.suggestReviewAlgorithm(result);
        return result;
    }

    private String buildAmbiguousGraphVariantsFailureMsg(VariantAwareAmbiguousResolutionFailure failure) {
        AttributeDescriber describer = AttributeDescriberSelector.selectDescriber((AttributeContainerInternal)failure.getRequestedAttributes(), failure.getSchema());
        TreeMap<String, ResolutionCandidateAssessor.AssessedCandidate> ambiguousVariants = new TreeMap<String, ResolutionCandidateAssessor.AssessedCandidate>();
        for (ResolutionCandidateAssessor.AssessedCandidate candidate : failure.getCandidates()) {
            ambiguousVariants.put(candidate.getDisplayName(), candidate);
        }
        TreeFormatter formatter = new TreeFormatter();
        if (failure.getRequestedAttributes().isEmpty()) {
            formatter.node("Cannot choose between the following variants of ");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(failure.getRequestedAttributes().asMap()) + ". However we cannot choose between the following variants of ");
        }
        formatter.append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)failure.getRequestedName()));
        formatter.startChildren();
        for (String configuration : ambiguousVariants.keySet()) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : ambiguousVariants.values()) {
            this.formatUnselectable(assessedCandidate, formatter, failure.getTargetComponent(), describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private void formatUnselectable(ResolutionCandidateAssessor.AssessedCandidate assessedCandidate, TreeFormatter formatter, ComponentGraphResolveMetadata targetComponent, AttributeDescriber describer) {
        formatter.node("Variant '");
        formatter.append((CharSequence)assessedCandidate.getDisplayName());
        formatter.append((CharSequence)"'");
        formatter.append((CharSequence)(" " + CapabilitiesDescriber.describeCapabilitiesWithTitle(targetComponent, assessedCandidate.getCandidateCapabilities().asSet())));
        this.formatAttributeMatchesForAmbiguity(assessedCandidate, formatter, describer);
    }
}

