/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.PackageState;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class PackageSorter {
    private static final Log LOGGER = LogFactory.getLog(PackageSorter.class);

    private PackageSorter() {
    }

    public static void sort(List modules) {
        int i;
        if (modules == null) {
            throw new NullPointerException();
        }
        HashMap<String, SortModule> moduleMap = new HashMap<String, SortModule>();
        ArrayList<PackageState> errorModules = new ArrayList<PackageState>();
        ArrayList<SortModule> weightModules = new ArrayList<SortModule>();
        int modulesCount = modules.size();
        for (int i2 = 0; i2 < modulesCount; ++i2) {
            PackageState state = (PackageState)modules.get(i2);
            if (state.getState() == -2) {
                errorModules.add(state);
                continue;
            }
            SortModule mod = new SortModule(state);
            weightModules.add(mod);
            moduleMap.put(state.getModule().getModuleClass(), mod);
        }
        Object[] weigths = weightModules.toArray(new SortModule[weightModules.size()]);
        for (int i3 = 0; i3 < weigths.length; ++i3) {
            SortModule sortMod = weigths[i3];
            sortMod.setDependSubsystems(PackageSorter.collectSubsystemModules(sortMod.getState().getModule(), moduleMap));
        }
        boolean doneWork = true;
        while (doneWork) {
            doneWork = false;
            for (int i4 = 0; i4 < weigths.length; ++i4) {
                Object mod = weigths[i4];
                int position = PackageSorter.searchModulePosition((SortModule)mod, moduleMap);
                if (position == ((SortModule)mod).getPosition()) continue;
                ((SortModule)mod).setPosition(position);
                doneWork = true;
            }
        }
        Arrays.sort(weigths);
        modules.clear();
        for (i = 0; i < weigths.length; ++i) {
            modules.add(((SortModule)weigths[i]).getState());
        }
        for (i = 0; i < errorModules.size(); ++i) {
            modules.add(errorModules.get(i));
        }
    }

    private static int searchModulePosition(SortModule smodule, HashMap moduleMap) {
        Module module = smodule.getState().getModule();
        int position = 0;
        ModuleInfo[] optionalModules = module.getOptionalModules();
        for (int modPos = 0; modPos < optionalModules.length; ++modPos) {
            String moduleName = optionalModules[modPos].getModuleClass();
            SortModule reqMod = (SortModule)moduleMap.get(moduleName);
            if (reqMod == null || reqMod.getPosition() < position) continue;
            position = reqMod.getPosition() + 1;
        }
        ModuleInfo[] requiredModules = module.getRequiredModules();
        for (int modPos = 0; modPos < requiredModules.length; ++modPos) {
            String moduleName = requiredModules[modPos].getModuleClass();
            SortModule reqMod = (SortModule)moduleMap.get(moduleName);
            if (reqMod == null) {
                LOGGER.warn((Object)("Invalid state: Required dependency of '" + moduleName + "' had an error."));
                continue;
            }
            if (reqMod.getPosition() < position) continue;
            position = reqMod.getPosition() + 1;
        }
        String subSystem = module.getSubSystem();
        for (SortModule mod : moduleMap.values()) {
            Module subSysMod;
            if (mod.getState().getModule() == module || ObjectUtilities.equal(subSystem, (subSysMod = mod.getState().getModule()).getSubSystem()) || !smodule.getDependSubsystems().contains(subSysMod.getSubSystem()) || PackageSorter.isBaseModule(subSysMod, module) || mod.getPosition() < position) continue;
            position = mod.getPosition() + 1;
        }
        return position;
    }

    private static boolean isBaseModule(Module mod, ModuleInfo mi) {
        ModuleInfo[] requiredModules = mod.getRequiredModules();
        for (int i = 0; i < requiredModules.length; ++i) {
            if (!requiredModules[i].getModuleClass().equals(mi.getModuleClass())) continue;
            return true;
        }
        ModuleInfo[] optionalModules = mod.getOptionalModules();
        for (int i = 0; i < optionalModules.length; ++i) {
            if (!optionalModules[i].getModuleClass().equals(mi.getModuleClass())) continue;
            return true;
        }
        return false;
    }

    private static ArrayList collectSubsystemModules(Module childMod, HashMap moduleMap) {
        ArrayList<String> collector = new ArrayList<String>();
        ModuleInfo[] requiredModules = childMod.getRequiredModules();
        for (int i = 0; i < requiredModules.length; ++i) {
            SortModule dependentModule = (SortModule)moduleMap.get(requiredModules[i].getModuleClass());
            if (dependentModule == null) {
                LOGGER.warn((Object)("A dependent module was not found in the list of known modules." + requiredModules[i].getModuleClass()));
                continue;
            }
            collector.add(dependentModule.getState().getModule().getSubSystem());
        }
        ModuleInfo[] optionalModules = childMod.getOptionalModules();
        for (int i = 0; i < optionalModules.length; ++i) {
            Module dependentModule = (Module)moduleMap.get(optionalModules[i].getModuleClass());
            if (dependentModule == null) {
                LOGGER.warn((Object)"A dependent module was not found in the list of known modules.");
                continue;
            }
            collector.add(dependentModule.getSubSystem());
        }
        return collector;
    }

    private static class SortModule
    implements Comparable {
        private int position = -1;
        private final PackageState state;
        private ArrayList dependSubsystems;

        private SortModule(PackageState state) {
            this.state = state;
        }

        public ArrayList getDependSubsystems() {
            return this.dependSubsystems;
        }

        public void setDependSubsystems(ArrayList dependSubsystems) {
            this.dependSubsystems = dependSubsystems;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public PackageState getState() {
            return this.state;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("SortModule: ");
            buffer.append(this.position);
            buffer.append(' ');
            buffer.append(this.state.getModule().getName());
            buffer.append(' ');
            buffer.append(this.state.getModule().getModuleClass());
            return buffer.toString();
        }

        public int compareTo(Object o) {
            SortModule otherModule = (SortModule)o;
            if (this.position > otherModule.position) {
                return 1;
            }
            if (this.position < otherModule.position) {
                return -1;
            }
            return 0;
        }
    }
}

