/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import net.sf.ehcache.Element;
import net.sf.jsr107cache.CacheEntry;

public class JCacheEntry
implements CacheEntry {
    private Element element;

    public JCacheEntry(Element element) {
        this.element = element;
    }

    public Object getKey() throws IllegalStateException {
        if (this.element != null) {
            return this.element.getObjectKey();
        }
        return null;
    }

    public Object getValue() throws IllegalStateException {
        if (this.element != null) {
            return this.element.getObjectValue();
        }
        return null;
    }

    public Object setValue(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Ehcache does not support modification of Elements. They are immutable.");
    }

    public long getCost() {
        return 0L;
    }

    public long getCreationTime() {
        if (this.element != null) {
            return this.element.getCreationTime();
        }
        return 0L;
    }

    public long getExpirationTime() {
        if (this.element != null) {
            return this.element.getExpirationTime();
        }
        return 0L;
    }

    public int getHits() {
        if (this.element != null) {
            return (int)this.element.getHitCount();
        }
        return 0;
    }

    public long getLastAccessTime() {
        if (this.element != null) {
            return this.element.getLastAccessTime();
        }
        return 0L;
    }

    public long getLastUpdateTime() {
        if (this.element != null) {
            return this.element.getLastUpdateTime();
        }
        return 0L;
    }

    public long getVersion() {
        if (this.element != null) {
            return this.element.getVersion();
        }
        return 0L;
    }

    public boolean isValid() {
        if (this.element != null) {
            return !this.element.isExpired();
        }
        return false;
    }
}

