/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollectorKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/StableNamesCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "()V", "memberNames", "", "", "getMemberNames", "()Ljava/util/Set;", "staticNames", "getStaticNames", "stableNameForExternalDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "stableNameForNonExternalDeclaration", "visitDeclaration", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "backend.js"})
public final class StableNamesCollector
implements IrElementVisitorVoid {
    @NotNull
    private final Set<String> staticNames;
    @NotNull
    private final Set<String> memberNames;

    @NotNull
    public final Set<String> getStaticNames() {
        return this.staticNames;
    }

    @NotNull
    public final Set<String> getMemberNames() {
        return this.memberNames;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
        if (!(declaration2 instanceof IrDeclarationWithName)) {
            return;
        }
        Set<String> scope = MiscKt.hasStaticDispatch(declaration2) ? this.staticNames : this.memberNames;
        String stableName = IrUtilsKt.isEffectivelyExternal(declaration2) ? this.stableNameForExternalDeclaration((IrDeclarationWithName)declaration2) : this.stableNameForNonExternalDeclaration((IrDeclarationWithName)declaration2);
        CollectionsKt.addIfNotNull((Collection)scope, stableName);
    }

    private final String stableNameForNonExternalDeclaration(IrDeclarationWithName declaration2) {
        return AnnotationUtilsKt.getJsName(declaration2);
    }

    private final String stableNameForExternalDeclaration(IrDeclarationWithName declaration2) {
        if (AdditionalIrUtilsKt.isPropertyAccessor(declaration2) || AdditionalIrUtilsKt.isPropertyField(declaration2) || declaration2 instanceof IrConstructor) {
            return null;
        }
        boolean importedFromModuleOnly = AnnotationUtilsKt.getJsModule(declaration2) != null && !AnnotationUtilsKt.isJsNonModule(declaration2);
        String jsName = AnnotationUtilsKt.getJsName(declaration2);
        String jsQualifier = AnnotationUtilsKt.getJsQualifier(declaration2);
        return importedFromModuleOnly ? null : (jsQualifier != null ? (String)StringsKt.split$default((CharSequence)jsQualifier, (char[])new char[]{'1'}, (boolean)false, (int)0, (int)6, null).get(0) : (jsName != null ? jsName : declaration2.getName().getIdentifier()));
    }

    public StableNamesCollector() {
        Set set;
        StableNamesCollector stableNamesCollector = this;
        boolean bl = false;
        stableNamesCollector.staticNames = set = (Set)new LinkedHashSet();
        stableNamesCollector = this;
        bl = false;
        stableNamesCollector.memberNames = set = (Set)new LinkedHashSet();
        this.staticNames.addAll((Collection<String>)StableNamesCollectorKt.getRESERVED_IDENTIFIERS());
        this.staticNames.add(Namer.INSTANCE.getIMPLICIT_RECEIVER_NAME());
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
    }

    @Override
    public void visitBody(@NotNull IrBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
    }

    @Override
    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitSetVariable(@NotNull IrSetVariable expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
    }

    @Override
    public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

